/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.Link;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.constraint.LinkTypeConstraint;

public class PointToPointIntent
extends ConnectivityIntent {
    private final ConnectPoint ingressPoint;
    private final ConnectPoint egressPoint;

    public PointToPointIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, ConnectPoint egressPoint) {
        this(appId, selector, treatment, ingressPoint, egressPoint, (List<Constraint>)ImmutableList.of((Object)new LinkTypeConstraint(false, Link.Type.OPTICAL)));
    }

    public PointToPointIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, ConnectPoint egressPoint, List<Constraint> constraints) {
        super(appId, null, selector, treatment, constraints);
        Preconditions.checkNotNull((Object)ingressPoint);
        Preconditions.checkNotNull((Object)egressPoint);
        Preconditions.checkArgument((!ingressPoint.equals(egressPoint) ? 1 : 0) != 0, (String)"ingress and egress should be different (ingress: %s, egress: %s)", (Object[])new Object[]{ingressPoint, egressPoint});
        this.ingressPoint = ingressPoint;
        this.egressPoint = egressPoint;
    }

    protected PointToPointIntent() {
        this.ingressPoint = null;
        this.egressPoint = null;
    }

    public ConnectPoint ingressPoint() {
        return this.ingressPoint;
    }

    public ConnectPoint egressPoint() {
        return this.egressPoint;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("appId", (Object)this.appId()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("ingress", (Object)this.ingressPoint).add("egress", (Object)this.egressPoint).add("constraints", this.constraints()).toString();
    }
}

