/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.ConnectivityIntent;
import org.onosproject.net.intent.Constraint;

public class SinglePointToMultiPointIntent
extends ConnectivityIntent {
    private final ConnectPoint ingressPoint;
    private final Set<ConnectPoint> egressPoints;

    public SinglePointToMultiPointIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, Set<ConnectPoint> egressPoints) {
        this(appId, selector, treatment, ingressPoint, egressPoints, Collections.emptyList());
    }

    public SinglePointToMultiPointIntent(ApplicationId appId, TrafficSelector selector, TrafficTreatment treatment, ConnectPoint ingressPoint, Set<ConnectPoint> egressPoints, List<Constraint> constraints) {
        super(appId, null, selector, treatment, constraints);
        Preconditions.checkNotNull(egressPoints);
        Preconditions.checkNotNull((Object)ingressPoint);
        Preconditions.checkArgument((!egressPoints.isEmpty() ? 1 : 0) != 0, (Object)"Egress point set cannot be empty");
        Preconditions.checkArgument((!egressPoints.contains(ingressPoint) ? 1 : 0) != 0, (String)"Set of egresses should not contain ingress (ingress: %s)", (Object[])new Object[]{ingressPoint});
        this.ingressPoint = (ConnectPoint)Preconditions.checkNotNull((Object)ingressPoint);
        this.egressPoints = Sets.newHashSet(egressPoints);
    }

    protected SinglePointToMultiPointIntent() {
        this.ingressPoint = null;
        this.egressPoints = null;
    }

    public ConnectPoint ingressPoint() {
        return this.ingressPoint;
    }

    public Set<ConnectPoint> egressPoints() {
        return this.egressPoints;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("id", (Object)this.id()).add("appId", (Object)this.appId()).add("selector", (Object)this.selector()).add("treatment", (Object)this.treatment()).add("ingress", (Object)this.ingressPoint).add("egress", this.egressPoints).add("constraints", this.constraints()).toString();
    }
}

