/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.resource;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.Link;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.LinkResourceAllocations;
import org.onosproject.net.resource.LinkResourceRequest;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceRequest;
import org.onosproject.net.resource.ResourceType;

public class DefaultLinkResourceAllocations
implements LinkResourceAllocations {
    private final LinkResourceRequest request;
    private final Map<Link, Set<ResourceAllocation>> allocations;

    public DefaultLinkResourceAllocations(LinkResourceRequest request, Map<Link, Set<ResourceAllocation>> allocations) {
        this.request = (LinkResourceRequest)Preconditions.checkNotNull((Object)request);
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<Link, Set<ResourceAllocation>> e : allocations.entrySet()) {
            builder.put((Object)e.getKey(), (Object)ImmutableSet.copyOf((Collection)e.getValue()));
        }
        this.allocations = builder.build();
    }

    @Override
    public IntentId intendId() {
        return this.request.intendId();
    }

    @Override
    public Collection<Link> links() {
        return this.request.links();
    }

    @Override
    public Set<ResourceRequest> resources() {
        return this.request.resources();
    }

    @Override
    public ResourceType type() {
        return null;
    }

    @Override
    public Set<ResourceAllocation> getResourceAllocation(Link link) {
        Set<ResourceAllocation> result = this.allocations.get(link);
        if (result == null) {
            result = Collections.emptySet();
        }
        return result;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("allocations", this.allocations).toString();
    }
}

