/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.List;
import org.onosproject.store.service.ReadRequest;

public final class BatchReadRequest {
    private final List<ReadRequest> readRequests;

    public static BatchReadRequest create(List<ReadRequest> readRequests) {
        return new BatchReadRequest(readRequests);
    }

    private BatchReadRequest(List<ReadRequest> readRequests) {
        this.readRequests = ImmutableList.copyOf(readRequests);
    }

    public int batchSize() {
        return this.readRequests.size();
    }

    public List<ReadRequest> getAsList() {
        return this.readRequests;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("readRequests", this.readRequests).toString();
    }

    public static class Builder {
        private final List<ReadRequest> readRequests = Lists.newLinkedList();

        public Builder get(String tableName, String key) {
            this.readRequests.add(new ReadRequest(tableName, key));
            return this;
        }

        public BatchReadRequest build() {
            return new BatchReadRequest(this.readRequests);
        }
    }
}

