/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import java.util.List;
import org.onosproject.store.service.WriteResult;
import org.onosproject.store.service.WriteStatus;

public class BatchWriteResult {
    private final List<WriteResult> writeResults;

    public BatchWriteResult(List<WriteResult> writeResults) {
        this.writeResults = ImmutableList.copyOf(writeResults);
    }

    public boolean isSuccessful() {
        for (WriteResult result : this.writeResults) {
            if (result.status() == WriteStatus.OK) continue;
            return false;
        }
        return true;
    }

    public List<WriteResult> getAsList() {
        return this.writeResults;
    }

    public int batchSize() {
        return this.writeResults.size();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("writeResults", this.writeResults).toString();
    }
}

