/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class ReadRequest {
    private final String tableName;
    private final String key;

    public static ReadRequest get(String tableName, String key) {
        return new ReadRequest(tableName, key);
    }

    public ReadRequest(String tableName, String key) {
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName);
        this.key = (String)Preconditions.checkNotNull((Object)key);
    }

    public String tableName() {
        return this.tableName;
    }

    public String key() {
        return this.key;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("tableName", (Object)this.tableName).add("key", (Object)this.key).toString();
    }

    public int hashCode() {
        return Objects.hash(this.key, this.tableName);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReadRequest other = (ReadRequest)obj;
        return Objects.equals(this.key, other.key) && Objects.equals(this.tableName, other.tableName);
    }
}

