/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import java.util.Arrays;
import org.onlab.util.ByteArraySizeHashPrinter;

public class VersionedValue {
    private final byte[] value;
    private final long version;

    public VersionedValue(byte[] value, long version) {
        this.value = value;
        this.version = version;
    }

    public byte[] value() {
        return this.value;
    }

    public long version() {
        return this.version;
    }

    public static VersionedValue copy(VersionedValue original) {
        if (original == null) {
            return null;
        }
        if (original.value == null) {
            return original;
        }
        return new VersionedValue(Arrays.copyOf(original.value, original.value.length), original.version);
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("version", this.version).add("value", (Object)ByteArraySizeHashPrinter.orNull((byte[])this.value)).toString();
    }
}

