/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.service;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onlab.util.ByteArraySizeHashPrinter;

public class WriteRequest {
    public static final int ANY_VERSION = -1;
    private final String tableName;
    private final String key;
    private final Type type;
    private final byte[] newValue;
    private final long previousVersion;
    private final byte[] oldValue;

    public static WriteRequest put(String tableName, String key, byte[] newValue) {
        return new WriteRequest(Type.PUT, tableName, key, (byte[])Preconditions.checkNotNull((Object)newValue), -1L, null);
    }

    public static WriteRequest putIfVersionMatches(String tableName, String key, byte[] newValue, long previousVersion) {
        Preconditions.checkArgument((previousVersion >= 0L ? 1 : 0) != 0);
        return new WriteRequest(Type.PUT_IF_VERSION, tableName, key, (byte[])Preconditions.checkNotNull((Object)newValue), previousVersion, null);
    }

    public static WriteRequest putIfValueMatches(String tableName, String key, byte[] oldValue, byte[] newValue) {
        return new WriteRequest(Type.PUT_IF_VALUE, tableName, key, (byte[])Preconditions.checkNotNull((Object)newValue), -1L, (byte[])Preconditions.checkNotNull((Object)oldValue));
    }

    public static WriteRequest putIfAbsent(String tableName, String key, byte[] newValue) {
        return new WriteRequest(Type.PUT_IF_ABSENT, tableName, key, (byte[])Preconditions.checkNotNull((Object)newValue), -1L, null);
    }

    public static WriteRequest remove(String tableName, String key) {
        return new WriteRequest(Type.REMOVE, tableName, key, null, -1L, null);
    }

    public static WriteRequest removeIfVersionMatches(String tableName, String key, long previousVersion) {
        return new WriteRequest(Type.REMOVE_IF_VERSION, tableName, key, null, previousVersion, null);
    }

    public static WriteRequest removeIfValueMatches(String tableName, String key, byte[] oldValue) {
        return new WriteRequest(Type.REMOVE_IF_VALUE, tableName, key, null, -1L, (byte[])Preconditions.checkNotNull((Object)oldValue));
    }

    protected WriteRequest(Type type, String tableName, String key, byte[] newValue, long previousVersion, byte[] oldValue) {
        Preconditions.checkNotNull((Object)tableName);
        Preconditions.checkNotNull((Object)key);
        this.tableName = tableName;
        this.key = key;
        this.type = type;
        this.newValue = newValue;
        this.previousVersion = previousVersion;
        this.oldValue = oldValue;
    }

    public String tableName() {
        return this.tableName;
    }

    public String key() {
        return this.key;
    }

    public Type type() {
        return this.type;
    }

    public byte[] newValue() {
        return this.newValue;
    }

    public long previousVersion() {
        return this.previousVersion;
    }

    public byte[] oldValue() {
        return this.oldValue;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("type", (Object)this.type).add("tableName", (Object)this.tableName).add("key", (Object)this.key).add("newValue", (Object)ByteArraySizeHashPrinter.orNull((byte[])this.newValue)).add("previousVersion", this.previousVersion).add("oldValue", (Object)ByteArraySizeHashPrinter.orNull((byte[])this.oldValue)).toString();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.key, this.tableName, this.previousVersion});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WriteRequest other = (WriteRequest)obj;
        return Objects.equals((Object)this.type, (Object)other.type) && Objects.equals(this.key, other.key) && Objects.equals(this.tableName, other.tableName) && Objects.equals(this.previousVersion, other.previousVersion);
    }

    public static enum Type {
        PUT,
        PUT_IF_VERSION,
        PUT_IF_VALUE,
        PUT_IF_ABSENT,
        REMOVE,
        REMOVE_IF_VERSION,
        REMOVE_IF_VALUE;

    }
}

