/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event;

import java.util.List;
import java.util.Timer;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;
import org.onlab.junit.TestTools;
import org.onosproject.event.AbstractEventAccumulator;
import org.onosproject.event.Event;
import org.onosproject.event.TestEvent;

public class AbstractEventAccumulatorTest {
    private final Timer timer = new Timer();

    @Test
    public void basics() throws Exception {
        TestAccumulator accumulator = new TestAccumulator();
        Assert.assertEquals((String)"incorrect timer", (Object)this.timer, (Object)accumulator.timer());
        Assert.assertEquals((String)"incorrect max events", (long)5L, (long)accumulator.maxEvents());
        Assert.assertEquals((String)"incorrect max ms", (long)100L, (long)accumulator.maxBatchMillis());
        Assert.assertEquals((String)"incorrect idle ms", (long)50L, (long)accumulator.maxIdleMillis());
    }

    @Test
    public void eventTrigger() {
        TestAccumulator accumulator = new TestAccumulator();
        accumulator.add((Event)new TestEvent(TestEvent.Type.FOO, "a"));
        accumulator.add((Event)new TestEvent(TestEvent.Type.FOO, "b"));
        accumulator.add((Event)new TestEvent(TestEvent.Type.FOO, "c"));
        accumulator.add((Event)new TestEvent(TestEvent.Type.FOO, "d"));
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add((Event)new TestEvent(TestEvent.Type.FOO, "e"));
        TestTools.delay((int)10);
        Assert.assertFalse((String)"should have fired", (boolean)accumulator.batch.isEmpty());
        Assert.assertEquals((String)"incorrect batch", (Object)"abcde", (Object)accumulator.batch);
    }

    @Ignore(value="FIXME: timing sensitive test failing randomly.")
    @Test
    public void timeTrigger() {
        TestAccumulator accumulator = new TestAccumulator();
        accumulator.add((Event)new TestEvent(TestEvent.Type.FOO, "a"));
        TestTools.delay((int)30);
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add((Event)new TestEvent(TestEvent.Type.FOO, "b"));
        TestTools.delay((int)30);
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add((Event)new TestEvent(TestEvent.Type.FOO, "c"));
        TestTools.delay((int)30);
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add((Event)new TestEvent(TestEvent.Type.FOO, "d"));
        TestTools.delay((int)30);
        Assert.assertFalse((String)"should have fired", (boolean)accumulator.batch.isEmpty());
        Assert.assertEquals((String)"incorrect batch", (Object)"abcd", (Object)accumulator.batch);
    }

    @Test
    public void idleTrigger() {
        TestAccumulator accumulator = new TestAccumulator();
        accumulator.add((Event)new TestEvent(TestEvent.Type.FOO, "a"));
        Assert.assertTrue((String)"should not have fired yet", (boolean)accumulator.batch.isEmpty());
        accumulator.add((Event)new TestEvent(TestEvent.Type.FOO, "b"));
        TestTools.delay((int)80);
        Assert.assertFalse((String)"should have fired", (boolean)accumulator.batch.isEmpty());
        Assert.assertEquals((String)"incorrect batch", (Object)"ab", (Object)accumulator.batch);
    }

    private class TestAccumulator
    extends AbstractEventAccumulator {
        String batch;

        protected TestAccumulator() {
            super(AbstractEventAccumulatorTest.this.timer, 5, 100, 50);
            this.batch = "";
        }

        public void processEvents(List<Event> events) {
            for (Event event : events) {
                this.batch = this.batch + event.subject();
            }
        }
    }
}

