/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.event.Event;
import org.onosproject.event.TestEvent;

public class AbstractEventTest {
    protected static <T extends Enum, S> void validateEvent(Event<T, S> event, T type, S subject, long time) {
        Assert.assertEquals((String)"incorrect type", type, (Object)event.type());
        Assert.assertEquals((String)"incorrect subject", subject, (Object)event.subject());
        Assert.assertEquals((String)"incorrect time", (long)time, (long)event.time());
    }

    protected static <T extends Enum, S> void validateEvent(Event<T, S> event, T type, S subject, long minTime, long maxTime) {
        Assert.assertEquals((String)"incorrect type", type, (Object)event.type());
        Assert.assertEquals((String)"incorrect subject", subject, (Object)event.subject());
        Assert.assertTrue((String)"incorrect time", (minTime <= event.time() && event.time() <= maxTime ? 1 : 0) != 0);
    }

    @Test
    public void withTime() {
        TestEvent event = new TestEvent(TestEvent.Type.FOO, "foo", 123L);
        AbstractEventTest.validateEvent(event, TestEvent.Type.FOO, "foo", 123L);
    }

    @Test
    public void withoutTime() {
        long before = System.currentTimeMillis();
        TestEvent event = new TestEvent(TestEvent.Type.FOO, "foo");
        long after = System.currentTimeMillis();
        AbstractEventTest.validateEvent(event, TestEvent.Type.FOO, "foo", before, after);
    }
}

