/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.event.BrokenListener;
import org.onosproject.event.Event;
import org.onosproject.event.TestEvent;
import org.onosproject.event.TestListener;
import org.onosproject.event.TestListenerRegistry;

public class AbstractListenerRegistryTest {
    @Test
    public void basics() {
        TestListener listener = new TestListener();
        TestListener secondListener = new TestListener();
        TestListenerRegistry manager = new TestListenerRegistry();
        manager.addListener(listener);
        manager.addListener(secondListener);
        TestEvent event = new TestEvent(TestEvent.Type.BAR, "bar");
        manager.process((Event)event);
        Assert.assertTrue((String)"event not processed", (boolean)listener.events.contains((Object)event));
        Assert.assertTrue((String)"event not processed", (boolean)secondListener.events.contains((Object)event));
        manager.removeListener(listener);
        TestEvent another = new TestEvent(TestEvent.Type.FOO, "foo");
        manager.process((Event)another);
        Assert.assertFalse((String)"event processed", (boolean)listener.events.contains((Object)another));
        Assert.assertTrue((String)"event not processed", (boolean)secondListener.events.contains((Object)event));
    }

    @Test
    public void badListener() {
        BrokenListener listener = new BrokenListener();
        TestListener secondListener = new TestListener();
        TestListenerRegistry manager = new TestListenerRegistry();
        manager.addListener(listener);
        manager.addListener(secondListener);
        TestEvent event = new TestEvent(TestEvent.Type.BAR, "bar");
        manager.process((Event)event);
        Assert.assertFalse((String)"event processed", (boolean)listener.events.contains((Object)event));
        Assert.assertFalse((String)"error not reported", (boolean)manager.errors.isEmpty());
        Assert.assertTrue((String)"event not processed", (boolean)secondListener.events.contains((Object)event));
    }
}

