/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import java.util.LinkedList;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleBatchEntry;
import org.onosproject.net.flow.FlowRuleBatchOperation;
import org.onosproject.net.flow.FlowRuleBatchRequest;
import org.onosproject.net.intent.IntentTestsMocks;

public class FlowRuleBatchRequestTest {
    @Test
    public void testConstruction() {
        IntentTestsMocks.MockFlowRule rule1 = new IntentTestsMocks.MockFlowRule(1);
        IntentTestsMocks.MockFlowRule rule2 = new IntentTestsMocks.MockFlowRule(2);
        LinkedList<FlowRuleBatchEntry> toAdd = new LinkedList<FlowRuleBatchEntry>();
        toAdd.add(new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.ADD, (FlowRule)rule1));
        LinkedList<FlowRuleBatchEntry> toRemove = new LinkedList<FlowRuleBatchEntry>();
        toRemove.add(new FlowRuleBatchEntry(FlowRuleBatchEntry.FlowRuleOperation.REMOVE, (FlowRule)rule2));
        FlowRuleBatchRequest request = new FlowRuleBatchRequest(1, toAdd, toRemove);
        MatcherAssert.assertThat((Object)request.toAdd(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(request.toAdd().get(0), (Matcher)Matchers.is((Object)rule1));
        MatcherAssert.assertThat((Object)request.toRemove(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat(request.toRemove().get(0), (Matcher)Matchers.is((Object)rule2));
        MatcherAssert.assertThat((Object)request.batchId(), (Matcher)Matchers.is((Object)1));
        FlowRuleBatchOperation op = request.asBatchOperation();
        MatcherAssert.assertThat((Object)op.size(), (Matcher)Matchers.is((Object)2));
        List ops = op.getOperations();
        MatcherAssert.assertThat((Object)ops, (Matcher)Matchers.hasSize((int)2));
    }
}

