/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.junit.UtilityClassChecker;
import org.onlab.packet.IpAddress;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;

public class InstructionsTest {
    private final Instructions.DropInstruction drop1 = Instructions.createDrop();
    private final Instructions.DropInstruction drop2 = Instructions.createDrop();
    private final PortNumber port1 = PortNumber.portNumber((long)1L);
    private final PortNumber port2 = PortNumber.portNumber((long)2L);
    private final Instructions.OutputInstruction output1 = Instructions.createOutput((PortNumber)this.port1);
    private final Instructions.OutputInstruction sameAsOutput1 = Instructions.createOutput((PortNumber)this.port1);
    private final Instructions.OutputInstruction output2 = Instructions.createOutput((PortNumber)this.port2);
    private final short lambda1 = 1;
    private final short lambda2 = (short)2;
    private final Instruction lambdaInstruction1 = Instructions.modL0Lambda((short)1);
    private final Instruction sameAsLambdaInstruction1 = Instructions.modL0Lambda((short)1);
    private final Instruction lambdaInstruction2 = Instructions.modL0Lambda((short)2);
    private static final String MAC1 = "00:00:00:00:00:01";
    private static final String MAC2 = "00:00:00:00:00:02";
    private final MacAddress mac1 = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private final MacAddress mac2 = MacAddress.valueOf((String)"00:00:00:00:00:02");
    private final Instruction modEtherInstruction1 = Instructions.modL2Src((MacAddress)this.mac1);
    private final Instruction sameAsModEtherInstruction1 = Instructions.modL2Src((MacAddress)this.mac1);
    private final Instruction modEtherInstruction2 = Instructions.modL2Src((MacAddress)this.mac2);
    private final short vlan1 = 1;
    private final short vlan2 = (short)2;
    private final VlanId vlanId1 = VlanId.vlanId((short)1);
    private final VlanId vlanId2 = VlanId.vlanId((short)2);
    private final Instruction modVlanId1 = Instructions.modVlanId((VlanId)this.vlanId1);
    private final Instruction sameAsModVlanId1 = Instructions.modVlanId((VlanId)this.vlanId1);
    private final Instruction modVlanId2 = Instructions.modVlanId((VlanId)this.vlanId2);
    private final byte vlanPcp1 = 1;
    private final byte vlanPcp2 = (byte)2;
    private final Instruction modVlanPcp1 = Instructions.modVlanPcp((Byte)1);
    private final Instruction sameAsModVlanPcp1 = Instructions.modVlanPcp((Byte)1);
    private final Instruction modVlanPcp2 = Instructions.modVlanPcp((Byte)2);
    private static final String IP1 = "1.2.3.4/24";
    private static final String IP2 = "5.6.7.8/24";
    private IpAddress ip1 = IpPrefix.valueOf((String)"1.2.3.4/24").address();
    private IpAddress ip2 = IpPrefix.valueOf((String)"5.6.7.8/24").address();
    private final Instruction modIPInstruction1 = Instructions.modL3Src((IpAddress)this.ip1);
    private final Instruction sameAsModIPInstruction1 = Instructions.modL3Src((IpAddress)this.ip1);
    private final Instruction modIPInstruction2 = Instructions.modL3Src((IpAddress)this.ip2);
    private Instruction modMplsLabelInstruction1 = Instructions.modMplsLabel((Integer)1);
    private Instruction sameAsModMplsLabelInstruction1 = Instructions.modMplsLabel((Integer)1);
    private Instruction modMplsLabelInstruction2 = Instructions.modMplsLabel((Integer)2);

    private <T> T checkAndConvert(Instruction instruction, Instruction.Type type, Class clazz) {
        MatcherAssert.assertThat((Object)instruction, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)instruction.type(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)type)));
        MatcherAssert.assertThat((Object)instruction, (Matcher)Matchers.instanceOf((Class)clazz));
        return (T)instruction;
    }

    private <T extends Instruction> void checkEqualsAndToString(T c1, T c1match, T c2) {
        new EqualsTester().addEqualityGroup(new Object[]{c1, c1match}).addEqualityGroup(new Object[]{c2}).testEquals();
    }

    @Test
    public void testInstructionsUtilityClass() {
        UtilityClassChecker.assertThatClassIsUtility(Instructions.class);
    }

    @Test
    public void testImmutabilityOfInstructions() {
        ImmutableClassChecker.assertThatClassIsImmutable(Instructions.DropInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Instructions.OutputInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L0ModificationInstruction.ModLambdaInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L2ModificationInstruction.ModEtherInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L2ModificationInstruction.ModVlanIdInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L2ModificationInstruction.ModVlanPcpInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L3ModificationInstruction.ModIPInstruction.class);
    }

    @Test
    public void testCreateDropMethod() {
        Instructions.DropInstruction instruction = Instructions.createDrop();
        this.checkAndConvert((Instruction)instruction, Instruction.Type.DROP, Instructions.DropInstruction.class);
    }

    @Test
    public void testDropInstructionEquals() throws Exception {
        MatcherAssert.assertThat((Object)this.drop1, (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.drop2)));
    }

    @Test
    public void testDropInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.drop1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.drop2.hashCode())));
    }

    @Test
    public void testCreateOutputMethod() {
        Instructions.OutputInstruction instruction = Instructions.createOutput((PortNumber)this.port2);
        Instructions.OutputInstruction outputInstruction = (Instructions.OutputInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.OUTPUT, Instructions.OutputInstruction.class);
        MatcherAssert.assertThat((Object)outputInstruction.port(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.port2)));
    }

    @Test
    public void testOutputInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.output1, this.sameAsOutput1, this.output2);
    }

    @Test
    public void testOutputInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.output1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsOutput1.hashCode())));
        MatcherAssert.assertThat((Object)this.output1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.output2.hashCode()))));
    }

    @Test
    public void testCreateLambdaMethod() {
        L0ModificationInstruction instruction = Instructions.modL0Lambda((short)1);
        L0ModificationInstruction.ModLambdaInstruction lambdaInstruction = (L0ModificationInstruction.ModLambdaInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L0MODIFICATION, L0ModificationInstruction.ModLambdaInstruction.class);
        MatcherAssert.assertThat((Object)lambdaInstruction.lambda(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testModLambdaInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.lambdaInstruction1, this.sameAsLambdaInstruction1, this.lambdaInstruction2);
    }

    @Test
    public void testModLambdaInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.lambdaInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsLambdaInstruction1.hashCode())));
        MatcherAssert.assertThat((Object)this.lambdaInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.lambdaInstruction2.hashCode()))));
    }

    @Test
    public void testModL2SrcMethod() {
        L2ModificationInstruction instruction = Instructions.modL2Src((MacAddress)this.mac1);
        L2ModificationInstruction.ModEtherInstruction modEtherInstruction = (L2ModificationInstruction.ModEtherInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModEtherInstruction.class);
        MatcherAssert.assertThat((Object)modEtherInstruction.mac(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.mac1)));
        MatcherAssert.assertThat((Object)modEtherInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L2ModificationInstruction.L2SubType.ETH_SRC)));
    }

    @Test
    public void testModL2DstMethod() {
        L2ModificationInstruction instruction = Instructions.modL2Dst((MacAddress)this.mac1);
        L2ModificationInstruction.ModEtherInstruction modEtherInstruction = (L2ModificationInstruction.ModEtherInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModEtherInstruction.class);
        MatcherAssert.assertThat((Object)modEtherInstruction.mac(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.mac1)));
        MatcherAssert.assertThat((Object)modEtherInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L2ModificationInstruction.L2SubType.ETH_DST)));
    }

    @Test
    public void testModEtherInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modEtherInstruction1, this.sameAsModEtherInstruction1, this.modEtherInstruction2);
    }

    @Test
    public void testModEtherInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.modEtherInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsModEtherInstruction1.hashCode())));
        MatcherAssert.assertThat((Object)this.modEtherInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.modEtherInstruction2.hashCode()))));
    }

    @Test
    public void testModVlanIdMethod() {
        L2ModificationInstruction instruction = Instructions.modVlanId((VlanId)this.vlanId1);
        L2ModificationInstruction.ModVlanIdInstruction modEtherInstruction = (L2ModificationInstruction.ModVlanIdInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModVlanIdInstruction.class);
        MatcherAssert.assertThat((Object)modEtherInstruction.vlanId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.vlanId1)));
        MatcherAssert.assertThat((Object)modEtherInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L2ModificationInstruction.L2SubType.VLAN_ID)));
    }

    @Test
    public void testModVlanIdInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modVlanId1, this.sameAsModVlanId1, this.modVlanId2);
    }

    @Test
    public void testModVlanIdInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.modVlanId1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsModVlanId1.hashCode())));
        MatcherAssert.assertThat((Object)this.modVlanId1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.modVlanId2.hashCode()))));
    }

    @Test
    public void testModVlanPcpMethod() {
        L2ModificationInstruction instruction = Instructions.modVlanPcp((Byte)1);
        L2ModificationInstruction.ModVlanPcpInstruction modEtherInstruction = (L2ModificationInstruction.ModVlanPcpInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModVlanPcpInstruction.class);
        MatcherAssert.assertThat((Object)modEtherInstruction.vlanPcp(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        MatcherAssert.assertThat((Object)modEtherInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L2ModificationInstruction.L2SubType.VLAN_PCP)));
    }

    @Test
    public void testModVlanPcpInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modVlanPcp1, this.sameAsModVlanPcp1, this.modVlanPcp2);
    }

    @Test
    public void testModVlanPcpInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.modVlanPcp1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsModVlanPcp1.hashCode())));
        MatcherAssert.assertThat((Object)this.modVlanPcp1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.modVlanPcp2.hashCode()))));
    }

    @Test
    public void testModL3SrcMethod() {
        L3ModificationInstruction instruction = Instructions.modL3Src((IpAddress)this.ip1);
        L3ModificationInstruction.ModIPInstruction modIPInstruction = (L3ModificationInstruction.ModIPInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModIPInstruction.class);
        MatcherAssert.assertThat((Object)modIPInstruction.ip(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ip1)));
        MatcherAssert.assertThat((Object)modIPInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L3ModificationInstruction.L3SubType.IP_SRC)));
    }

    @Test
    public void testModL3DstMethod() {
        L3ModificationInstruction instruction = Instructions.modL3Dst((IpAddress)this.ip1);
        L3ModificationInstruction.ModIPInstruction modIPInstruction = (L3ModificationInstruction.ModIPInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModIPInstruction.class);
        MatcherAssert.assertThat((Object)modIPInstruction.ip(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ip1)));
        MatcherAssert.assertThat((Object)modIPInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L3ModificationInstruction.L3SubType.IP_DST)));
    }

    @Test
    public void testModIPInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modIPInstruction1, this.sameAsModIPInstruction1, this.modIPInstruction2);
    }

    @Test
    public void testModIPInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.modIPInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsModIPInstruction1.hashCode())));
        MatcherAssert.assertThat((Object)this.modIPInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.modIPInstruction2.hashCode()))));
    }

    @Test
    public void testModMplsMethod() {
        L2ModificationInstruction instruction = Instructions.modMplsLabel((Integer)33);
        L2ModificationInstruction.ModMplsLabelInstruction modMplsLabelInstruction = (L2ModificationInstruction.ModMplsLabelInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModMplsLabelInstruction.class);
        MatcherAssert.assertThat((Object)modMplsLabelInstruction.label(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)33)));
        MatcherAssert.assertThat((Object)modMplsLabelInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L2ModificationInstruction.L2SubType.MPLS_LABEL)));
    }

    @Test
    public void testModMplsLabelInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modMplsLabelInstruction1, this.sameAsModMplsLabelInstruction1, this.modMplsLabelInstruction2);
    }
}

