/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.onosproject.event.Event;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentCompiler;
import org.onosproject.net.intent.IntentEvent;
import org.onosproject.net.intent.IntentException;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.intent.IntentInstaller;
import org.onosproject.net.intent.IntentListener;
import org.onosproject.net.intent.IntentOperations;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.TestableIntentService;

public class FakeIntentManager
implements TestableIntentService {
    private final Map<IntentId, Intent> intents = new HashMap<IntentId, Intent>();
    private final Map<IntentId, IntentState> intentStates = new HashMap<IntentId, IntentState>();
    private final Map<IntentId, List<Intent>> installables = new HashMap<IntentId, List<Intent>>();
    private final Set<IntentListener> listeners = new HashSet<IntentListener>();
    private final Map<Class<? extends Intent>, IntentCompiler<? extends Intent>> compilers = new HashMap<Class<? extends Intent>, IntentCompiler<? extends Intent>>();
    private final Map<Class<? extends Intent>, IntentInstaller<? extends Intent>> installers = new HashMap<Class<? extends Intent>, IntentInstaller<? extends Intent>>();
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final List<IntentException> exceptions = new ArrayList<IntentException>();

    @Override
    public List<IntentException> getExceptions() {
        return this.exceptions;
    }

    private void executeSubmit(final Intent intent) {
        this.registerSubclassCompilerIfNeeded(intent);
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    FakeIntentManager.this.executeCompilingPhase(intent);
                }
                catch (IntentException e) {
                    FakeIntentManager.this.exceptions.add(e);
                }
            }
        });
    }

    private void executeWithdraw(final Intent intent) {
        this.executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    List installable = FakeIntentManager.this.getInstallable(intent.id());
                    FakeIntentManager.this.executeWithdrawingPhase(intent, installable);
                }
                catch (IntentException e) {
                    FakeIntentManager.this.exceptions.add(e);
                }
            }
        });
    }

    private <T extends Intent> IntentCompiler<T> getCompiler(T intent) {
        IntentCompiler<? extends Intent> compiler = this.compilers.get(intent.getClass());
        if (compiler == null) {
            throw new IntentException("no compiler for class " + intent.getClass());
        }
        return compiler;
    }

    private <T extends Intent> IntentInstaller<T> getInstaller(T intent) {
        IntentInstaller<? extends Intent> installer = this.installers.get(intent.getClass());
        if (installer == null) {
            throw new IntentException("no installer for class " + intent.getClass());
        }
        return installer;
    }

    private <T extends Intent> void executeCompilingPhase(T intent) {
        this.setState(intent, IntentState.COMPILING);
        try {
            ArrayList<Intent> installable = new ArrayList<Intent>();
            for (Intent compiled : this.getCompiler(intent).compile(intent, null, null)) {
                installable.add(compiled);
            }
            this.executeInstallingPhase(intent, installable);
        }
        catch (IntentException e) {
            this.setState(intent, IntentState.FAILED);
            this.dispatch(new IntentEvent(IntentEvent.Type.FAILED, intent));
        }
    }

    private void executeInstallingPhase(Intent intent, List<Intent> installable) {
        this.setState(intent, IntentState.INSTALLING);
        try {
            for (Intent ii : installable) {
                this.registerSubclassInstallerIfNeeded(ii);
                this.getInstaller(ii).install(ii);
            }
            this.setState(intent, IntentState.INSTALLED);
            this.putInstallable(intent.id(), installable);
            this.dispatch(new IntentEvent(IntentEvent.Type.INSTALLED, intent));
        }
        catch (IntentException e) {
            this.setState(intent, IntentState.FAILED);
            this.dispatch(new IntentEvent(IntentEvent.Type.FAILED, intent));
        }
    }

    private void executeWithdrawingPhase(Intent intent, List<Intent> installable) {
        this.setState(intent, IntentState.WITHDRAWING);
        try {
            for (Intent ii : installable) {
                this.getInstaller(ii).uninstall(ii);
            }
            this.removeInstallable(intent.id());
            this.setState(intent, IntentState.WITHDRAWN);
            this.dispatch(new IntentEvent(IntentEvent.Type.WITHDRAWN, intent));
        }
        catch (IntentException e) {
            this.setState(intent, IntentState.FAILED);
            this.dispatch(new IntentEvent(IntentEvent.Type.FAILED, intent));
        }
    }

    private void setState(Intent intent, IntentState state) {
        this.intentStates.put(intent.id(), state);
    }

    private void putInstallable(IntentId id, List<Intent> installable) {
        this.installables.put(id, installable);
    }

    private void removeInstallable(IntentId id) {
        this.installables.remove(id);
    }

    private List<Intent> getInstallable(IntentId id) {
        List<Intent> installable = this.installables.get(id);
        if (installable != null) {
            return installable;
        }
        return Collections.emptyList();
    }

    public void submit(Intent intent) {
        this.intents.put(intent.id(), intent);
        this.setState(intent, IntentState.INSTALL_REQ);
        this.dispatch(new IntentEvent(IntentEvent.Type.INSTALL_REQ, intent));
        this.executeSubmit(intent);
    }

    public void withdraw(Intent intent) {
        this.intents.remove(intent.id());
        this.executeWithdraw(intent);
    }

    public void replace(IntentId oldIntentId, Intent newIntent) {
    }

    public void execute(IntentOperations operations) {
    }

    public Set<Intent> getIntents() {
        return Collections.unmodifiableSet(new HashSet<Intent>(this.intents.values()));
    }

    public long getIntentCount() {
        return this.intents.size();
    }

    public Intent getIntent(IntentId id) {
        return this.intents.get(id);
    }

    public IntentState getIntentState(IntentId id) {
        return this.intentStates.get(id);
    }

    public List<Intent> getInstallableIntents(IntentId intentId) {
        return this.installables.get(intentId);
    }

    public void addListener(IntentListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(IntentListener listener) {
        this.listeners.remove(listener);
    }

    private void dispatch(IntentEvent event) {
        for (IntentListener listener : this.listeners) {
            listener.event((Event)event);
        }
    }

    public <T extends Intent> void registerCompiler(Class<T> cls, IntentCompiler<T> compiler) {
        this.compilers.put(cls, compiler);
    }

    public <T extends Intent> void unregisterCompiler(Class<T> cls) {
        this.compilers.remove(cls);
    }

    public Map<Class<? extends Intent>, IntentCompiler<? extends Intent>> getCompilers() {
        return Collections.unmodifiableMap(this.compilers);
    }

    public <T extends Intent> void registerInstaller(Class<T> cls, IntentInstaller<T> installer) {
        this.installers.put(cls, installer);
    }

    public <T extends Intent> void unregisterInstaller(Class<T> cls) {
        this.installers.remove(cls);
    }

    public Map<Class<? extends Intent>, IntentInstaller<? extends Intent>> getInstallers() {
        return Collections.unmodifiableMap(this.installers);
    }

    private void registerSubclassCompilerIfNeeded(Intent intent) {
        if (!this.compilers.containsKey(intent.getClass())) {
            for (Class<?> cls = intent.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
                IntentCompiler<? extends Intent> compiler;
                if (!Intent.class.isAssignableFrom(cls) || (compiler = this.compilers.get(cls)) == null) continue;
                this.compilers.put(intent.getClass(), compiler);
                return;
            }
        }
    }

    private void registerSubclassInstallerIfNeeded(Intent intent) {
        if (!this.installers.containsKey(intent.getClass())) {
            for (Class<?> cls = intent.getClass(); cls != Object.class; cls = cls.getSuperclass()) {
                IntentInstaller<? extends Intent> installer;
                if (!Intent.class.isAssignableFrom(cls) || (installer = this.installers.get(cls)) == null) continue;
                this.installers.put(intent.getClass(), installer);
                return;
            }
        }
    }
}

