/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.testing.EqualsTester;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplicationId;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentOperation;
import org.onosproject.net.intent.IntentOperations;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.intent.MockIdGenerator;
import org.onosproject.net.intent.PointToPointIntent;

public class IntentOperationsTest {
    final ConnectPoint egress = NetTestTools.connectPoint("egress", 3);
    final ConnectPoint ingress = NetTestTools.connectPoint("ingress", 3);
    final TrafficSelector selector = new IntentTestsMocks.MockSelector();
    final IntentTestsMocks.MockTreatment treatment = new IntentTestsMocks.MockTreatment();
    private final ApplicationId appId = new DefaultApplicationId(Short.valueOf((short)1), "IntentOperationsTest");
    private Intent intent;
    protected IdGenerator idGenerator = new MockIdGenerator();

    @Before
    public void setUp() {
        Intent.bindIdGenerator((IdGenerator)this.idGenerator);
        this.intent = new PointToPointIntent(NetTestTools.APP_ID, this.selector, (TrafficTreatment)this.treatment, this.ingress, this.egress);
    }

    @After
    public void tearDown() {
        Intent.unbindIdGenerator((IdGenerator)this.idGenerator);
    }

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(IntentOperations.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IntentOperations.Builder.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IntentOperation.class);
    }

    @Test
    public void testEquals() {
        IntentOperations operations1 = IntentOperations.builder((ApplicationId)this.appId).addSubmitOperation(this.intent).build();
        IntentOperations sameAsOperations1 = IntentOperations.builder((ApplicationId)this.appId).addSubmitOperation(this.intent).build();
        IntentOperations operations2 = IntentOperations.builder((ApplicationId)this.appId).addReplaceOperation(this.intent.id(), this.intent).build();
        new EqualsTester().addEqualityGroup(new Object[]{operations1, sameAsOperations1}).addEqualityGroup(new Object[]{operations2}).testEquals();
    }

    @Test
    public void testConstruction() {
        IntentOperations operations = IntentOperations.builder((ApplicationId)this.appId).addUpdateOperation(this.intent.id()).addWithdrawOperation(this.intent.id()).build();
        List operationList = operations.operations();
        MatcherAssert.assertThat((Object)operationList, (Matcher)Matchers.hasSize((int)2));
        for (IntentOperation operation : operationList) {
            MatcherAssert.assertThat((Object)operation.type(), (Matcher)Matchers.isOneOf((Object[])new IntentOperation.Type[]{IntentOperation.Type.UPDATE, IntentOperation.Type.WITHDRAW}));
            MatcherAssert.assertThat((Object)operation.intent(), (Matcher)Matchers.is((Object)null));
            MatcherAssert.assertThat((Object)operation.intentId(), (Matcher)Matchers.is((Object)this.intent.id()));
        }
    }
}

