/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject;

import com.google.common.testing.EqualsTester;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.core.Version;

public class VersionTest {
    @Test
    public void fromParts() {
        Version v = Version.version((int)1, (int)2, (String)"3", (String)"4321");
        Assert.assertEquals((String)"wrong major", (long)1L, (long)v.major());
        Assert.assertEquals((String)"wrong minor", (long)2L, (long)v.minor());
        Assert.assertEquals((String)"wrong patch", (Object)"3", (Object)v.patch());
        Assert.assertEquals((String)"wrong build", (Object)"4321", (Object)v.build());
    }

    @Test
    public void fromString() {
        Version v = Version.version((String)"1.2.3.4321");
        Assert.assertEquals((String)"wrong major", (long)1L, (long)v.major());
        Assert.assertEquals((String)"wrong minor", (long)2L, (long)v.minor());
        Assert.assertEquals((String)"wrong patch", (Object)"3", (Object)v.patch());
        Assert.assertEquals((String)"wrong build", (Object)"4321", (Object)v.build());
    }

    @Test
    public void snapshot() {
        Version v = Version.version((String)"1.2.3-SNAPSHOT");
        Assert.assertEquals((String)"wrong major", (long)1L, (long)v.major());
        Assert.assertEquals((String)"wrong minor", (long)2L, (long)v.minor());
        Assert.assertEquals((String)"wrong patch", (Object)"3", (Object)v.patch());
        Assert.assertEquals((String)"wrong build", (Object)"SNAPSHOT", (Object)v.build());
    }

    @Test
    public void shortNumber() {
        Version v = Version.version((String)"1.2.3");
        Assert.assertEquals((String)"wrong major", (long)1L, (long)v.major());
        Assert.assertEquals((String)"wrong minor", (long)2L, (long)v.minor());
        Assert.assertEquals((String)"wrong patch", (Object)"3", (Object)v.patch());
        Assert.assertEquals((String)"wrong build", null, (Object)v.build());
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{Version.version((String)"1.2.3.4321"), Version.version((int)1, (int)2, (String)"3", (String)"4321")}).addEqualityGroup(new Object[]{Version.version((String)"1.9.3.4321"), Version.version((int)1, (int)9, (String)"3", (String)"4321")}).addEqualityGroup(new Object[]{Version.version((String)"1.2.8.4321"), Version.version((int)1, (int)2, (String)"8", (String)"4321")}).addEqualityGroup(new Object[]{Version.version((String)"1.2.3.x"), Version.version((int)1, (int)2, (String)"3", (String)"x")}).testEquals();
    }
}

