/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.app;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.app.DefaultApplicationDescription;
import org.onosproject.core.Permission;
import org.onosproject.core.Version;

public class DefaultApplicationDescriptionTest {
    public static final String APP_NAME = "org.foo.app";
    public static final Version VER = Version.version((int)1, (int)2, (String)"a", null);
    public static final String DESC = "Awesome application from Circus";
    public static final String ORIGIN = "Circus";
    public static final Set<Permission> PERMS = ImmutableSet.of();
    public static final URI FURL = URI.create("mvn:org.foo-features/1.2a/xml/features");
    public static final List<String> FEATURES = ImmutableList.of((Object)"foo", (Object)"bar");

    @Test
    public void basics() {
        DefaultApplicationDescription app = new DefaultApplicationDescription(APP_NAME, VER, DESC, ORIGIN, PERMS, FURL, FEATURES);
        Assert.assertEquals((String)"incorrect id", (Object)APP_NAME, (Object)app.name());
        Assert.assertEquals((String)"incorrect version", (Object)VER, (Object)app.version());
        Assert.assertEquals((String)"incorrect description", (Object)DESC, (Object)app.description());
        Assert.assertEquals((String)"incorrect origin", (Object)ORIGIN, (Object)app.origin());
        Assert.assertEquals((String)"incorrect permissions", PERMS, (Object)app.permissions());
        Assert.assertEquals((String)"incorrect features repo", (Object)FURL, app.featuresRepo().get());
        Assert.assertEquals((String)"incorrect features", FEATURES, (Object)app.features());
        Assert.assertTrue((String)"incorrect toString", (boolean)app.toString().contains(APP_NAME));
    }
}

