/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.core;

import com.google.common.testing.EqualsTester;
import java.util.Optional;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.app.DefaultApplicationDescriptionTest;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.DefaultApplication;
import org.onosproject.core.DefaultApplicationId;

public class DefaultApplicationTest {
    public static final ApplicationId APP_ID = new DefaultApplicationId(2, "org.foo.app");

    @Test
    public void basics() {
        DefaultApplication app = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome application from Circus", "Circus", DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES);
        Assert.assertEquals((String)"incorrect id", (Object)APP_ID, (Object)app.id());
        Assert.assertEquals((String)"incorrect version", (Object)DefaultApplicationDescriptionTest.VER, (Object)app.version());
        Assert.assertEquals((String)"incorrect description", (Object)"Awesome application from Circus", (Object)app.description());
        Assert.assertEquals((String)"incorrect origin", (Object)"Circus", (Object)app.origin());
        Assert.assertEquals((String)"incorrect permissions", DefaultApplicationDescriptionTest.PERMS, (Object)app.permissions());
        Assert.assertEquals((String)"incorrect features repo", (Object)DefaultApplicationDescriptionTest.FURL, app.featuresRepo().get());
        Assert.assertEquals((String)"incorrect features", DefaultApplicationDescriptionTest.FEATURES, (Object)app.features());
        Assert.assertTrue((String)"incorrect toString", (boolean)app.toString().contains("org.foo.app"));
    }

    @Test
    public void testEquality() {
        DefaultApplication a1 = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome application from Circus", "Circus", DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES);
        DefaultApplication a2 = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome application from Circus", "Circus", DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES);
        DefaultApplication a3 = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome application from Circus", "Circus", DefaultApplicationDescriptionTest.PERMS, Optional.empty(), DefaultApplicationDescriptionTest.FEATURES);
        DefaultApplication a4 = new DefaultApplication(APP_ID, DefaultApplicationDescriptionTest.VER, "Awesome application from Circus", "Circusasd", DefaultApplicationDescriptionTest.PERMS, Optional.of(DefaultApplicationDescriptionTest.FURL), DefaultApplicationDescriptionTest.FEATURES);
        new EqualsTester().addEqualityGroup(new Object[]{a1, a2}).addEqualityGroup(new Object[]{a3}).addEqualityGroup(new Object[]{a4}).testEquals();
    }
}

