/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import java.util.ArrayList;
import java.util.HashSet;
import org.junit.Assert;
import org.onlab.packet.ChassisId;
import org.onlab.packet.MacAddress;
import org.onlab.packet.VlanId;
import org.onosproject.TestApplicationId;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.Annotations;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.DefaultDevice;
import org.onosproject.net.DefaultHost;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.DefaultPath;
import org.onosproject.net.Device;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Host;
import org.onosproject.net.HostId;
import org.onosproject.net.HostLocation;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.provider.ProviderId;

public final class NetTestTools {
    public static final ProviderId PID = new ProviderId("of", "foo");
    public static final ApplicationId APP_ID = new TestApplicationId("foo");

    private NetTestTools() {
    }

    public static DeviceId did(String id) {
        return DeviceId.deviceId((String)("of:" + id));
    }

    public static HostId hid(String id) {
        return HostId.hostId((String)id);
    }

    public static Device device(String id) {
        return new DefaultDevice(PID, NetTestTools.did(id), Device.Type.SWITCH, "mfg", "1.0", "1.1", "1234", new ChassisId(), new Annotations[0]);
    }

    public static Host host(String id, String did) {
        return new DefaultHost(PID, NetTestTools.hid(id), MacAddress.valueOf((long)1234L), VlanId.vlanId((short)2), new HostLocation(NetTestTools.did(did), PortNumber.portNumber((long)1L), 321L), new HashSet(), new Annotations[0]);
    }

    public static ConnectPoint connectPoint(String id, int port) {
        return new ConnectPoint((ElementId)NetTestTools.did(id), PortNumber.portNumber((long)port));
    }

    public static Link link(String src, int sp, String dst, int dp) {
        return new DefaultLink(PID, NetTestTools.connectPoint(src, sp), NetTestTools.connectPoint(dst, dp), Link.Type.DIRECT, new Annotations[0]);
    }

    public static Path createPath(String ... ids) {
        ArrayList<Link> links = new ArrayList<Link>();
        for (int i = 0; i < ids.length - 1; ++i) {
            links.add(NetTestTools.link(ids[i], i, ids[i + 1], i));
        }
        return new DefaultPath(PID, links, (double)ids.length, new Annotations[0]);
    }

    public static void assertAnnotationsEquals(Annotations actual, SparseAnnotations ... annotations) {
        DefaultAnnotations expected = DefaultAnnotations.builder().build();
        for (SparseAnnotations a : annotations) {
            expected = DefaultAnnotations.merge((DefaultAnnotations)expected, (SparseAnnotations)a);
        }
        Assert.assertEquals((Object)expected.keys(), (Object)actual.keys());
        for (String key : expected.keys()) {
            Assert.assertEquals((Object)expected.value(key), (Object)actual.value(key));
        }
    }
}

