/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.driver.DefaultDriver;
import org.onosproject.net.driver.TestBehaviour;
import org.onosproject.net.driver.TestBehaviourImpl;
import org.onosproject.net.driver.TestBehaviourTwo;
import org.onosproject.net.driver.TestBehaviourTwoImpl;

public class DefaultDriverTest {
    @Test
    public void basics() {
        DefaultDriver ddc = new DefaultDriver("foo.bar", "Circus", "lux", "1.2a", (Map)ImmutableMap.of(TestBehaviour.class, TestBehaviourImpl.class), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        Assert.assertEquals((String)"incorrect name", (Object)"foo.bar", (Object)ddc.name());
        Assert.assertEquals((String)"incorrect mfr", (Object)"Circus", (Object)ddc.manufacturer());
        Assert.assertEquals((String)"incorrect hw", (Object)"lux", (Object)ddc.hwVersion());
        Assert.assertEquals((String)"incorrect sw", (Object)"1.2a", (Object)ddc.swVersion());
        Assert.assertEquals((String)"incorrect behaviour count", (long)1L, (long)ddc.behaviours().size());
        Assert.assertTrue((String)"incorrect behaviour", (boolean)ddc.hasBehaviour(TestBehaviour.class));
        Assert.assertEquals((String)"incorrect property count", (long)1L, (long)ddc.properties().size());
        Assert.assertEquals((String)"incorrect key count", (long)1L, (long)ddc.keys().size());
        Assert.assertEquals((String)"incorrect property", (Object)"bar", (Object)ddc.value("foo"));
        Assert.assertTrue((String)"incorrect toString", (boolean)ddc.toString().contains("lux"));
    }

    @Test
    public void merge() {
        DefaultDriver one = new DefaultDriver("foo.bar", "Circus", "lux", "1.2a", (Map)ImmutableMap.of(TestBehaviour.class, TestBehaviourImpl.class), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        DefaultDriver ddc = one.merge(new DefaultDriver("foo.bar", "", "", "", (Map)ImmutableMap.of(TestBehaviourTwo.class, TestBehaviourTwoImpl.class), (Map)ImmutableMap.of((Object)"goo", (Object)"wee")));
        Assert.assertEquals((String)"incorrect name", (Object)"foo.bar", (Object)ddc.name());
        Assert.assertEquals((String)"incorrect mfr", (Object)"Circus", (Object)ddc.manufacturer());
        Assert.assertEquals((String)"incorrect hw", (Object)"lux", (Object)ddc.hwVersion());
        Assert.assertEquals((String)"incorrect sw", (Object)"1.2a", (Object)ddc.swVersion());
        Assert.assertEquals((String)"incorrect behaviour count", (long)2L, (long)ddc.behaviours().size());
        Assert.assertTrue((String)"incorrect behaviour", (boolean)ddc.hasBehaviour(TestBehaviourTwo.class));
        Assert.assertEquals((String)"incorrect property count", (long)2L, (long)ddc.properties().size());
        Assert.assertEquals((String)"incorrect key count", (long)2L, (long)ddc.keys().size());
        Assert.assertEquals((String)"incorrect property", (Object)"wee", (Object)ddc.value("goo"));
        Assert.assertTrue((String)"incorrect toString", (boolean)ddc.toString().contains("Circus"));
    }
}

