/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.junit.UtilityClassChecker;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.VlanId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;

public class CriteriaTest {
    final PortNumber port1 = PortNumber.portNumber((long)1L);
    final PortNumber port2 = PortNumber.portNumber((long)2L);
    Criterion matchInPort1 = Criteria.matchInPort((PortNumber)this.port1);
    Criterion sameAsMatchInPort1 = Criteria.matchInPort((PortNumber)this.port1);
    Criterion matchInPort2 = Criteria.matchInPort((PortNumber)this.port2);
    Criterion matchInPhyPort1 = Criteria.matchInPhyPort((PortNumber)this.port1);
    Criterion sameAsMatchInPhyPort1 = Criteria.matchInPhyPort((PortNumber)this.port1);
    Criterion matchInPhyPort2 = Criteria.matchInPhyPort((PortNumber)this.port2);
    long metadata1 = 1L;
    long metadata2 = 2L;
    Criterion matchMetadata1 = Criteria.matchMetadata((long)this.metadata1);
    Criterion sameAsMatchMetadata1 = Criteria.matchMetadata((long)this.metadata1);
    Criterion matchMetadata2 = Criteria.matchMetadata((long)this.metadata2);
    private static final String MAC1 = "00:00:00:00:00:01";
    private static final String MAC2 = "00:00:00:00:00:02";
    private MacAddress mac1 = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private MacAddress mac2 = MacAddress.valueOf((String)"00:00:00:00:00:02");
    Criterion matchEth1 = Criteria.matchEthSrc((MacAddress)this.mac1);
    Criterion sameAsMatchEth1 = Criteria.matchEthSrc((MacAddress)this.mac1);
    Criterion matchEth2 = Criteria.matchEthDst((MacAddress)this.mac2);
    int ethType1 = 1;
    int ethType2 = 2;
    Criterion matchEthType1 = Criteria.matchEthType((int)this.ethType1);
    Criterion sameAsMatchEthType1 = Criteria.matchEthType((int)this.ethType1);
    Criterion matchEthType2 = Criteria.matchEthType((int)this.ethType2);
    short vlan1 = 1;
    short vlan2 = (short)2;
    VlanId vlanId1 = VlanId.vlanId((short)this.vlan1);
    VlanId vlanId2 = VlanId.vlanId((short)this.vlan2);
    Criterion matchVlanId1 = Criteria.matchVlanId((VlanId)this.vlanId1);
    Criterion sameAsMatchVlanId1 = Criteria.matchVlanId((VlanId)this.vlanId1);
    Criterion matchVlanId2 = Criteria.matchVlanId((VlanId)this.vlanId2);
    byte vlanPcp1 = 1;
    byte vlanPcp2 = (byte)2;
    Criterion matchVlanPcp1 = Criteria.matchVlanPcp((byte)this.vlanPcp1);
    Criterion sameAsMatchVlanPcp1 = Criteria.matchVlanPcp((byte)this.vlanPcp1);
    Criterion matchVlanPcp2 = Criteria.matchVlanPcp((byte)this.vlanPcp2);
    byte ipDscp1 = 1;
    byte ipDscp2 = (byte)2;
    Criterion matchIpDscp1 = Criteria.matchIPDscp((byte)this.ipDscp1);
    Criterion sameAsMatchIpDscp1 = Criteria.matchIPDscp((byte)this.ipDscp1);
    Criterion matchIpDscp2 = Criteria.matchIPDscp((byte)this.ipDscp2);
    byte ipEcn1 = 1;
    byte ipEcn2 = (byte)2;
    Criterion matchIpEcn1 = Criteria.matchIPEcn((byte)this.ipEcn1);
    Criterion sameAsMatchIpEcn1 = Criteria.matchIPEcn((byte)this.ipEcn1);
    Criterion matchIpEcn2 = Criteria.matchIPEcn((byte)this.ipEcn2);
    short protocol1 = 1;
    short protocol2 = (short)2;
    Criterion matchIpProtocol1 = Criteria.matchIPProtocol((short)this.protocol1);
    Criterion sameAsMatchIpProtocol1 = Criteria.matchIPProtocol((short)this.protocol1);
    Criterion matchIpProtocol2 = Criteria.matchIPProtocol((short)this.protocol2);
    private static final String IP1 = "1.2.3.4/24";
    private static final String IP2 = "5.6.7.8/24";
    private static final String IPV61 = "fe80::1/64";
    private static final String IPV62 = "fc80::2/64";
    private IpPrefix ip1 = IpPrefix.valueOf((String)"1.2.3.4/24");
    private IpPrefix ip2 = IpPrefix.valueOf((String)"5.6.7.8/24");
    private IpPrefix ipv61 = IpPrefix.valueOf((String)"fe80::1/64");
    private IpPrefix ipv62 = IpPrefix.valueOf((String)"fc80::2/64");
    Criterion matchIp1 = Criteria.matchIPSrc((IpPrefix)this.ip1);
    Criterion sameAsMatchIp1 = Criteria.matchIPSrc((IpPrefix)this.ip1);
    Criterion matchIp2 = Criteria.matchIPSrc((IpPrefix)this.ip2);
    Criterion matchIpv61 = Criteria.matchIPSrc((IpPrefix)this.ipv61);
    Criterion sameAsMatchIpv61 = Criteria.matchIPSrc((IpPrefix)this.ipv61);
    Criterion matchIpv62 = Criteria.matchIPSrc((IpPrefix)this.ipv62);
    Criterion matchTcpPort1 = Criteria.matchTcpSrc((int)1);
    Criterion sameAsMatchTcpPort1 = Criteria.matchTcpSrc((int)1);
    Criterion matchTcpPort2 = Criteria.matchTcpDst((int)2);
    Criterion matchUdpPort1 = Criteria.matchUdpSrc((int)1);
    Criterion sameAsMatchUdpPort1 = Criteria.matchUdpSrc((int)1);
    Criterion matchUdpPort2 = Criteria.matchUdpDst((int)2);
    Criterion matchSctpPort1 = Criteria.matchSctpSrc((int)1);
    Criterion sameAsMatchSctpPort1 = Criteria.matchSctpSrc((int)1);
    Criterion matchSctpPort2 = Criteria.matchSctpDst((int)2);
    short icmpType1 = 1;
    short icmpType2 = (short)2;
    Criterion matchIcmpType1 = Criteria.matchIcmpType((short)this.icmpType1);
    Criterion sameAsMatchIcmpType1 = Criteria.matchIcmpType((short)this.icmpType1);
    Criterion matchIcmpType2 = Criteria.matchIcmpType((short)this.icmpType2);
    short icmpCode1 = 1;
    short icmpCode2 = (short)2;
    Criterion matchIcmpCode1 = Criteria.matchIcmpCode((short)this.icmpCode1);
    Criterion sameAsMatchIcmpCode1 = Criteria.matchIcmpCode((short)this.icmpCode1);
    Criterion matchIcmpCode2 = Criteria.matchIcmpCode((short)this.icmpCode2);
    int flowLabel1 = 1;
    int flowLabel2 = 2;
    Criterion matchFlowLabel1 = Criteria.matchIPv6FlowLabel((int)this.flowLabel1);
    Criterion sameAsMatchFlowLabel1 = Criteria.matchIPv6FlowLabel((int)this.flowLabel1);
    Criterion matchFlowLabel2 = Criteria.matchIPv6FlowLabel((int)this.flowLabel2);
    short icmpv6Type1 = 1;
    short icmpv6Type2 = (short)2;
    Criterion matchIcmpv6Type1 = Criteria.matchIcmpv6Type((short)this.icmpv6Type1);
    Criterion sameAsMatchIcmpv6Type1 = Criteria.matchIcmpv6Type((short)this.icmpv6Type1);
    Criterion matchIcmpv6Type2 = Criteria.matchIcmpv6Type((short)this.icmpv6Type2);
    short icmpv6Code1 = 1;
    short icmpv6Code2 = (short)2;
    Criterion matchIcmpv6Code1 = Criteria.matchIcmpv6Code((short)this.icmpv6Code1);
    Criterion sameAsMatchIcmpv6Code1 = Criteria.matchIcmpv6Code((short)this.icmpv6Code1);
    Criterion matchIcmpv6Code2 = Criteria.matchIcmpv6Code((short)this.icmpv6Code2);
    private static final String IPV6_ADDR1 = "fe80::1";
    private static final String IPV6_ADDR2 = "fe80::2";
    private Ip6Address ip6TargetAddress1 = Ip6Address.valueOf((String)"fe80::1");
    private Ip6Address ip6TargetAddress2 = Ip6Address.valueOf((String)"fe80::2");
    Criterion matchIpv6TargetAddr1 = Criteria.matchIPv6NDTargetAddress((Ip6Address)this.ip6TargetAddress1);
    Criterion sameAsMatchIpv6TargetAddr1 = Criteria.matchIPv6NDTargetAddress((Ip6Address)this.ip6TargetAddress1);
    Criterion matchIpv6TargetAddr2 = Criteria.matchIPv6NDTargetAddress((Ip6Address)this.ip6TargetAddress2);
    private static final String LL_MAC1 = "00:00:00:00:00:01";
    private static final String LL_MAC2 = "00:00:00:00:00:02";
    private MacAddress llMac1 = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private MacAddress llMac2 = MacAddress.valueOf((String)"00:00:00:00:00:02");
    Criterion matchSrcLlAddr1 = Criteria.matchIPv6NDSourceLinkLayerAddress((MacAddress)this.llMac1);
    Criterion sameAsMatchSrcLlAddr1 = Criteria.matchIPv6NDSourceLinkLayerAddress((MacAddress)this.llMac1);
    Criterion matchSrcLlAddr2 = Criteria.matchIPv6NDSourceLinkLayerAddress((MacAddress)this.llMac2);
    Criterion matchTargetLlAddr1 = Criteria.matchIPv6NDTargetLinkLayerAddress((MacAddress)this.llMac1);
    Criterion sameAsMatchTargetLlAddr1 = Criteria.matchIPv6NDTargetLinkLayerAddress((MacAddress)this.llMac1);
    Criterion matchTargetLlAddr2 = Criteria.matchIPv6NDTargetLinkLayerAddress((MacAddress)this.llMac2);
    MplsLabel mpls1 = MplsLabel.mplsLabel((int)1);
    MplsLabel mpls2 = MplsLabel.mplsLabel((int)2);
    Criterion matchMpls1 = Criteria.matchMplsLabel((MplsLabel)this.mpls1);
    Criterion sameAsMatchMpls1 = Criteria.matchMplsLabel((MplsLabel)this.mpls1);
    Criterion matchMpls2 = Criteria.matchMplsLabel((MplsLabel)this.mpls2);
    int ipv6ExthdrFlags1 = Criterion.IPv6ExthdrFlags.NONEXT.getValue() | Criterion.IPv6ExthdrFlags.ESP.getValue() | Criterion.IPv6ExthdrFlags.AUTH.getValue() | Criterion.IPv6ExthdrFlags.DEST.getValue() | Criterion.IPv6ExthdrFlags.FRAG.getValue() | Criterion.IPv6ExthdrFlags.ROUTER.getValue() | Criterion.IPv6ExthdrFlags.HOP.getValue() | Criterion.IPv6ExthdrFlags.UNREP.getValue();
    int ipv6ExthdrFlags2 = this.ipv6ExthdrFlags1 | Criterion.IPv6ExthdrFlags.UNSEQ.getValue();
    Criterion matchIpv6ExthdrFlags1 = Criteria.matchIPv6ExthdrFlags((int)this.ipv6ExthdrFlags1);
    Criterion sameAsMatchIpv6ExthdrFlags1 = Criteria.matchIPv6ExthdrFlags((int)this.ipv6ExthdrFlags1);
    Criterion matchIpv6ExthdrFlags2 = Criteria.matchIPv6ExthdrFlags((int)this.ipv6ExthdrFlags2);
    int lambda1 = 1;
    int lambda2 = 2;
    Criterion matchLambda1 = Criteria.matchLambda((int)this.lambda1);
    Criterion sameAsMatchLambda1 = Criteria.matchLambda((int)this.lambda1);
    Criterion matchLambda2 = Criteria.matchLambda((int)this.lambda2);
    short signalLambda1 = 1;
    short signalLambda2 = (short)2;
    Criterion matchSignalLambda1 = Criteria.matchOpticalSignalType((short)this.signalLambda1);
    Criterion sameAsMatchSignalLambda1 = Criteria.matchOpticalSignalType((short)this.signalLambda1);
    Criterion matchSignalLambda2 = Criteria.matchOpticalSignalType((short)this.signalLambda2);

    private <T> T checkAndConvert(Criterion criterion, Criterion.Type type, Class clazz) {
        MatcherAssert.assertThat((Object)criterion, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)criterion.type(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)type)));
        MatcherAssert.assertThat((Object)criterion, (Matcher)Matchers.instanceOf((Class)clazz));
        return (T)criterion;
    }

    @Test
    public void testCriteriaUtility() {
        UtilityClassChecker.assertThatClassIsUtility(Criteria.class);
    }

    @Test
    public void testCriteriaImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.PortCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.MetadataCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.EthCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.EthTypeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.VlanIdCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.VlanPcpCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IPDscpCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IPEcnCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IPProtocolCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IPCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.TcpPortCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.UdpPortCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.SctpPortCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IcmpTypeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IcmpCodeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IPv6FlowLabelCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.Icmpv6TypeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.Icmpv6CodeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IPv6NDTargetAddressCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IPv6NDLinkLayerAddressCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.MplsCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.IPv6ExthdrFlagsCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.LambdaCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Criteria.OpticalSignalTypeCriterion.class);
    }

    @Test
    public void testMatchInPortMethod() {
        PortNumber p1 = PortNumber.portNumber((long)1L);
        Criterion matchInPort = Criteria.matchInPort((PortNumber)p1);
        Criteria.PortCriterion portCriterion = (Criteria.PortCriterion)this.checkAndConvert(matchInPort, Criterion.Type.IN_PORT, Criteria.PortCriterion.class);
        MatcherAssert.assertThat((Object)portCriterion.port(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)p1)));
    }

    @Test
    public void testMatchInPhyPortMethod() {
        PortNumber p1 = PortNumber.portNumber((long)1L);
        Criterion matchInPhyPort = Criteria.matchInPhyPort((PortNumber)p1);
        Criteria.PortCriterion portCriterion = (Criteria.PortCriterion)this.checkAndConvert(matchInPhyPort, Criterion.Type.IN_PHY_PORT, Criteria.PortCriterion.class);
        MatcherAssert.assertThat((Object)portCriterion.port(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)p1)));
    }

    @Test
    public void testPortCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchInPort1, this.sameAsMatchInPort1}).addEqualityGroup(new Object[]{this.matchInPort2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchInPhyPort1, this.sameAsMatchInPhyPort1}).addEqualityGroup(new Object[]{this.matchInPhyPort2}).testEquals();
    }

    @Test
    public void testMatchMetadataMethod() {
        Long metadata = 12L;
        Criterion matchMetadata = Criteria.matchMetadata((long)metadata);
        Criteria.MetadataCriterion metadataCriterion = (Criteria.MetadataCriterion)this.checkAndConvert(matchMetadata, Criterion.Type.METADATA, Criteria.MetadataCriterion.class);
        MatcherAssert.assertThat((Object)metadataCriterion.metadata(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)metadata)));
    }

    @Test
    public void testMetadataCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchMetadata1, this.sameAsMatchMetadata1}).addEqualityGroup(new Object[]{this.matchMetadata2}).testEquals();
    }

    @Test
    public void testMatchEthDstMethod() {
        Criterion matchEthDst = Criteria.matchEthDst((MacAddress)this.mac1);
        Criteria.EthCriterion ethCriterion = (Criteria.EthCriterion)this.checkAndConvert(matchEthDst, Criterion.Type.ETH_DST, Criteria.EthCriterion.class);
        MatcherAssert.assertThat((Object)ethCriterion.mac(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.mac1)));
    }

    @Test
    public void testMatchEthSrcMethod() {
        Criterion matchEthSrc = Criteria.matchEthSrc((MacAddress)this.mac1);
        Criteria.EthCriterion ethCriterion = (Criteria.EthCriterion)this.checkAndConvert(matchEthSrc, Criterion.Type.ETH_SRC, Criteria.EthCriterion.class);
        MatcherAssert.assertThat((Object)ethCriterion.mac(), (Matcher)Matchers.is((Object)this.mac1));
    }

    @Test
    public void testEthCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchEth1, this.sameAsMatchEth1}).addEqualityGroup(new Object[]{this.matchEth2}).testEquals();
    }

    @Test
    public void testMatchEthTypeMethod() {
        int ethType = 12;
        Criterion matchEthType = Criteria.matchEthType((int)ethType);
        Criteria.EthTypeCriterion ethTypeCriterion = (Criteria.EthTypeCriterion)this.checkAndConvert(matchEthType, Criterion.Type.ETH_TYPE, Criteria.EthTypeCriterion.class);
        MatcherAssert.assertThat((Object)ethTypeCriterion.ethType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ethType)));
    }

    @Test
    public void testEthTypeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchEthType1, this.sameAsMatchEthType1}).addEqualityGroup(new Object[]{this.matchEthType2}).testEquals();
    }

    @Test
    public void testMatchVlanIdMethod() {
        Criterion matchVlanId = Criteria.matchVlanId((VlanId)this.vlanId1);
        Criteria.VlanIdCriterion vlanIdCriterion = (Criteria.VlanIdCriterion)this.checkAndConvert(matchVlanId, Criterion.Type.VLAN_VID, Criteria.VlanIdCriterion.class);
        MatcherAssert.assertThat((Object)vlanIdCriterion.vlanId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.vlanId1)));
    }

    @Test
    public void testVlanIdCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchVlanId1, this.sameAsMatchVlanId1}).addEqualityGroup(new Object[]{this.matchVlanId2}).testEquals();
    }

    @Test
    public void testMatchVlanPcpMethod() {
        Criterion matchVlanPcp = Criteria.matchVlanPcp((byte)this.vlanPcp1);
        Criteria.VlanPcpCriterion vlanPcpCriterion = (Criteria.VlanPcpCriterion)this.checkAndConvert(matchVlanPcp, Criterion.Type.VLAN_PCP, Criteria.VlanPcpCriterion.class);
        MatcherAssert.assertThat((Object)vlanPcpCriterion.priority(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.vlanPcp1)));
    }

    @Test
    public void testVlanPcpCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchVlanPcp1, this.sameAsMatchVlanPcp1}).addEqualityGroup(new Object[]{this.matchVlanPcp2}).testEquals();
    }

    @Test
    public void testMatchIPDscpMethod() {
        Criterion matchIPDscp = Criteria.matchIPDscp((byte)this.ipDscp1);
        Criteria.IPDscpCriterion ipDscpCriterion = (Criteria.IPDscpCriterion)this.checkAndConvert(matchIPDscp, Criterion.Type.IP_DSCP, Criteria.IPDscpCriterion.class);
        MatcherAssert.assertThat((Object)ipDscpCriterion.ipDscp(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ipDscp1)));
    }

    @Test
    public void testIPDscpCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpDscp1, this.sameAsMatchIpDscp1}).addEqualityGroup(new Object[]{this.matchIpDscp2}).testEquals();
    }

    @Test
    public void testMatchIPEcnMethod() {
        Criterion matchIPEcn = Criteria.matchIPEcn((byte)this.ipEcn1);
        Criteria.IPEcnCriterion ipEcnCriterion = (Criteria.IPEcnCriterion)this.checkAndConvert(matchIPEcn, Criterion.Type.IP_ECN, Criteria.IPEcnCriterion.class);
        MatcherAssert.assertThat((Object)ipEcnCriterion.ipEcn(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ipEcn1)));
    }

    @Test
    public void testIPEcnCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpEcn1, this.sameAsMatchIpEcn1}).addEqualityGroup(new Object[]{this.matchIpEcn2}).testEquals();
    }

    @Test
    public void testMatchIpProtocolMethod() {
        Criterion matchIPProtocol = Criteria.matchIPProtocol((short)this.protocol1);
        Criteria.IPProtocolCriterion ipProtocolCriterion = (Criteria.IPProtocolCriterion)this.checkAndConvert(matchIPProtocol, Criterion.Type.IP_PROTO, Criteria.IPProtocolCriterion.class);
        MatcherAssert.assertThat((Object)ipProtocolCriterion.protocol(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.protocol1)));
    }

    @Test
    public void testIpProtocolCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpProtocol1, this.sameAsMatchIpProtocol1}).addEqualityGroup(new Object[]{this.matchIpProtocol2}).testEquals();
    }

    @Test
    public void testMatchIPSrcMethod() {
        Criterion matchIpSrc = Criteria.matchIPSrc((IpPrefix)this.ip1);
        Criteria.IPCriterion ipCriterion = (Criteria.IPCriterion)this.checkAndConvert(matchIpSrc, Criterion.Type.IPV4_SRC, Criteria.IPCriterion.class);
        MatcherAssert.assertThat((Object)ipCriterion.ip(), (Matcher)Matchers.is((Object)this.ip1));
    }

    @Test
    public void testMatchIPDstMethod() {
        Criterion matchIPDst = Criteria.matchIPDst((IpPrefix)this.ip1);
        Criteria.IPCriterion ipCriterion = (Criteria.IPCriterion)this.checkAndConvert(matchIPDst, Criterion.Type.IPV4_DST, Criteria.IPCriterion.class);
        MatcherAssert.assertThat((Object)ipCriterion.ip(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ip1)));
    }

    @Test
    public void testMatchIPv6SrcMethod() {
        Criterion matchIpv6Src = Criteria.matchIPv6Src((IpPrefix)this.ipv61);
        Criteria.IPCriterion ipCriterion = (Criteria.IPCriterion)this.checkAndConvert(matchIpv6Src, Criterion.Type.IPV6_SRC, Criteria.IPCriterion.class);
        MatcherAssert.assertThat((Object)ipCriterion.ip(), (Matcher)Matchers.is((Object)this.ipv61));
    }

    @Test
    public void testMatchIPv6DstMethod() {
        Criterion matchIPv6Dst = Criteria.matchIPv6Dst((IpPrefix)this.ipv61);
        Criteria.IPCriterion ipCriterion = (Criteria.IPCriterion)this.checkAndConvert(matchIPv6Dst, Criterion.Type.IPV6_DST, Criteria.IPCriterion.class);
        MatcherAssert.assertThat((Object)ipCriterion.ip(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ipv61)));
    }

    @Test
    public void testIPCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIp1, this.sameAsMatchIp1}).addEqualityGroup(new Object[]{this.matchIp2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpv61, this.sameAsMatchIpv61}).addEqualityGroup(new Object[]{this.matchIpv62}).testEquals();
    }

    @Test
    public void testMatchTcpSrcMethod() {
        Criterion matchTcpSrc = Criteria.matchTcpSrc((int)1);
        Criteria.TcpPortCriterion tcpPortCriterion = (Criteria.TcpPortCriterion)this.checkAndConvert(matchTcpSrc, Criterion.Type.TCP_SRC, Criteria.TcpPortCriterion.class);
        MatcherAssert.assertThat((Object)tcpPortCriterion.tcpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testMatchTcpDstMethod() {
        Criterion matchTcpDst = Criteria.matchTcpDst((int)1);
        Criteria.TcpPortCriterion tcpPortCriterion = (Criteria.TcpPortCriterion)this.checkAndConvert(matchTcpDst, Criterion.Type.TCP_DST, Criteria.TcpPortCriterion.class);
        MatcherAssert.assertThat((Object)tcpPortCriterion.tcpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testTcpPortCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchTcpPort1, this.sameAsMatchTcpPort1}).addEqualityGroup(new Object[]{this.matchTcpPort2}).testEquals();
    }

    @Test
    public void testMatchUdpSrcMethod() {
        Criterion matchUdpSrc = Criteria.matchUdpSrc((int)1);
        Criteria.UdpPortCriterion udpPortCriterion = (Criteria.UdpPortCriterion)this.checkAndConvert(matchUdpSrc, Criterion.Type.UDP_SRC, Criteria.UdpPortCriterion.class);
        MatcherAssert.assertThat((Object)udpPortCriterion.udpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testMatchUdpDstMethod() {
        Criterion matchUdpDst = Criteria.matchUdpDst((int)1);
        Criteria.UdpPortCriterion udpPortCriterion = (Criteria.UdpPortCriterion)this.checkAndConvert(matchUdpDst, Criterion.Type.UDP_DST, Criteria.UdpPortCriterion.class);
        MatcherAssert.assertThat((Object)udpPortCriterion.udpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testUdpPortCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchUdpPort1, this.sameAsMatchUdpPort1}).addEqualityGroup(new Object[]{this.matchUdpPort2}).testEquals();
    }

    @Test
    public void testMatchSctpSrcMethod() {
        Criterion matchSctpSrc = Criteria.matchSctpSrc((int)1);
        Criteria.SctpPortCriterion sctpPortCriterion = (Criteria.SctpPortCriterion)this.checkAndConvert(matchSctpSrc, Criterion.Type.SCTP_SRC, Criteria.SctpPortCriterion.class);
        MatcherAssert.assertThat((Object)sctpPortCriterion.sctpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testMatchSctpDstMethod() {
        Criterion matchSctpDst = Criteria.matchSctpDst((int)1);
        Criteria.SctpPortCriterion sctpPortCriterion = (Criteria.SctpPortCriterion)this.checkAndConvert(matchSctpDst, Criterion.Type.SCTP_DST, Criteria.SctpPortCriterion.class);
        MatcherAssert.assertThat((Object)sctpPortCriterion.sctpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
    }

    @Test
    public void testSctpPortCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchSctpPort1, this.sameAsMatchSctpPort1}).addEqualityGroup(new Object[]{this.matchSctpPort2}).testEquals();
    }

    @Test
    public void testMatchIcmpTypeMethod() {
        short icmpType = 12;
        Criterion matchIcmpType = Criteria.matchIcmpType((short)icmpType);
        Criteria.IcmpTypeCriterion icmpTypeCriterion = (Criteria.IcmpTypeCriterion)this.checkAndConvert(matchIcmpType, Criterion.Type.ICMPV4_TYPE, Criteria.IcmpTypeCriterion.class);
        MatcherAssert.assertThat((Object)icmpTypeCriterion.icmpType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)icmpType)));
    }

    @Test
    public void testIcmpTypeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIcmpType1, this.sameAsMatchIcmpType1}).addEqualityGroup(new Object[]{this.matchIcmpType2}).testEquals();
    }

    @Test
    public void testMatchIcmpCodeMethod() {
        short icmpCode = 12;
        Criterion matchIcmpCode = Criteria.matchIcmpCode((short)icmpCode);
        Criteria.IcmpCodeCriterion icmpCodeCriterion = (Criteria.IcmpCodeCriterion)this.checkAndConvert(matchIcmpCode, Criterion.Type.ICMPV4_CODE, Criteria.IcmpCodeCriterion.class);
        MatcherAssert.assertThat((Object)icmpCodeCriterion.icmpCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)icmpCode)));
    }

    @Test
    public void testIcmpCodeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIcmpCode1, this.sameAsMatchIcmpCode1}).addEqualityGroup(new Object[]{this.matchIcmpCode2}).testEquals();
    }

    @Test
    public void testMatchIPv6FlowLabelMethod() {
        int flowLabel = 12;
        Criterion matchFlowLabel = Criteria.matchIPv6FlowLabel((int)flowLabel);
        Criteria.IPv6FlowLabelCriterion flowLabelCriterion = (Criteria.IPv6FlowLabelCriterion)this.checkAndConvert(matchFlowLabel, Criterion.Type.IPV6_FLABEL, Criteria.IPv6FlowLabelCriterion.class);
        MatcherAssert.assertThat((Object)flowLabelCriterion.flowLabel(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)flowLabel)));
    }

    @Test
    public void testIPv6FlowLabelCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchFlowLabel1, this.sameAsMatchFlowLabel1}).addEqualityGroup(new Object[]{this.matchFlowLabel2}).testEquals();
    }

    @Test
    public void testMatchIcmpv6TypeMethod() {
        short icmpv6Type = 12;
        Criterion matchIcmpv6Type = Criteria.matchIcmpv6Type((short)icmpv6Type);
        Criteria.Icmpv6TypeCriterion icmpv6TypeCriterion = (Criteria.Icmpv6TypeCriterion)this.checkAndConvert(matchIcmpv6Type, Criterion.Type.ICMPV6_TYPE, Criteria.Icmpv6TypeCriterion.class);
        MatcherAssert.assertThat((Object)icmpv6TypeCriterion.icmpv6Type(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)icmpv6Type)));
    }

    @Test
    public void testIcmpv6TypeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIcmpv6Type1, this.sameAsMatchIcmpv6Type1}).addEqualityGroup(new Object[]{this.matchIcmpv6Type2}).testEquals();
    }

    @Test
    public void testMatchIcmpv6CodeMethod() {
        short icmpv6Code = 12;
        Criterion matchIcmpv6Code = Criteria.matchIcmpv6Code((short)icmpv6Code);
        Criteria.Icmpv6CodeCriterion icmpv6CodeCriterion = (Criteria.Icmpv6CodeCriterion)this.checkAndConvert(matchIcmpv6Code, Criterion.Type.ICMPV6_CODE, Criteria.Icmpv6CodeCriterion.class);
        MatcherAssert.assertThat((Object)icmpv6CodeCriterion.icmpv6Code(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)icmpv6Code)));
    }

    @Test
    public void testIcmpv6CodeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIcmpv6Code1, this.sameAsMatchIcmpv6Code1}).addEqualityGroup(new Object[]{this.matchIcmpv6Code2}).testEquals();
    }

    @Test
    public void testMatchIPv6NDTargetAddressMethod() {
        Criterion matchTargetAddress = Criteria.matchIPv6NDTargetAddress((Ip6Address)this.ip6TargetAddress1);
        Criteria.IPv6NDTargetAddressCriterion targetAddressCriterion = (Criteria.IPv6NDTargetAddressCriterion)this.checkAndConvert(matchTargetAddress, Criterion.Type.IPV6_ND_TARGET, Criteria.IPv6NDTargetAddressCriterion.class);
        MatcherAssert.assertThat((Object)targetAddressCriterion.targetAddress(), (Matcher)Matchers.is((Object)this.ip6TargetAddress1));
    }

    @Test
    public void testIPv6NDTargetAddressCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpv6TargetAddr1, this.sameAsMatchIpv6TargetAddr1}).addEqualityGroup(new Object[]{this.matchIpv6TargetAddr2}).testEquals();
    }

    @Test
    public void testMatchIPv6NDSourceLinkLayerAddressMethod() {
        Criterion matchSrcLlAddr = Criteria.matchIPv6NDSourceLinkLayerAddress((MacAddress)this.llMac1);
        Criteria.IPv6NDLinkLayerAddressCriterion srcLlCriterion = (Criteria.IPv6NDLinkLayerAddressCriterion)this.checkAndConvert(matchSrcLlAddr, Criterion.Type.IPV6_ND_SLL, Criteria.IPv6NDLinkLayerAddressCriterion.class);
        MatcherAssert.assertThat((Object)srcLlCriterion.mac(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.llMac1)));
    }

    @Test
    public void testMatchIPv6NDTargetLinkLayerAddressMethod() {
        Criterion matchTargetLlAddr = Criteria.matchIPv6NDTargetLinkLayerAddress((MacAddress)this.llMac1);
        Criteria.IPv6NDLinkLayerAddressCriterion targetLlCriterion = (Criteria.IPv6NDLinkLayerAddressCriterion)this.checkAndConvert(matchTargetLlAddr, Criterion.Type.IPV6_ND_TLL, Criteria.IPv6NDLinkLayerAddressCriterion.class);
        MatcherAssert.assertThat((Object)targetLlCriterion.mac(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.llMac1)));
    }

    @Test
    public void testIPv6NDLinkLayerAddressCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchSrcLlAddr1, this.sameAsMatchSrcLlAddr1}).addEqualityGroup(new Object[]{this.matchSrcLlAddr2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchTargetLlAddr1, this.sameAsMatchTargetLlAddr1}).addEqualityGroup(new Object[]{this.matchTargetLlAddr2}).testEquals();
    }

    @Test
    public void testMatchMplsLabelMethod() {
        Criterion matchMplsLabel = Criteria.matchMplsLabel((MplsLabel)this.mpls1);
        Criteria.MplsCriterion mplsCriterion = (Criteria.MplsCriterion)this.checkAndConvert(matchMplsLabel, Criterion.Type.MPLS_LABEL, Criteria.MplsCriterion.class);
        MatcherAssert.assertThat((Object)mplsCriterion.label(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.mpls1)));
    }

    @Test
    public void testMplsCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchMpls1, this.sameAsMatchMpls1}).addEqualityGroup(new Object[]{this.matchMpls2}).testEquals();
    }

    @Test
    public void testMatchIPv6ExthdrFlagsMethod() {
        Criterion matchExthdrFlags = Criteria.matchIPv6ExthdrFlags((int)this.ipv6ExthdrFlags1);
        Criteria.IPv6ExthdrFlagsCriterion exthdrFlagsCriterion = (Criteria.IPv6ExthdrFlagsCriterion)this.checkAndConvert(matchExthdrFlags, Criterion.Type.IPV6_EXTHDR, Criteria.IPv6ExthdrFlagsCriterion.class);
        MatcherAssert.assertThat((Object)exthdrFlagsCriterion.exthdrFlags(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ipv6ExthdrFlags1)));
    }

    @Test
    public void testIPv6ExthdrFlagsCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpv6ExthdrFlags1, this.sameAsMatchIpv6ExthdrFlags1}).addEqualityGroup(new Object[]{this.matchIpv6ExthdrFlags2}).testEquals();
    }

    @Test
    public void testMatchLambdaMethod() {
        Criterion matchLambda = Criteria.matchLambda((int)this.lambda1);
        Criteria.LambdaCriterion lambdaCriterion = (Criteria.LambdaCriterion)this.checkAndConvert(matchLambda, Criterion.Type.OCH_SIGID, Criteria.LambdaCriterion.class);
        MatcherAssert.assertThat((Object)lambdaCriterion.lambda(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.lambda1)));
    }

    @Test
    public void testLambdaCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchLambda1, this.sameAsMatchLambda1}).addEqualityGroup(new Object[]{this.matchLambda2}).testEquals();
    }

    @Test
    public void testMatchOpticalSignalTypeMethod() {
        Criterion matchLambda = Criteria.matchOpticalSignalType((short)this.signalLambda1);
        Criteria.OpticalSignalTypeCriterion opticalSignalTypeCriterion = (Criteria.OpticalSignalTypeCriterion)this.checkAndConvert(matchLambda, Criterion.Type.OCH_SIGTYPE, Criteria.OpticalSignalTypeCriterion.class);
        MatcherAssert.assertThat((Object)opticalSignalTypeCriterion.signalType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.signalLambda1)));
    }

    @Test
    public void testOpticalSignalTypeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchSignalLambda1, this.sameAsMatchSignalLambda1}).addEqualityGroup(new Object[]{this.matchSignalLambda2}).testEquals();
    }
}

