/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.core.IdGenerator;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentState;
import org.onosproject.net.intent.IntentTestsMocks;
import org.onosproject.net.intent.MockIdGenerator;
import org.onosproject.store.Timestamp;

public class IntentDataTest {
    private Timestamp timestamp1;
    private Timestamp timestamp2;
    private Timestamp timestamp3;
    private Intent intent1;
    private Intent intent2;
    private Intent intent3;
    private IntentData data1;
    private IntentData data1Copy;
    private IntentData data2;
    private IntentData data2Copy;
    private IntentData data3;
    private IntentData data3Copy;
    IdGenerator idGenerator;

    @Before
    public void setUpTest() {
        this.idGenerator = new MockIdGenerator();
        Intent.bindIdGenerator((IdGenerator)this.idGenerator);
        this.timestamp1 = new IntentTestsMocks.MockTimestamp(1);
        this.timestamp2 = new IntentTestsMocks.MockTimestamp(2);
        this.timestamp3 = new IntentTestsMocks.MockTimestamp(3);
        this.intent1 = new IntentTestsMocks.MockIntent(1L);
        this.intent2 = new IntentTestsMocks.MockIntent(2L);
        this.intent3 = new IntentTestsMocks.MockIntent(3L);
        this.data1 = new IntentData(this.intent1, IntentState.INSTALLED, this.timestamp1);
        this.data1Copy = new IntentData(this.intent1, IntentState.INSTALLED, this.timestamp1);
        this.data2 = new IntentData(this.intent2, IntentState.INSTALLED, this.timestamp2);
        this.data2Copy = new IntentData(this.intent2, IntentState.INSTALLED, this.timestamp2);
        this.data3 = new IntentData(this.intent3, IntentState.INSTALLED, this.timestamp3);
        this.data3Copy = new IntentData(this.intent3, IntentState.INSTALLED, this.timestamp3);
    }

    @After
    public void tearDownTest() {
        Intent.unbindIdGenerator((IdGenerator)this.idGenerator);
    }

    @Test
    public void checkConstruction() {
        MatcherAssert.assertThat((Object)this.data1.state(), (Matcher)Matchers.is((Object)IntentState.INSTALLED));
        MatcherAssert.assertThat((Object)this.data1.version(), (Matcher)Matchers.is((Object)this.timestamp1));
        MatcherAssert.assertThat((Object)this.data1.intent(), (Matcher)Matchers.is((Object)this.intent1));
    }

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.data1, this.data1Copy}).addEqualityGroup(new Object[]{this.data2, this.data2Copy}).addEqualityGroup(new Object[]{this.data3, this.data3Copy}).testEquals();
    }
}

