/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.onlab.graph.Edge;
import org.onosproject.core.DefaultGroupId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.Link;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.Path;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentId;
import org.onosproject.net.resource.Bandwidth;
import org.onosproject.net.resource.BandwidthResourceRequest;
import org.onosproject.net.resource.Lambda;
import org.onosproject.net.resource.LambdaResourceAllocation;
import org.onosproject.net.resource.LambdaResourceRequest;
import org.onosproject.net.resource.LinkResourceAllocations;
import org.onosproject.net.resource.LinkResourceListener;
import org.onosproject.net.resource.LinkResourceRequest;
import org.onosproject.net.resource.LinkResourceService;
import org.onosproject.net.resource.MplsLabel;
import org.onosproject.net.resource.MplsLabelResourceAllocation;
import org.onosproject.net.resource.ResourceAllocation;
import org.onosproject.net.resource.ResourceRequest;
import org.onosproject.net.resource.ResourceType;
import org.onosproject.net.topology.DefaultTopologyEdge;
import org.onosproject.net.topology.DefaultTopologyVertex;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.PathService;
import org.onosproject.net.topology.TopologyVertex;
import org.onosproject.store.Timestamp;

public class IntentTestsMocks {
    private static final MockSelector SELECTOR = new MockSelector();
    private static final MockTreatment TREATMENT = new MockTreatment();

    public static class MockTimestamp
    implements Timestamp {
        final int value;

        public MockTimestamp(int value) {
            this.value = value;
        }

        public int compareTo(Timestamp o) {
            if (!(o instanceof MockTimestamp)) {
                return -1;
            }
            MockTimestamp that = (MockTimestamp)o;
            return this.value > that.value ? -1 : (this.value == that.value ? 0 : 1);
        }
    }

    public static class MockIntent
    extends Intent {
        private static AtomicLong counter = new AtomicLong(0L);
        private final Long number;

        public MockIntent(Long number) {
            super(NetTestTools.APP_ID, Collections.emptyList());
            this.number = number;
        }

        public MockIntent(Long number, Collection<NetworkResource> resources) {
            super(NetTestTools.APP_ID, resources);
            this.number = number;
        }

        public Long number() {
            return this.number;
        }

        public static Long nextId() {
            return counter.getAndIncrement();
        }

        public String toString() {
            return MoreObjects.toStringHelper(((Object)((Object)this)).getClass()).add("id", (Object)this.id()).add("appId", (Object)this.appId()).toString();
        }
    }

    public static class MockFlowRule
    implements FlowRule {
        int priority;
        FlowRule.Type type;

        public MockFlowRule(int priority) {
            this.priority = priority;
            this.type = FlowRule.Type.DEFAULT;
        }

        public FlowId id() {
            return FlowId.valueOf((long)1L);
        }

        public short appId() {
            return 0;
        }

        public GroupId groupId() {
            return new DefaultGroupId(0);
        }

        public int priority() {
            return this.priority;
        }

        public DeviceId deviceId() {
            return NetTestTools.did("1");
        }

        public TrafficSelector selector() {
            return SELECTOR;
        }

        public TrafficTreatment treatment() {
            return TREATMENT;
        }

        public int timeout() {
            return 0;
        }

        public boolean isPermanent() {
            return false;
        }

        public int hashCode() {
            return Objects.hash(this.priority);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            MockFlowRule other = (MockFlowRule)obj;
            return Objects.equals(this.priority, other.priority);
        }

        public FlowRule.Type type() {
            return this.type;
        }
    }

    public static class MockResourceService
    implements LinkResourceService {
        double availableBandwidth = -1.0;
        int availableLambda = -1;

        public static MockResourceService makeBandwidthResourceService(double bandwidth) {
            MockResourceService result = new MockResourceService();
            result.availableBandwidth = bandwidth;
            return result;
        }

        public static MockResourceService makeLambdaResourceService(int lambda) {
            MockResourceService result = new MockResourceService();
            result.availableLambda = lambda;
            return result;
        }

        public void setAvailableBandwidth(double availableBandwidth) {
            this.availableBandwidth = availableBandwidth;
        }

        public void setAvailableLambda(int availableLambda) {
            this.availableLambda = availableLambda;
        }

        public LinkResourceAllocations requestResources(LinkResourceRequest req) {
            int lambda = -1;
            double bandwidth = -1.0;
            for (ResourceRequest resourceRequest : req.resources()) {
                if (resourceRequest.type() == ResourceType.BANDWIDTH) {
                    BandwidthResourceRequest brr = (BandwidthResourceRequest)resourceRequest;
                    bandwidth = brr.bandwidth().toDouble();
                    continue;
                }
                if (resourceRequest.type() != ResourceType.LAMBDA) continue;
                lambda = 1;
            }
            if (this.availableBandwidth < bandwidth) {
                throw new MockedAllocationFailure();
            }
            if (lambda > 0 && this.availableLambda == 0) {
                throw new MockedAllocationFailure();
            }
            return new MockLinkResourceAllocations();
        }

        public void releaseResources(LinkResourceAllocations allocations) {
        }

        public LinkResourceAllocations updateResources(LinkResourceRequest req, LinkResourceAllocations oldAllocations) {
            return null;
        }

        public Iterable<LinkResourceAllocations> getAllocations() {
            return ImmutableSet.of((Object)new MockLinkResourceAllocations());
        }

        public Iterable<LinkResourceAllocations> getAllocations(Link link) {
            return ImmutableSet.of((Object)new MockLinkResourceAllocations());
        }

        public LinkResourceAllocations getAllocations(IntentId intentId) {
            return new MockLinkResourceAllocations();
        }

        public Iterable<ResourceRequest> getAvailableResources(Link link) {
            LinkedList<ResourceRequest> result = new LinkedList<ResourceRequest>();
            if (this.availableBandwidth > 0.0) {
                result.add((ResourceRequest)new BandwidthResourceRequest(Bandwidth.bps((double)this.availableBandwidth)));
            }
            if (this.availableLambda > 0) {
                result.add((ResourceRequest)new LambdaResourceRequest());
            }
            return result;
        }

        public Iterable<ResourceRequest> getAvailableResources(Link link, LinkResourceAllocations allocations) {
            return null;
        }

        public void addListener(LinkResourceListener listener) {
        }

        public void removeListener(LinkResourceListener listener) {
        }
    }

    public static class MockedAllocationFailure
    extends RuntimeException {
    }

    public static class MockLinkResourceAllocations
    implements LinkResourceAllocations {
        public Set<ResourceAllocation> getResourceAllocation(Link link) {
            return ImmutableSet.of((Object)new LambdaResourceAllocation(Lambda.valueOf((int)77)), (Object)new MplsLabelResourceAllocation(MplsLabel.valueOf((int)10)));
        }

        public IntentId intendId() {
            return null;
        }

        public Collection<Link> links() {
            return null;
        }

        public Set<ResourceRequest> resources() {
            return null;
        }

        public ResourceType type() {
            return null;
        }
    }

    public static class MockPathService
    implements PathService {
        final String[] pathHops;
        final String[] reversePathHops;

        public MockPathService(String[] pathHops) {
            this.pathHops = pathHops;
            String[] reversed = (String[])pathHops.clone();
            Collections.reverse(Arrays.asList(reversed));
            this.reversePathHops = reversed;
        }

        public Set<Path> getPaths(ElementId src, ElementId dst) {
            HashSet<Path> result = new HashSet<Path>();
            String[] allHops = new String[this.pathHops.length];
            if (src.toString().endsWith(this.pathHops[0])) {
                System.arraycopy(this.pathHops, 0, allHops, 0, this.pathHops.length);
            } else {
                System.arraycopy(this.reversePathHops, 0, allHops, 0, this.pathHops.length);
            }
            result.add(NetTestTools.createPath(allHops));
            return result;
        }

        public Set<Path> getPaths(ElementId src, ElementId dst, LinkWeight weight) {
            Set<Path> paths = this.getPaths(src, dst);
            for (Path path : paths) {
                Link link;
                DeviceId dstDevice;
                DefaultTopologyVertex dstVertex;
                DeviceId srcDevice = path.src().deviceId();
                DefaultTopologyVertex srcVertex = new DefaultTopologyVertex(srcDevice);
                double weightValue = weight.weight((Edge)new DefaultTopologyEdge((TopologyVertex)srcVertex, (TopologyVertex)(dstVertex = new DefaultTopologyVertex(dstDevice = path.dst().deviceId())), link = NetTestTools.link(src.toString(), 1, dst.toString(), 1)));
                if (!(weightValue < 0.0)) continue;
                return new HashSet<Path>();
            }
            return paths;
        }
    }

    public static class MockTreatment
    implements TrafficTreatment {
        public List<Instruction> instructions() {
            return new ArrayList<Instruction>();
        }

        public List<Instruction> deferred() {
            return null;
        }

        public List<Instruction> immediate() {
            return null;
        }

        public List<Instruction> allInstructions() {
            return null;
        }

        public Instructions.TableTypeTransition tableTransition() {
            return null;
        }

        public Boolean clearedDeferred() {
            return null;
        }
    }

    public static class MockSelector
    implements TrafficSelector {
        public Set<Criterion> criteria() {
            return new HashSet<Criterion>();
        }

        public Criterion getCriterion(Criterion.Type type) {
            return null;
        }
    }
}

