/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent.constraint;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onosproject.net.Link;
import org.onosproject.net.intent.constraint.BandwidthConstraint;
import org.onosproject.net.intent.constraint.LambdaConstraint;
import org.onosproject.net.intent.constraint.LinkTypeConstraint;
import org.onosproject.net.resource.Bandwidth;
import org.onosproject.net.resource.Lambda;

public class ConstraintObjectsTest {
    final BandwidthConstraint bandwidthConstraint1 = new BandwidthConstraint(Bandwidth.bps((double)100.0));
    final BandwidthConstraint bandwidthConstraintSameAs1 = new BandwidthConstraint(Bandwidth.bps((double)100.0));
    final BandwidthConstraint bandwidthConstraint2 = new BandwidthConstraint(Bandwidth.bps((double)200.0));
    final LambdaConstraint lambdaConstraint1 = new LambdaConstraint(Lambda.valueOf((int)100));
    final LambdaConstraint lambdaConstraintSameAs1 = new LambdaConstraint(Lambda.valueOf((int)100));
    final LambdaConstraint lambdaConstraint2 = new LambdaConstraint(Lambda.valueOf((int)200));
    final LinkTypeConstraint linkTypeConstraint1 = new LinkTypeConstraint(true, new Link.Type[]{Link.Type.OPTICAL, Link.Type.TUNNEL});
    final LinkTypeConstraint linkTypeConstraintSameAs1 = new LinkTypeConstraint(true, new Link.Type[]{Link.Type.OPTICAL, Link.Type.TUNNEL});
    final LinkTypeConstraint linkTypeConstraint2 = new LinkTypeConstraint(true, new Link.Type[]{Link.Type.OPTICAL, Link.Type.DIRECT});

    @Test
    public void testBandwidthConstraintCreation() {
        MatcherAssert.assertThat((Object)this.bandwidthConstraint1.bandwidth().toDouble(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)100.0)));
        MatcherAssert.assertThat((Object)this.bandwidthConstraintSameAs1.bandwidth().toDouble(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)100.0)));
        MatcherAssert.assertThat((Object)this.bandwidthConstraint2.bandwidth().toDouble(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200.0)));
    }

    @Test
    public void testBandwidthConstraintEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.bandwidthConstraint1, this.bandwidthConstraintSameAs1}).addEqualityGroup(new Object[]{this.bandwidthConstraint2}).testEquals();
    }

    @Test
    public void testLambdaConstraintCreation() {
        MatcherAssert.assertThat((Object)this.lambdaConstraint1.lambda().toInt(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)100)));
        MatcherAssert.assertThat((Object)this.lambdaConstraintSameAs1.lambda().toInt(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)100)));
        MatcherAssert.assertThat((Object)this.lambdaConstraint2.lambda().toInt(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)200)));
    }

    @Test
    public void testLambdaConstraintEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.lambdaConstraint1, this.lambdaConstraintSameAs1}).addEqualityGroup(new Object[]{this.lambdaConstraint2}).testEquals();
    }

    @Test
    public void testLinkTypeConstraintCreation() {
        MatcherAssert.assertThat((Object)this.linkTypeConstraint1.isInclusive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.linkTypeConstraint1.types(), (Matcher)Matchers.contains((Object[])new Link.Type[]{Link.Type.OPTICAL, Link.Type.TUNNEL}));
        MatcherAssert.assertThat((Object)this.linkTypeConstraintSameAs1.isInclusive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.linkTypeConstraintSameAs1.types(), (Matcher)Matchers.contains((Object[])new Link.Type[]{Link.Type.OPTICAL, Link.Type.TUNNEL}));
        MatcherAssert.assertThat((Object)this.linkTypeConstraint2.isInclusive(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)this.linkTypeConstraint2.types(), (Matcher)Matchers.contains((Object[])new Link.Type[]{Link.Type.OPTICAL, Link.Type.DIRECT}));
    }

    @Test
    public void testLinkTypeConstraintEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.linkTypeConstraint1, this.linkTypeConstraintSameAs1}).addEqualityGroup(new Object[]{this.linkTypeConstraint2}).testEquals();
    }
}

