/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.testing.EqualsTester;
import junit.framework.TestCase;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.PortNumber;

public class ConnectPointTest {
    private static final DeviceId DID1 = DeviceId.deviceId((String)"1");
    private static final DeviceId DID2 = DeviceId.deviceId((String)"2");
    private static final PortNumber P1 = PortNumber.portNumber((long)1L);
    private static final PortNumber P2 = PortNumber.portNumber((long)2L);

    @Test
    public void basics() {
        ConnectPoint p = new ConnectPoint((ElementId)DID1, P2);
        Assert.assertEquals((String)"incorrect element id", (Object)DID1, (Object)p.deviceId());
        Assert.assertEquals((String)"incorrect element id", (Object)P2, (Object)p.port());
    }

    @Test
    public void testEquality() {
        new EqualsTester().addEqualityGroup(new Object[]{new ConnectPoint((ElementId)DID1, P1), new ConnectPoint((ElementId)DID1, P1)}).addEqualityGroup(new Object[]{new ConnectPoint((ElementId)DID1, P2), new ConnectPoint((ElementId)DID1, P2)}).addEqualityGroup(new Object[]{new ConnectPoint((ElementId)DID2, P1), new ConnectPoint((ElementId)DID2, P1)}).testEquals();
    }

    @Test
    public void testParseDeviceConnectPoint() {
        String cp = "of:0011223344556677/1";
        ConnectPoint connectPoint = ConnectPoint.deviceConnectPoint((String)cp);
        Assert.assertEquals((Object)"of:0011223344556677", (Object)connectPoint.deviceId().toString());
        Assert.assertEquals((Object)"1", (Object)connectPoint.port().toString());
        ConnectPointTest.expectDeviceParseException("");
        ConnectPointTest.expectDeviceParseException("1/");
        ConnectPointTest.expectDeviceParseException("1/1/1");
        ConnectPointTest.expectDeviceParseException("of:0011223344556677/word");
    }

    private static void expectDeviceParseException(String string) {
        try {
            ConnectPoint.deviceConnectPoint((String)string);
            TestCase.fail((String)"Expected exception was not thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testParseHostConnectPoint() {
        String cp = "16:3A:BD:6E:31:E4/-1/1";
        ConnectPoint connectPoint = ConnectPoint.hostConnectPoint((String)cp);
        Assert.assertEquals((Object)"16:3A:BD:6E:31:E4/None", (Object)connectPoint.hostId().toString());
        Assert.assertEquals((Object)"1", (Object)connectPoint.port().toString());
        ConnectPointTest.expectHostParseException("");
        ConnectPointTest.expectHostParseException("1/");
        ConnectPointTest.expectHostParseException("1/1");
        ConnectPointTest.expectHostParseException("1/1/1/1");
        ConnectPointTest.expectHostParseException("16:3A:BD:6E:31:E4/word/1");
        ConnectPointTest.expectHostParseException("16:3A:BD:6E:31:E4/1/word");
    }

    private static void expectHostParseException(String string) {
        try {
            ConnectPoint.hostConnectPoint((String)string);
            TestCase.fail((String)"Expected exception was not thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

