/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.device;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.Port;
import org.onosproject.net.PortNumber;
import org.onosproject.net.SparseAnnotations;
import org.onosproject.net.device.DefaultPortDescription;
import org.onosproject.net.device.PortDescription;

public class DefaultPortDescriptionTest {
    private static PortNumber port1 = PortNumber.portNumber((long)1L);
    private static long portSpeed1 = 111L;
    private static DefaultPortDescription portDescription1 = new DefaultPortDescription(port1, true, Port.Type.COPPER, portSpeed1, new SparseAnnotations[0]);
    private static DefaultPortDescription sameAsPortDescription1 = new DefaultPortDescription((PortDescription)portDescription1, portDescription1.annotations());
    private static PortNumber port2 = PortNumber.portNumber((long)2L);
    private static DefaultPortDescription portDescription2 = new DefaultPortDescription(port2, true, new SparseAnnotations[0]);
    private static DefaultPortDescription portDescription3 = new DefaultPortDescription();

    @Test
    public void testImmutable() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(DefaultPortDescription.class);
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)portDescription1.portNumber(), (Matcher)Matchers.is((Object)port1));
        MatcherAssert.assertThat((Object)portDescription1.isEnabled(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)portDescription1.portSpeed(), (Matcher)Matchers.is((Object)portSpeed1));
        MatcherAssert.assertThat((Object)portDescription1.type(), (Matcher)Matchers.is((Object)Port.Type.COPPER));
    }

    @Test
    public void testEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{portDescription1, sameAsPortDescription1}).addEqualityGroup(new Object[]{portDescription2}).addEqualityGroup(new Object[]{portDescription3}).testEquals();
    }
}

