/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.criteria;

import com.google.common.testing.EqualsTester;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.junit.UtilityClassChecker;
import org.onlab.packet.EthType;
import org.onlab.packet.Ip6Address;
import org.onlab.packet.IpPrefix;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.GridType;
import org.onosproject.net.Lambda;
import org.onosproject.net.OchSignalType;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.OduSignalType;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.criteria.Criteria;
import org.onosproject.net.flow.criteria.Criterion;
import org.onosproject.net.flow.criteria.EthCriterion;
import org.onosproject.net.flow.criteria.EthTypeCriterion;
import org.onosproject.net.flow.criteria.IPCriterion;
import org.onosproject.net.flow.criteria.IPDscpCriterion;
import org.onosproject.net.flow.criteria.IPEcnCriterion;
import org.onosproject.net.flow.criteria.IPProtocolCriterion;
import org.onosproject.net.flow.criteria.IPv6ExthdrFlagsCriterion;
import org.onosproject.net.flow.criteria.IPv6FlowLabelCriterion;
import org.onosproject.net.flow.criteria.IPv6NDLinkLayerAddressCriterion;
import org.onosproject.net.flow.criteria.IPv6NDTargetAddressCriterion;
import org.onosproject.net.flow.criteria.IcmpCodeCriterion;
import org.onosproject.net.flow.criteria.IcmpTypeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6CodeCriterion;
import org.onosproject.net.flow.criteria.Icmpv6TypeCriterion;
import org.onosproject.net.flow.criteria.LambdaCriterion;
import org.onosproject.net.flow.criteria.MetadataCriterion;
import org.onosproject.net.flow.criteria.MplsCriterion;
import org.onosproject.net.flow.criteria.MplsTcCriterion;
import org.onosproject.net.flow.criteria.OduSignalIdCriterion;
import org.onosproject.net.flow.criteria.OduSignalTypeCriterion;
import org.onosproject.net.flow.criteria.PbbIsidCriterion;
import org.onosproject.net.flow.criteria.PortCriterion;
import org.onosproject.net.flow.criteria.SctpPortCriterion;
import org.onosproject.net.flow.criteria.TcpFlagsCriterion;
import org.onosproject.net.flow.criteria.TcpPortCriterion;
import org.onosproject.net.flow.criteria.TunnelIdCriterion;
import org.onosproject.net.flow.criteria.UdpPortCriterion;
import org.onosproject.net.flow.criteria.VlanIdCriterion;
import org.onosproject.net.flow.criteria.VlanPcpCriterion;

public class CriteriaTest {
    final PortNumber port1 = PortNumber.portNumber((long)1L);
    final PortNumber port2 = PortNumber.portNumber((long)2L);
    Criterion matchInPort1 = Criteria.matchInPort((PortNumber)this.port1);
    Criterion sameAsMatchInPort1 = Criteria.matchInPort((PortNumber)this.port1);
    Criterion matchInPort2 = Criteria.matchInPort((PortNumber)this.port2);
    Criterion matchInPhyPort1 = Criteria.matchInPhyPort((PortNumber)this.port1);
    Criterion sameAsMatchInPhyPort1 = Criteria.matchInPhyPort((PortNumber)this.port1);
    Criterion matchInPhyPort2 = Criteria.matchInPhyPort((PortNumber)this.port2);
    long metadata1 = 1L;
    long metadata2 = 2L;
    Criterion matchMetadata1 = Criteria.matchMetadata((long)this.metadata1);
    Criterion sameAsMatchMetadata1 = Criteria.matchMetadata((long)this.metadata1);
    Criterion matchMetadata2 = Criteria.matchMetadata((long)this.metadata2);
    private static final String MAC1 = "00:00:00:00:00:01";
    private static final String MAC2 = "00:00:00:00:00:02";
    private MacAddress mac1 = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private MacAddress mac2 = MacAddress.valueOf((String)"00:00:00:00:00:02");
    Criterion matchEth1 = Criteria.matchEthSrc((MacAddress)this.mac1);
    Criterion sameAsMatchEth1 = Criteria.matchEthSrc((MacAddress)this.mac1);
    Criterion matchEth2 = Criteria.matchEthDst((MacAddress)this.mac2);
    int ethType1 = 1;
    int ethType2 = 2;
    Criterion matchEthType1 = Criteria.matchEthType((int)this.ethType1);
    Criterion sameAsMatchEthType1 = Criteria.matchEthType((int)this.ethType1);
    Criterion matchEthType2 = Criteria.matchEthType((int)this.ethType2);
    short vlan1 = 1;
    short vlan2 = (short)2;
    VlanId vlanId1 = VlanId.vlanId((short)this.vlan1);
    VlanId vlanId2 = VlanId.vlanId((short)this.vlan2);
    Criterion matchVlanId1 = Criteria.matchVlanId((VlanId)this.vlanId1);
    Criterion sameAsMatchVlanId1 = Criteria.matchVlanId((VlanId)this.vlanId1);
    Criterion matchVlanId2 = Criteria.matchVlanId((VlanId)this.vlanId2);
    byte vlanPcp1 = 1;
    byte vlanPcp2 = (byte)2;
    Criterion matchVlanPcp1 = Criteria.matchVlanPcp((byte)this.vlanPcp1);
    Criterion sameAsMatchVlanPcp1 = Criteria.matchVlanPcp((byte)this.vlanPcp1);
    Criterion matchVlanPcp2 = Criteria.matchVlanPcp((byte)this.vlanPcp2);
    byte ipDscp1 = 1;
    byte ipDscp2 = (byte)2;
    Criterion matchIpDscp1 = Criteria.matchIPDscp((byte)this.ipDscp1);
    Criterion sameAsMatchIpDscp1 = Criteria.matchIPDscp((byte)this.ipDscp1);
    Criterion matchIpDscp2 = Criteria.matchIPDscp((byte)this.ipDscp2);
    byte ipEcn1 = 1;
    byte ipEcn2 = (byte)2;
    Criterion matchIpEcn1 = Criteria.matchIPEcn((byte)this.ipEcn1);
    Criterion sameAsMatchIpEcn1 = Criteria.matchIPEcn((byte)this.ipEcn1);
    Criterion matchIpEcn2 = Criteria.matchIPEcn((byte)this.ipEcn2);
    short protocol1 = 1;
    short protocol2 = (short)2;
    Criterion matchIpProtocol1 = Criteria.matchIPProtocol((short)this.protocol1);
    Criterion sameAsMatchIpProtocol1 = Criteria.matchIPProtocol((short)this.protocol1);
    Criterion matchIpProtocol2 = Criteria.matchIPProtocol((short)this.protocol2);
    private static final String IP1 = "1.2.3.4/24";
    private static final String IP2 = "5.6.7.8/24";
    private static final String IPV61 = "fe80::1/64";
    private static final String IPV62 = "fc80::2/64";
    private IpPrefix ip1 = IpPrefix.valueOf((String)"1.2.3.4/24");
    private IpPrefix ip2 = IpPrefix.valueOf((String)"5.6.7.8/24");
    private IpPrefix ipv61 = IpPrefix.valueOf((String)"fe80::1/64");
    private IpPrefix ipv62 = IpPrefix.valueOf((String)"fc80::2/64");
    Criterion matchIp1 = Criteria.matchIPSrc((IpPrefix)this.ip1);
    Criterion sameAsMatchIp1 = Criteria.matchIPSrc((IpPrefix)this.ip1);
    Criterion matchIp2 = Criteria.matchIPSrc((IpPrefix)this.ip2);
    Criterion matchIpv61 = Criteria.matchIPSrc((IpPrefix)this.ipv61);
    Criterion sameAsMatchIpv61 = Criteria.matchIPSrc((IpPrefix)this.ipv61);
    Criterion matchIpv62 = Criteria.matchIPSrc((IpPrefix)this.ipv62);
    private TpPort tpPort1 = TpPort.tpPort((int)1);
    private TpPort tpPort2 = TpPort.tpPort((int)2);
    Criterion matchTcpPort1 = Criteria.matchTcpSrc((TpPort)this.tpPort1);
    Criterion sameAsMatchTcpPort1 = Criteria.matchTcpSrc((TpPort)this.tpPort1);
    Criterion matchTcpPort2 = Criteria.matchTcpDst((TpPort)this.tpPort2);
    Criterion matchUdpPort1 = Criteria.matchUdpSrc((TpPort)this.tpPort1);
    Criterion sameAsMatchUdpPort1 = Criteria.matchUdpSrc((TpPort)this.tpPort1);
    Criterion matchUdpPort2 = Criteria.matchUdpDst((TpPort)this.tpPort2);
    int tcpFlags1 = Criterion.TcpFlags.NS.getValue() | Criterion.TcpFlags.CWR.getValue() | Criterion.TcpFlags.ECE.getValue() | Criterion.TcpFlags.URG.getValue() | Criterion.TcpFlags.ACK.getValue() | Criterion.TcpFlags.PSH.getValue() | Criterion.TcpFlags.RST.getValue() | Criterion.TcpFlags.SYN.getValue();
    int tcpFlags2 = this.tcpFlags1 | Criterion.TcpFlags.FIN.getValue();
    Criterion matchTcpFlags1 = Criteria.matchTcpFlags((int)this.tcpFlags1);
    Criterion sameAsmatchTcpFlags1 = Criteria.matchTcpFlags((int)this.tcpFlags1);
    Criterion matchTcpFlags2 = Criteria.matchTcpFlags((int)this.tcpFlags2);
    Criterion matchSctpPort1 = Criteria.matchSctpSrc((TpPort)this.tpPort1);
    Criterion sameAsMatchSctpPort1 = Criteria.matchSctpSrc((TpPort)this.tpPort1);
    Criterion matchSctpPort2 = Criteria.matchSctpDst((TpPort)this.tpPort2);
    short icmpType1 = 1;
    short icmpType2 = (short)2;
    Criterion matchIcmpType1 = Criteria.matchIcmpType((short)this.icmpType1);
    Criterion sameAsMatchIcmpType1 = Criteria.matchIcmpType((short)this.icmpType1);
    Criterion matchIcmpType2 = Criteria.matchIcmpType((short)this.icmpType2);
    short icmpCode1 = 1;
    short icmpCode2 = (short)2;
    Criterion matchIcmpCode1 = Criteria.matchIcmpCode((short)this.icmpCode1);
    Criterion sameAsMatchIcmpCode1 = Criteria.matchIcmpCode((short)this.icmpCode1);
    Criterion matchIcmpCode2 = Criteria.matchIcmpCode((short)this.icmpCode2);
    int flowLabel1 = 1;
    int flowLabel2 = 2;
    Criterion matchFlowLabel1 = Criteria.matchIPv6FlowLabel((int)this.flowLabel1);
    Criterion sameAsMatchFlowLabel1 = Criteria.matchIPv6FlowLabel((int)this.flowLabel1);
    Criterion matchFlowLabel2 = Criteria.matchIPv6FlowLabel((int)this.flowLabel2);
    short icmpv6Type1 = 1;
    short icmpv6Type2 = (short)2;
    Criterion matchIcmpv6Type1 = Criteria.matchIcmpv6Type((short)this.icmpv6Type1);
    Criterion sameAsMatchIcmpv6Type1 = Criteria.matchIcmpv6Type((short)this.icmpv6Type1);
    Criterion matchIcmpv6Type2 = Criteria.matchIcmpv6Type((short)this.icmpv6Type2);
    short icmpv6Code1 = 1;
    short icmpv6Code2 = (short)2;
    Criterion matchIcmpv6Code1 = Criteria.matchIcmpv6Code((short)this.icmpv6Code1);
    Criterion sameAsMatchIcmpv6Code1 = Criteria.matchIcmpv6Code((short)this.icmpv6Code1);
    Criterion matchIcmpv6Code2 = Criteria.matchIcmpv6Code((short)this.icmpv6Code2);
    private static final String IPV6_ADDR1 = "fe80::1";
    private static final String IPV6_ADDR2 = "fe80::2";
    private Ip6Address ip6TargetAddress1 = Ip6Address.valueOf((String)"fe80::1");
    private Ip6Address ip6TargetAddress2 = Ip6Address.valueOf((String)"fe80::2");
    Criterion matchIpv6TargetAddr1 = Criteria.matchIPv6NDTargetAddress((Ip6Address)this.ip6TargetAddress1);
    Criterion sameAsMatchIpv6TargetAddr1 = Criteria.matchIPv6NDTargetAddress((Ip6Address)this.ip6TargetAddress1);
    Criterion matchIpv6TargetAddr2 = Criteria.matchIPv6NDTargetAddress((Ip6Address)this.ip6TargetAddress2);
    private static final String LL_MAC1 = "00:00:00:00:00:01";
    private static final String LL_MAC2 = "00:00:00:00:00:02";
    private MacAddress llMac1 = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private MacAddress llMac2 = MacAddress.valueOf((String)"00:00:00:00:00:02");
    Criterion matchSrcLlAddr1 = Criteria.matchIPv6NDSourceLinkLayerAddress((MacAddress)this.llMac1);
    Criterion sameAsMatchSrcLlAddr1 = Criteria.matchIPv6NDSourceLinkLayerAddress((MacAddress)this.llMac1);
    Criterion matchSrcLlAddr2 = Criteria.matchIPv6NDSourceLinkLayerAddress((MacAddress)this.llMac2);
    Criterion matchTargetLlAddr1 = Criteria.matchIPv6NDTargetLinkLayerAddress((MacAddress)this.llMac1);
    Criterion sameAsMatchTargetLlAddr1 = Criteria.matchIPv6NDTargetLinkLayerAddress((MacAddress)this.llMac1);
    Criterion matchTargetLlAddr2 = Criteria.matchIPv6NDTargetLinkLayerAddress((MacAddress)this.llMac2);
    MplsLabel mpls1 = MplsLabel.mplsLabel((int)1);
    MplsLabel mpls2 = MplsLabel.mplsLabel((int)2);
    Criterion matchMpls1 = Criteria.matchMplsLabel((MplsLabel)this.mpls1);
    Criterion sameAsMatchMpls1 = Criteria.matchMplsLabel((MplsLabel)this.mpls1);
    Criterion matchMpls2 = Criteria.matchMplsLabel((MplsLabel)this.mpls2);
    byte mplsTc1 = 1;
    byte mplsTc2 = (byte)2;
    Criterion matchMplsTc1 = Criteria.matchMplsTc((byte)this.mplsTc1);
    Criterion sameAsMatchMplsTc1 = Criteria.matchMplsTc((byte)this.mplsTc1);
    Criterion matchMplsTc2 = Criteria.matchMplsTc((byte)this.mplsTc2);
    long tunnelId1 = 1L;
    long tunnelId2 = 2L;
    Criterion matchTunnelId1 = Criteria.matchTunnelId((long)this.tunnelId1);
    Criterion sameAsMatchTunnelId1 = Criteria.matchTunnelId((long)this.tunnelId1);
    Criterion matchTunnelId2 = Criteria.matchTunnelId((long)this.tunnelId2);
    int ipv6ExthdrFlags1 = Criterion.IPv6ExthdrFlags.NONEXT.getValue() | Criterion.IPv6ExthdrFlags.ESP.getValue() | Criterion.IPv6ExthdrFlags.AUTH.getValue() | Criterion.IPv6ExthdrFlags.DEST.getValue() | Criterion.IPv6ExthdrFlags.FRAG.getValue() | Criterion.IPv6ExthdrFlags.ROUTER.getValue() | Criterion.IPv6ExthdrFlags.HOP.getValue() | Criterion.IPv6ExthdrFlags.UNREP.getValue();
    int ipv6ExthdrFlags2 = this.ipv6ExthdrFlags1 | Criterion.IPv6ExthdrFlags.UNSEQ.getValue();
    Criterion matchIpv6ExthdrFlags1 = Criteria.matchIPv6ExthdrFlags((int)this.ipv6ExthdrFlags1);
    Criterion sameAsMatchIpv6ExthdrFlags1 = Criteria.matchIPv6ExthdrFlags((int)this.ipv6ExthdrFlags1);
    Criterion matchIpv6ExthdrFlags2 = Criteria.matchIPv6ExthdrFlags((int)this.ipv6ExthdrFlags2);
    Criterion matchOchSignalType1 = Criteria.matchOchSignalType((OchSignalType)OchSignalType.FIXED_GRID);
    Criterion sameAsMatchOchSignalType1 = Criteria.matchOchSignalType((OchSignalType)OchSignalType.FIXED_GRID);
    Criterion matchOchSignalType2 = Criteria.matchOchSignalType((OchSignalType)OchSignalType.FLEX_GRID);
    Criterion matchOchSignal1 = Criteria.matchLambda((Lambda)Lambda.ochSignal((GridType)GridType.DWDM, (ChannelSpacing)ChannelSpacing.CHL_100GHZ, (int)4, (int)8));
    Criterion sameAsMatchOchSignal1 = Criteria.matchLambda((Lambda)Lambda.ochSignal((GridType)GridType.DWDM, (ChannelSpacing)ChannelSpacing.CHL_100GHZ, (int)4, (int)8));
    Criterion matchOchSignal2 = Criteria.matchLambda((Lambda)Lambda.ochSignal((GridType)GridType.DWDM, (ChannelSpacing)ChannelSpacing.CHL_50GHZ, (int)4, (int)8));
    final OduSignalId odu1 = OduSignalId.oduSignalId((int)1, (int)80, (byte[])new byte[]{1, 1, 2, 2, 1, 2, 2, 1, 2, 2});
    final OduSignalId odu2 = OduSignalId.oduSignalId((int)3, (int)8, (byte[])new byte[]{1, 0, 0, 0, 0, 0, 0, 0, 0, 0});
    Criterion matchOduSignalId1 = Criteria.matchOduSignalId((OduSignalId)this.odu1);
    Criterion sameAsMatchOduSignalId1 = Criteria.matchOduSignalId((OduSignalId)this.odu1);
    Criterion matchOduSignalId2 = Criteria.matchOduSignalId((OduSignalId)this.odu2);
    final OduSignalType oduSigType1 = OduSignalType.ODU2;
    final OduSignalType oduSigType2 = OduSignalType.ODU4;
    Criterion matchOduSignalType1 = Criteria.matchOduSignalType((OduSignalType)this.oduSigType1);
    Criterion sameAsMatchOduSignalType1 = Criteria.matchOduSignalType((OduSignalType)this.oduSigType1);
    Criterion matchOduSignalType2 = Criteria.matchOduSignalType((OduSignalType)this.oduSigType2);
    int pbbIsid1 = 1;
    int pbbIsid2 = 2;
    Criterion matchPbbIsid1 = Criteria.matchPbbIsid((int)this.pbbIsid1);
    Criterion sameAsMatchPbbIsid1 = Criteria.matchPbbIsid((int)this.pbbIsid1);
    Criterion matchPbbIsid2 = Criteria.matchPbbIsid((int)this.pbbIsid2);

    private <T> T checkAndConvert(Criterion criterion, Criterion.Type type, Class clazz) {
        MatcherAssert.assertThat((Object)criterion, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)criterion.type(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)type)));
        MatcherAssert.assertThat((Object)criterion, (Matcher)Matchers.instanceOf((Class)clazz));
        return (T)criterion;
    }

    @Test
    public void testCriteriaUtility() {
        UtilityClassChecker.assertThatClassIsUtility(Criteria.class);
    }

    @Test
    public void testCriteriaImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutable(PortCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(MetadataCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(EthCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(EthTypeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(VlanIdCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(VlanPcpCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IPDscpCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IPEcnCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IPProtocolCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IPCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(TcpPortCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(UdpPortCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(TcpFlagsCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(SctpPortCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IcmpTypeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IcmpCodeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IPv6FlowLabelCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Icmpv6TypeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(Icmpv6CodeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IPv6NDTargetAddressCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IPv6NDLinkLayerAddressCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(MplsCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(MplsTcCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(IPv6ExthdrFlagsCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(LambdaCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(OduSignalIdCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(OduSignalTypeCriterion.class);
        ImmutableClassChecker.assertThatClassIsImmutable(PbbIsidCriterion.class);
    }

    @Test
    public void testMatchInPortMethod() {
        PortNumber p1 = PortNumber.portNumber((long)1L);
        Criterion matchInPort = Criteria.matchInPort((PortNumber)p1);
        PortCriterion portCriterion = (PortCriterion)this.checkAndConvert(matchInPort, Criterion.Type.IN_PORT, PortCriterion.class);
        MatcherAssert.assertThat((Object)portCriterion.port(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)p1)));
    }

    @Test
    public void testMatchInPhyPortMethod() {
        PortNumber p1 = PortNumber.portNumber((long)1L);
        Criterion matchInPhyPort = Criteria.matchInPhyPort((PortNumber)p1);
        PortCriterion portCriterion = (PortCriterion)this.checkAndConvert(matchInPhyPort, Criterion.Type.IN_PHY_PORT, PortCriterion.class);
        MatcherAssert.assertThat((Object)portCriterion.port(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)p1)));
    }

    @Test
    public void testPortCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchInPort1, this.sameAsMatchInPort1}).addEqualityGroup(new Object[]{this.matchInPort2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchInPhyPort1, this.sameAsMatchInPhyPort1}).addEqualityGroup(new Object[]{this.matchInPhyPort2}).testEquals();
    }

    @Test
    public void testMatchMetadataMethod() {
        Long metadata = 12L;
        Criterion matchMetadata = Criteria.matchMetadata((long)metadata);
        MetadataCriterion metadataCriterion = (MetadataCriterion)this.checkAndConvert(matchMetadata, Criterion.Type.METADATA, MetadataCriterion.class);
        MatcherAssert.assertThat((Object)metadataCriterion.metadata(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)metadata)));
    }

    @Test
    public void testMetadataCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchMetadata1, this.sameAsMatchMetadata1}).addEqualityGroup(new Object[]{this.matchMetadata2}).testEquals();
    }

    @Test
    public void testMatchEthDstMethod() {
        Criterion matchEthDst = Criteria.matchEthDst((MacAddress)this.mac1);
        EthCriterion ethCriterion = (EthCriterion)this.checkAndConvert(matchEthDst, Criterion.Type.ETH_DST, EthCriterion.class);
        MatcherAssert.assertThat((Object)ethCriterion.mac(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.mac1)));
    }

    @Test
    public void testMatchEthSrcMethod() {
        Criterion matchEthSrc = Criteria.matchEthSrc((MacAddress)this.mac1);
        EthCriterion ethCriterion = (EthCriterion)this.checkAndConvert(matchEthSrc, Criterion.Type.ETH_SRC, EthCriterion.class);
        MatcherAssert.assertThat((Object)ethCriterion.mac(), (Matcher)Matchers.is((Object)this.mac1));
    }

    @Test
    public void testEthCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchEth1, this.sameAsMatchEth1}).addEqualityGroup(new Object[]{this.matchEth2}).testEquals();
    }

    @Test
    public void testMatchEthTypeMethod() {
        EthType ethType = new EthType(12);
        Criterion matchEthType = Criteria.matchEthType((EthType)new EthType(12));
        EthTypeCriterion ethTypeCriterion = (EthTypeCriterion)this.checkAndConvert(matchEthType, Criterion.Type.ETH_TYPE, EthTypeCriterion.class);
        MatcherAssert.assertThat((Object)ethTypeCriterion.ethType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)ethType)));
    }

    @Test
    public void testEthTypeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchEthType1, this.sameAsMatchEthType1}).addEqualityGroup(new Object[]{this.matchEthType2}).testEquals();
    }

    @Test
    public void testMatchVlanIdMethod() {
        Criterion matchVlanId = Criteria.matchVlanId((VlanId)this.vlanId1);
        VlanIdCriterion vlanIdCriterion = (VlanIdCriterion)this.checkAndConvert(matchVlanId, Criterion.Type.VLAN_VID, VlanIdCriterion.class);
        MatcherAssert.assertThat((Object)vlanIdCriterion.vlanId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.vlanId1)));
    }

    @Test
    public void testVlanIdCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchVlanId1, this.sameAsMatchVlanId1}).addEqualityGroup(new Object[]{this.matchVlanId2}).testEquals();
    }

    @Test
    public void testMatchVlanPcpMethod() {
        Criterion matchVlanPcp = Criteria.matchVlanPcp((byte)this.vlanPcp1);
        VlanPcpCriterion vlanPcpCriterion = (VlanPcpCriterion)this.checkAndConvert(matchVlanPcp, Criterion.Type.VLAN_PCP, VlanPcpCriterion.class);
        MatcherAssert.assertThat((Object)vlanPcpCriterion.priority(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.vlanPcp1)));
    }

    @Test
    public void testVlanPcpCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchVlanPcp1, this.sameAsMatchVlanPcp1}).addEqualityGroup(new Object[]{this.matchVlanPcp2}).testEquals();
    }

    @Test
    public void testMatchIPDscpMethod() {
        Criterion matchIPDscp = Criteria.matchIPDscp((byte)this.ipDscp1);
        IPDscpCriterion ipDscpCriterion = (IPDscpCriterion)this.checkAndConvert(matchIPDscp, Criterion.Type.IP_DSCP, IPDscpCriterion.class);
        MatcherAssert.assertThat((Object)ipDscpCriterion.ipDscp(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ipDscp1)));
    }

    @Test
    public void testIPDscpCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpDscp1, this.sameAsMatchIpDscp1}).addEqualityGroup(new Object[]{this.matchIpDscp2}).testEquals();
    }

    @Test
    public void testMatchIPEcnMethod() {
        Criterion matchIPEcn = Criteria.matchIPEcn((byte)this.ipEcn1);
        IPEcnCriterion ipEcnCriterion = (IPEcnCriterion)this.checkAndConvert(matchIPEcn, Criterion.Type.IP_ECN, IPEcnCriterion.class);
        MatcherAssert.assertThat((Object)ipEcnCriterion.ipEcn(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ipEcn1)));
    }

    @Test
    public void testIPEcnCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpEcn1, this.sameAsMatchIpEcn1}).addEqualityGroup(new Object[]{this.matchIpEcn2}).testEquals();
    }

    @Test
    public void testMatchIpProtocolMethod() {
        Criterion matchIPProtocol = Criteria.matchIPProtocol((short)this.protocol1);
        IPProtocolCriterion ipProtocolCriterion = (IPProtocolCriterion)this.checkAndConvert(matchIPProtocol, Criterion.Type.IP_PROTO, IPProtocolCriterion.class);
        MatcherAssert.assertThat((Object)ipProtocolCriterion.protocol(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.protocol1)));
    }

    @Test
    public void testIpProtocolCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpProtocol1, this.sameAsMatchIpProtocol1}).addEqualityGroup(new Object[]{this.matchIpProtocol2}).testEquals();
    }

    @Test
    public void testMatchIPSrcMethod() {
        Criterion matchIpSrc = Criteria.matchIPSrc((IpPrefix)this.ip1);
        IPCriterion ipCriterion = (IPCriterion)this.checkAndConvert(matchIpSrc, Criterion.Type.IPV4_SRC, IPCriterion.class);
        MatcherAssert.assertThat((Object)ipCriterion.ip(), (Matcher)Matchers.is((Object)this.ip1));
    }

    @Test
    public void testMatchIPDstMethod() {
        Criterion matchIPDst = Criteria.matchIPDst((IpPrefix)this.ip1);
        IPCriterion ipCriterion = (IPCriterion)this.checkAndConvert(matchIPDst, Criterion.Type.IPV4_DST, IPCriterion.class);
        MatcherAssert.assertThat((Object)ipCriterion.ip(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ip1)));
    }

    @Test
    public void testMatchIPv6SrcMethod() {
        Criterion matchIpv6Src = Criteria.matchIPv6Src((IpPrefix)this.ipv61);
        IPCriterion ipCriterion = (IPCriterion)this.checkAndConvert(matchIpv6Src, Criterion.Type.IPV6_SRC, IPCriterion.class);
        MatcherAssert.assertThat((Object)ipCriterion.ip(), (Matcher)Matchers.is((Object)this.ipv61));
    }

    @Test
    public void testMatchIPv6DstMethod() {
        Criterion matchIPv6Dst = Criteria.matchIPv6Dst((IpPrefix)this.ipv61);
        IPCriterion ipCriterion = (IPCriterion)this.checkAndConvert(matchIPv6Dst, Criterion.Type.IPV6_DST, IPCriterion.class);
        MatcherAssert.assertThat((Object)ipCriterion.ip(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ipv61)));
    }

    @Test
    public void testIPCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIp1, this.sameAsMatchIp1}).addEqualityGroup(new Object[]{this.matchIp2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpv61, this.sameAsMatchIpv61}).addEqualityGroup(new Object[]{this.matchIpv62}).testEquals();
    }

    @Test
    public void testMatchTcpSrcMethod() {
        Criterion matchTcpSrc = Criteria.matchTcpSrc((TpPort)this.tpPort1);
        TcpPortCriterion tcpPortCriterion = (TcpPortCriterion)this.checkAndConvert(matchTcpSrc, Criterion.Type.TCP_SRC, TcpPortCriterion.class);
        MatcherAssert.assertThat((Object)tcpPortCriterion.tcpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tpPort1)));
    }

    @Test
    public void testMatchTcpDstMethod() {
        Criterion matchTcpDst = Criteria.matchTcpDst((TpPort)this.tpPort1);
        TcpPortCriterion tcpPortCriterion = (TcpPortCriterion)this.checkAndConvert(matchTcpDst, Criterion.Type.TCP_DST, TcpPortCriterion.class);
        MatcherAssert.assertThat((Object)tcpPortCriterion.tcpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tpPort1)));
    }

    @Test
    public void testTcpPortCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchTcpPort1, this.sameAsMatchTcpPort1}).addEqualityGroup(new Object[]{this.matchTcpPort2}).testEquals();
    }

    @Test
    public void testMatchUdpSrcMethod() {
        Criterion matchUdpSrc = Criteria.matchUdpSrc((TpPort)this.tpPort1);
        UdpPortCriterion udpPortCriterion = (UdpPortCriterion)this.checkAndConvert(matchUdpSrc, Criterion.Type.UDP_SRC, UdpPortCriterion.class);
        MatcherAssert.assertThat((Object)udpPortCriterion.udpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tpPort1)));
    }

    @Test
    public void testMatchUdpDstMethod() {
        Criterion matchUdpDst = Criteria.matchUdpDst((TpPort)this.tpPort1);
        UdpPortCriterion udpPortCriterion = (UdpPortCriterion)this.checkAndConvert(matchUdpDst, Criterion.Type.UDP_DST, UdpPortCriterion.class);
        MatcherAssert.assertThat((Object)udpPortCriterion.udpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tpPort1)));
    }

    @Test
    public void testUdpPortCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchUdpPort1, this.sameAsMatchUdpPort1}).addEqualityGroup(new Object[]{this.matchUdpPort2}).testEquals();
    }

    @Test
    public void testMatchTcpFlagsMethod() {
        Criterion matchTcpFlag = Criteria.matchTcpFlags((int)this.tcpFlags1);
        TcpFlagsCriterion tcpFlagsCriterion = (TcpFlagsCriterion)this.checkAndConvert(matchTcpFlag, Criterion.Type.TCP_FLAGS, TcpFlagsCriterion.class);
        MatcherAssert.assertThat((Object)tcpFlagsCriterion.flags(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tcpFlags1)));
    }

    @Test
    public void testTcpFlagsCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchTcpFlags1, this.sameAsmatchTcpFlags1}).addEqualityGroup(new Object[]{this.matchTcpFlags2}).testEquals();
    }

    @Test
    public void testMatchSctpSrcMethod() {
        Criterion matchSctpSrc = Criteria.matchSctpSrc((TpPort)this.tpPort1);
        SctpPortCriterion sctpPortCriterion = (SctpPortCriterion)this.checkAndConvert(matchSctpSrc, Criterion.Type.SCTP_SRC, SctpPortCriterion.class);
        MatcherAssert.assertThat((Object)sctpPortCriterion.sctpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tpPort1)));
    }

    @Test
    public void testMatchSctpDstMethod() {
        Criterion matchSctpDst = Criteria.matchSctpDst((TpPort)this.tpPort1);
        SctpPortCriterion sctpPortCriterion = (SctpPortCriterion)this.checkAndConvert(matchSctpDst, Criterion.Type.SCTP_DST, SctpPortCriterion.class);
        MatcherAssert.assertThat((Object)sctpPortCriterion.sctpPort(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tpPort1)));
    }

    @Test
    public void testSctpPortCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchSctpPort1, this.sameAsMatchSctpPort1}).addEqualityGroup(new Object[]{this.matchSctpPort2}).testEquals();
    }

    @Test
    public void testMatchIcmpTypeMethod() {
        short icmpType = 12;
        Criterion matchIcmpType = Criteria.matchIcmpType((short)icmpType);
        IcmpTypeCriterion icmpTypeCriterion = (IcmpTypeCriterion)this.checkAndConvert(matchIcmpType, Criterion.Type.ICMPV4_TYPE, IcmpTypeCriterion.class);
        MatcherAssert.assertThat((Object)icmpTypeCriterion.icmpType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)icmpType)));
    }

    @Test
    public void testIcmpTypeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIcmpType1, this.sameAsMatchIcmpType1}).addEqualityGroup(new Object[]{this.matchIcmpType2}).testEquals();
    }

    @Test
    public void testMatchIcmpCodeMethod() {
        short icmpCode = 12;
        Criterion matchIcmpCode = Criteria.matchIcmpCode((short)icmpCode);
        IcmpCodeCriterion icmpCodeCriterion = (IcmpCodeCriterion)this.checkAndConvert(matchIcmpCode, Criterion.Type.ICMPV4_CODE, IcmpCodeCriterion.class);
        MatcherAssert.assertThat((Object)icmpCodeCriterion.icmpCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)icmpCode)));
    }

    @Test
    public void testIcmpCodeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIcmpCode1, this.sameAsMatchIcmpCode1}).addEqualityGroup(new Object[]{this.matchIcmpCode2}).testEquals();
    }

    @Test
    public void testMatchIPv6FlowLabelMethod() {
        int flowLabel = 12;
        Criterion matchFlowLabel = Criteria.matchIPv6FlowLabel((int)flowLabel);
        IPv6FlowLabelCriterion flowLabelCriterion = (IPv6FlowLabelCriterion)this.checkAndConvert(matchFlowLabel, Criterion.Type.IPV6_FLABEL, IPv6FlowLabelCriterion.class);
        MatcherAssert.assertThat((Object)flowLabelCriterion.flowLabel(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)flowLabel)));
    }

    @Test
    public void testIPv6FlowLabelCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchFlowLabel1, this.sameAsMatchFlowLabel1}).addEqualityGroup(new Object[]{this.matchFlowLabel2}).testEquals();
    }

    @Test
    public void testMatchIcmpv6TypeMethod() {
        short icmpv6Type = 12;
        Criterion matchIcmpv6Type = Criteria.matchIcmpv6Type((short)icmpv6Type);
        Icmpv6TypeCriterion icmpv6TypeCriterion = (Icmpv6TypeCriterion)this.checkAndConvert(matchIcmpv6Type, Criterion.Type.ICMPV6_TYPE, Icmpv6TypeCriterion.class);
        MatcherAssert.assertThat((Object)icmpv6TypeCriterion.icmpv6Type(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)icmpv6Type)));
    }

    @Test
    public void testIcmpv6TypeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIcmpv6Type1, this.sameAsMatchIcmpv6Type1}).addEqualityGroup(new Object[]{this.matchIcmpv6Type2}).testEquals();
    }

    @Test
    public void testMatchIcmpv6CodeMethod() {
        short icmpv6Code = 12;
        Criterion matchIcmpv6Code = Criteria.matchIcmpv6Code((short)icmpv6Code);
        Icmpv6CodeCriterion icmpv6CodeCriterion = (Icmpv6CodeCriterion)this.checkAndConvert(matchIcmpv6Code, Criterion.Type.ICMPV6_CODE, Icmpv6CodeCriterion.class);
        MatcherAssert.assertThat((Object)icmpv6CodeCriterion.icmpv6Code(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)icmpv6Code)));
    }

    @Test
    public void testIcmpv6CodeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIcmpv6Code1, this.sameAsMatchIcmpv6Code1}).addEqualityGroup(new Object[]{this.matchIcmpv6Code2}).testEquals();
    }

    @Test
    public void testMatchIPv6NDTargetAddressMethod() {
        Criterion matchTargetAddress = Criteria.matchIPv6NDTargetAddress((Ip6Address)this.ip6TargetAddress1);
        IPv6NDTargetAddressCriterion targetAddressCriterion = (IPv6NDTargetAddressCriterion)this.checkAndConvert(matchTargetAddress, Criterion.Type.IPV6_ND_TARGET, IPv6NDTargetAddressCriterion.class);
        MatcherAssert.assertThat((Object)targetAddressCriterion.targetAddress(), (Matcher)Matchers.is((Object)this.ip6TargetAddress1));
    }

    @Test
    public void testIPv6NDTargetAddressCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpv6TargetAddr1, this.sameAsMatchIpv6TargetAddr1}).addEqualityGroup(new Object[]{this.matchIpv6TargetAddr2}).testEquals();
    }

    @Test
    public void testMatchIPv6NDSourceLinkLayerAddressMethod() {
        Criterion matchSrcLlAddr = Criteria.matchIPv6NDSourceLinkLayerAddress((MacAddress)this.llMac1);
        IPv6NDLinkLayerAddressCriterion srcLlCriterion = (IPv6NDLinkLayerAddressCriterion)this.checkAndConvert(matchSrcLlAddr, Criterion.Type.IPV6_ND_SLL, IPv6NDLinkLayerAddressCriterion.class);
        MatcherAssert.assertThat((Object)srcLlCriterion.mac(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.llMac1)));
    }

    @Test
    public void testMatchIPv6NDTargetLinkLayerAddressMethod() {
        Criterion matchTargetLlAddr = Criteria.matchIPv6NDTargetLinkLayerAddress((MacAddress)this.llMac1);
        IPv6NDLinkLayerAddressCriterion targetLlCriterion = (IPv6NDLinkLayerAddressCriterion)this.checkAndConvert(matchTargetLlAddr, Criterion.Type.IPV6_ND_TLL, IPv6NDLinkLayerAddressCriterion.class);
        MatcherAssert.assertThat((Object)targetLlCriterion.mac(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.llMac1)));
    }

    @Test
    public void testIPv6NDLinkLayerAddressCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchSrcLlAddr1, this.sameAsMatchSrcLlAddr1}).addEqualityGroup(new Object[]{this.matchSrcLlAddr2}).testEquals();
        new EqualsTester().addEqualityGroup(new Object[]{this.matchTargetLlAddr1, this.sameAsMatchTargetLlAddr1}).addEqualityGroup(new Object[]{this.matchTargetLlAddr2}).testEquals();
    }

    @Test
    public void testMatchMplsLabelMethod() {
        Criterion matchMplsLabel = Criteria.matchMplsLabel((MplsLabel)this.mpls1);
        MplsCriterion mplsCriterion = (MplsCriterion)this.checkAndConvert(matchMplsLabel, Criterion.Type.MPLS_LABEL, MplsCriterion.class);
        MatcherAssert.assertThat((Object)mplsCriterion.label(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.mpls1)));
    }

    @Test
    public void testMplsCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchMpls1, this.sameAsMatchMpls1}).addEqualityGroup(new Object[]{this.matchMpls2}).testEquals();
    }

    @Test
    public void testMatchMplsTcMethod() {
        Criterion matchMplsTc = Criteria.matchMplsTc((byte)this.mplsTc1);
        MplsTcCriterion mplsTcCriterion = (MplsTcCriterion)this.checkAndConvert(matchMplsTc, Criterion.Type.MPLS_TC, MplsTcCriterion.class);
        MatcherAssert.assertThat((Object)mplsTcCriterion.tc(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.mplsTc1)));
    }

    @Test
    public void testMplsTcCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchMplsTc1, this.sameAsMatchMplsTc1}).addEqualityGroup(new Object[]{this.matchMplsTc2}).testEquals();
    }

    @Test
    public void testMatchTunnelIdMethod() {
        Criterion matchTunnelId = Criteria.matchTunnelId((long)this.tunnelId1);
        TunnelIdCriterion tunnelIdCriterion = (TunnelIdCriterion)this.checkAndConvert(matchTunnelId, Criterion.Type.TUNNEL_ID, TunnelIdCriterion.class);
        MatcherAssert.assertThat((Object)tunnelIdCriterion.tunnelId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tunnelId1)));
    }

    @Test
    public void testTunnelIdCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchTunnelId1, this.sameAsMatchTunnelId1}).addEqualityGroup(new Object[]{this.matchTunnelId2}).testEquals();
    }

    @Test
    public void testMatchIPv6ExthdrFlagsMethod() {
        Criterion matchExthdrFlags = Criteria.matchIPv6ExthdrFlags((int)this.ipv6ExthdrFlags1);
        IPv6ExthdrFlagsCriterion exthdrFlagsCriterion = (IPv6ExthdrFlagsCriterion)this.checkAndConvert(matchExthdrFlags, Criterion.Type.IPV6_EXTHDR, IPv6ExthdrFlagsCriterion.class);
        MatcherAssert.assertThat((Object)exthdrFlagsCriterion.exthdrFlags(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ipv6ExthdrFlags1)));
    }

    @Test
    public void testIPv6ExthdrFlagsCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchIpv6ExthdrFlags1, this.sameAsMatchIpv6ExthdrFlags1}).addEqualityGroup(new Object[]{this.matchIpv6ExthdrFlags2}).testEquals();
    }

    @Test
    public void testOchSignalCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchOchSignal1, this.sameAsMatchOchSignal1}).addEqualityGroup(new Object[]{this.matchOchSignal2}).testEquals();
    }

    @Test
    public void testOchSignalTypeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchOchSignalType1, this.sameAsMatchOchSignalType1}).addEqualityGroup(new Object[]{this.matchOchSignalType2}).testEquals();
    }

    @Test
    public void testMatchOduSignalIdMethod() {
        OduSignalId odu = OduSignalId.oduSignalId((int)1, (int)80, (byte[])new byte[]{2, 1, 1, 3, 1, 1, 3, 1, 1, 3});
        Criterion matchoduSignalId = Criteria.matchOduSignalId((OduSignalId)odu);
        OduSignalIdCriterion oduSignalIdCriterion = (OduSignalIdCriterion)this.checkAndConvert(matchoduSignalId, Criterion.Type.ODU_SIGID, OduSignalIdCriterion.class);
        MatcherAssert.assertThat((Object)oduSignalIdCriterion.oduSignalId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)odu)));
    }

    @Test
    public void testOduSignalIdCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchOduSignalId1, this.sameAsMatchOduSignalId1}).addEqualityGroup(new Object[]{this.matchOduSignalId2}).testEquals();
    }

    @Test
    public void testMatchOduSignalTypeMethod() {
        OduSignalType oduSigType = OduSignalType.ODU2;
        Criterion matchoduSignalType = Criteria.matchOduSignalType((OduSignalType)oduSigType);
        OduSignalTypeCriterion oduSignalTypeCriterion = (OduSignalTypeCriterion)this.checkAndConvert(matchoduSignalType, Criterion.Type.ODU_SIGTYPE, OduSignalTypeCriterion.class);
        MatcherAssert.assertThat((Object)oduSignalTypeCriterion.signalType(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)oduSigType)));
    }

    @Test
    public void testOduSignalTypeCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchOduSignalType1, this.sameAsMatchOduSignalType1}).addEqualityGroup(new Object[]{this.matchOduSignalType2}).testEquals();
    }

    @Test
    public void testMatchPbbIsidMethod() {
        Criterion matchPbbIsid = Criteria.matchPbbIsid((int)this.pbbIsid1);
        PbbIsidCriterion pbbIsidCriterion = (PbbIsidCriterion)this.checkAndConvert(matchPbbIsid, Criterion.Type.PBB_ISID, PbbIsidCriterion.class);
        MatcherAssert.assertThat((Object)pbbIsidCriterion.pbbIsid(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.pbbIsid1)));
    }

    @Test
    public void testPbbIsidCriterionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.matchPbbIsid1, this.sameAsMatchPbbIsid1}).addEqualityGroup(new Object[]{this.matchPbbIsid2}).testEquals();
    }
}

