/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow.instructions;

import com.google.common.testing.EqualsTester;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onlab.junit.UtilityClassChecker;
import org.onlab.packet.EthType;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.core.GroupId;
import org.onosproject.net.ChannelSpacing;
import org.onosproject.net.DeviceId;
import org.onosproject.net.GridType;
import org.onosproject.net.Lambda;
import org.onosproject.net.OduSignalId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.instructions.ExtensionPropertyException;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatmentType;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.flow.instructions.L0ModificationInstruction;
import org.onosproject.net.flow.instructions.L1ModificationInstruction;
import org.onosproject.net.flow.instructions.L2ModificationInstruction;
import org.onosproject.net.flow.instructions.L3ModificationInstruction;
import org.onosproject.net.flow.instructions.L4ModificationInstruction;
import org.onosproject.net.meter.MeterId;

public class InstructionsTest {
    private final Instructions.NoActionInstruction noAction1 = Instructions.createNoAction();
    private final Instructions.NoActionInstruction noAction2 = Instructions.createNoAction();
    private final PortNumber port1 = PortNumber.portNumber((long)1L);
    private final PortNumber port2 = PortNumber.portNumber((long)2L);
    private final Instructions.OutputInstruction output1 = Instructions.createOutput((PortNumber)this.port1);
    private final Instructions.OutputInstruction sameAsOutput1 = Instructions.createOutput((PortNumber)this.port1);
    private final Instructions.OutputInstruction output2 = Instructions.createOutput((PortNumber)this.port2);
    private final Lambda och1 = Lambda.ochSignal((GridType)GridType.DWDM, (ChannelSpacing)ChannelSpacing.CHL_100GHZ, (int)4, (int)8);
    private final Lambda och2 = Lambda.ochSignal((GridType)GridType.CWDM, (ChannelSpacing)ChannelSpacing.CHL_100GHZ, (int)4, (int)8);
    private final Instruction ochInstruction1 = Instructions.modL0Lambda((Lambda)this.och1);
    private final Instruction sameAsOchInstruction1 = Instructions.modL0Lambda((Lambda)this.och1);
    private final Instruction ochInstruction2 = Instructions.modL0Lambda((Lambda)this.och2);
    private final OduSignalId odu1 = OduSignalId.oduSignalId((int)1, (int)80, (byte[])new byte[]{8, 7, 6, 5, 7, 6, 5, 7, 6, 5});
    private final OduSignalId odu2 = OduSignalId.oduSignalId((int)2, (int)80, (byte[])new byte[]{1, 1, 2, 2, 1, 2, 2, 1, 2, 2});
    private final Instruction oduInstruction1 = Instructions.modL1OduSignalId((OduSignalId)this.odu1);
    private final Instruction sameAsOduInstruction1 = Instructions.modL1OduSignalId((OduSignalId)this.odu1);
    private final Instruction oduInstruction2 = Instructions.modL1OduSignalId((OduSignalId)this.odu2);
    private static final String MAC1 = "00:00:00:00:00:01";
    private static final String MAC2 = "00:00:00:00:00:02";
    private final MacAddress mac1 = MacAddress.valueOf((String)"00:00:00:00:00:01");
    private final MacAddress mac2 = MacAddress.valueOf((String)"00:00:00:00:00:02");
    private final Instruction modEtherInstruction1 = Instructions.modL2Src((MacAddress)this.mac1);
    private final Instruction sameAsModEtherInstruction1 = Instructions.modL2Src((MacAddress)this.mac1);
    private final Instruction modEtherInstruction2 = Instructions.modL2Src((MacAddress)this.mac2);
    private final short vlan1 = 1;
    private final short vlan2 = (short)2;
    private final VlanId vlanId1 = VlanId.vlanId((short)1);
    private final VlanId vlanId2 = VlanId.vlanId((short)2);
    private final Instruction modVlanId1 = Instructions.modVlanId((VlanId)this.vlanId1);
    private final Instruction sameAsModVlanId1 = Instructions.modVlanId((VlanId)this.vlanId1);
    private final Instruction modVlanId2 = Instructions.modVlanId((VlanId)this.vlanId2);
    private final byte vlanPcp1 = 1;
    private final byte vlanPcp2 = (byte)2;
    private final Instruction modVlanPcp1 = Instructions.modVlanPcp((Byte)1);
    private final Instruction sameAsModVlanPcp1 = Instructions.modVlanPcp((Byte)1);
    private final Instruction modVlanPcp2 = Instructions.modVlanPcp((Byte)2);
    private static final String IP41 = "1.2.3.4";
    private static final String IP42 = "5.6.7.8";
    private IpAddress ip41 = IpAddress.valueOf((String)"1.2.3.4");
    private IpAddress ip42 = IpAddress.valueOf((String)"5.6.7.8");
    private final Instruction modIPInstruction1 = Instructions.modL3Src((IpAddress)this.ip41);
    private final Instruction sameAsModIPInstruction1 = Instructions.modL3Src((IpAddress)this.ip41);
    private final Instruction modIPInstruction2 = Instructions.modL3Src((IpAddress)this.ip42);
    private static final String IP61 = "1111::2222";
    private static final String IP62 = "3333::4444";
    private IpAddress ip61 = IpAddress.valueOf((String)"1111::2222");
    private IpAddress ip62 = IpAddress.valueOf((String)"3333::4444");
    private final Instruction modIPv6Instruction1 = Instructions.modL3IPv6Src((IpAddress)this.ip61);
    private final Instruction sameAsModIPv6Instruction1 = Instructions.modL3IPv6Src((IpAddress)this.ip61);
    private final Instruction modIPv6Instruction2 = Instructions.modL3IPv6Src((IpAddress)this.ip62);
    private final int flowLabel1 = 69905;
    private final int flowLabel2 = 139810;
    private final Instruction modIPv6FlowLabelInstruction1 = Instructions.modL3IPv6FlowLabel((int)69905);
    private final Instruction sameAsModIPv6FlowLabelInstruction1 = Instructions.modL3IPv6FlowLabel((int)69905);
    private final Instruction modIPv6FlowLabelInstruction2 = Instructions.modL3IPv6FlowLabel((int)139810);
    private Instruction modMplsLabelInstruction1 = Instructions.modMplsLabel((MplsLabel)MplsLabel.mplsLabel((int)1));
    private Instruction sameAsModMplsLabelInstruction1 = Instructions.modMplsLabel((MplsLabel)MplsLabel.mplsLabel((int)1));
    private Instruction modMplsLabelInstruction2 = Instructions.modMplsLabel((MplsLabel)MplsLabel.mplsLabel((int)2));
    private final long tunnelId1 = 1L;
    private final long tunnelId2 = 2L;
    private final Instruction modTunnelId1 = Instructions.modTunnelId((long)1L);
    private final Instruction sameAsModTunnelId1 = Instructions.modTunnelId((long)1L);
    private final Instruction modTunnelId2 = Instructions.modTunnelId((long)2L);
    private final TpPort tpPort1 = TpPort.tpPort((int)1);
    private final TpPort tpPort2 = TpPort.tpPort((int)2);
    private final Instruction modTransportPortInstruction1 = Instructions.modTcpSrc((TpPort)this.tpPort1);
    private final Instruction sameAsModTransportPortInstruction1 = Instructions.modTcpSrc((TpPort)this.tpPort1);
    private final Instruction modTransportPortInstruction2 = Instructions.modTcpSrc((TpPort)this.tpPort2);
    private final GroupId groupId1 = new GroupId(1);
    private final GroupId groupId2 = new GroupId(2);
    private final Instruction groupInstruction1 = Instructions.createGroup((GroupId)this.groupId1);
    private final Instruction sameAsGroupInstruction1 = Instructions.createGroup((GroupId)this.groupId1);
    private final Instruction groupInstruction2 = Instructions.createGroup((GroupId)this.groupId2);
    private final Instruction setQueueInstruction1 = Instructions.setQueue((long)1L, (PortNumber)this.port1);
    private final Instruction sameAsSetQueueInstruction1 = Instructions.setQueue((long)1L, (PortNumber)this.port1);
    private final Instruction setQueueInstruction2 = Instructions.setQueue((long)1L, (PortNumber)this.port2);
    MeterId meterId1 = MeterId.meterId((long)1L);
    MeterId meterId2 = MeterId.meterId((long)2L);
    private final Instruction meterInstruction1 = Instructions.meterTraffic((MeterId)this.meterId1);
    private final Instruction sameAsMeterInstruction1 = Instructions.meterTraffic((MeterId)this.meterId1);
    private final Instruction meterInstruction2 = Instructions.meterTraffic((MeterId)this.meterId2);
    private final Instruction transitionInstruction1 = Instructions.transition((Integer)1);
    private final Instruction sameAsTransitionInstruction1 = Instructions.transition((Integer)1);
    private final Instruction transitionInstruction2 = Instructions.transition((Integer)2);
    long metadata1 = 111L;
    long metadataMask1 = 222L;
    long metadata2 = 333L;
    long metadataMask2 = 444L;
    private final Instruction metadataInstruction1 = Instructions.writeMetadata((long)this.metadata1, (long)this.metadataMask1);
    private final Instruction sameAsMetadataInstruction1 = Instructions.writeMetadata((long)this.metadata1, (long)this.metadataMask1);
    private final Instruction metadataInstruction2 = Instructions.writeMetadata((long)this.metadata2, (long)this.metadataMask2);
    ExtensionTreatment extensionTreatment1 = new MockExtensionTreatment(111);
    ExtensionTreatment extensionTreatment2 = new MockExtensionTreatment(222);
    DeviceId deviceId1 = DeviceId.deviceId((String)"of:1");
    DeviceId deviceId2 = DeviceId.deviceId((String)"of:2");
    private final Instruction extensionInstruction1 = Instructions.extension((ExtensionTreatment)this.extensionTreatment1, (DeviceId)this.deviceId1);
    private final Instruction sameAsExtensionInstruction1 = Instructions.extension((ExtensionTreatment)this.extensionTreatment1, (DeviceId)this.deviceId1);
    private final Instruction extensionInstruction2 = Instructions.extension((ExtensionTreatment)this.extensionTreatment2, (DeviceId)this.deviceId2);
    private final EthType ethType1 = new EthType(1);
    private final EthType ethType2 = new EthType(2);
    private final Instruction modMplsHeaderInstruction1 = Instructions.popMpls((EthType)this.ethType1);
    private final Instruction sameAsModMplsHeaderInstruction1 = Instructions.popMpls((EthType)this.ethType1);
    private final Instruction modMplsHeaderInstruction2 = Instructions.popMpls((EthType)this.ethType2);
    private final Instruction modMplsTtlInstruction1 = Instructions.decMplsTtl();
    private final Instruction sameAsModMplsTtlInstruction1 = Instructions.decMplsTtl();
    private final Instruction modMplsBosInstruction1 = Instructions.modMplsBos((boolean)true);
    private final Instruction sameAsModMplsBosInstruction1 = Instructions.modMplsBos((boolean)true);
    private final Instruction modMplsBosInstruction2 = Instructions.modMplsBos((boolean)false);
    private final Instruction modVlanHeaderInstruction1 = Instructions.popVlan();
    private final Instruction sameAsModVlanHeaderInstruction1 = Instructions.popVlan();
    private final Instruction modArpIPInstruction1 = Instructions.modArpSpa((IpAddress)this.ip41);
    private final Instruction sameAsModArpIPInstruction1 = Instructions.modArpSpa((IpAddress)this.ip41);
    private final Instruction modArpIPInstruction2 = Instructions.modArpSpa((IpAddress)this.ip42);
    private final Instruction modArpEthInstruction1 = Instructions.modArpSha((MacAddress)this.mac1);
    private final Instruction sameAsModArpEthInstruction1 = Instructions.modArpSha((MacAddress)this.mac1);
    private final Instruction modArpEthInstruction2 = Instructions.modArpSha((MacAddress)this.mac2);
    private final Instruction modArpOpInstruction1 = Instructions.modL3ArpOp((short)1);
    private final Instruction sameAsModArpOpInstruction1 = Instructions.modL3ArpOp((short)1);
    private final Instruction modArpOpInstruction2 = Instructions.modL3ArpOp((short)2);
    private final Instruction modArpTtlInstruction1 = Instructions.copyTtlIn();
    private final Instruction sameAsModArpTtlInstruction1 = Instructions.copyTtlIn();
    private final Instruction modArpTtlInstruction2 = Instructions.copyTtlOut();
    private final Instruction modArpTtlInstruction3 = Instructions.decNwTtl();

    private <T> T checkAndConvert(Instruction instruction, Instruction.Type type, Class clazz) {
        MatcherAssert.assertThat((Object)instruction, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)instruction.type(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)type)));
        MatcherAssert.assertThat((Object)instruction, (Matcher)Matchers.instanceOf((Class)clazz));
        return (T)instruction;
    }

    private <T extends Instruction> void checkEqualsAndToString(T c1, T c1match, T c2) {
        new EqualsTester().addEqualityGroup(new Object[]{c1, c1match}).addEqualityGroup(new Object[]{c2}).testEquals();
    }

    @Test
    public void testInstructionsUtilityClass() {
        UtilityClassChecker.assertThatClassIsUtility(Instructions.class);
    }

    @Test
    public void testImmutabilityOfInstructions() {
        ImmutableClassChecker.assertThatClassIsImmutable(Instructions.OutputInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L0ModificationInstruction.ModOchSignalInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L1ModificationInstruction.ModOduSignalIdInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L2ModificationInstruction.ModEtherInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L2ModificationInstruction.ModVlanIdInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L2ModificationInstruction.ModVlanPcpInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L3ModificationInstruction.ModIPInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L3ModificationInstruction.ModIPv6FlowLabelInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L2ModificationInstruction.ModMplsLabelInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L2ModificationInstruction.ModMplsHeaderInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L2ModificationInstruction.ModMplsBosInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L2ModificationInstruction.ModMplsTtlInstruction.class);
        ImmutableClassChecker.assertThatClassIsImmutable(L2ModificationInstruction.ModTunnelIdInstruction.class);
    }

    @Test
    public void testCreateNoActionMethod() {
        Instructions.NoActionInstruction instruction = Instructions.createNoAction();
        this.checkAndConvert((Instruction)instruction, Instruction.Type.NOACTION, Instructions.NoActionInstruction.class);
    }

    @Test
    public void testNoActionInstructionEquals() throws Exception {
        new EqualsTester().addEqualityGroup(new Object[]{this.noAction1, this.noAction2}).testEquals();
    }

    @Test
    public void testNoActionInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.noAction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.noAction2.hashCode())));
    }

    @Test
    public void testCreateOutputMethod() {
        Instructions.OutputInstruction instruction = Instructions.createOutput((PortNumber)this.port2);
        Instructions.OutputInstruction outputInstruction = (Instructions.OutputInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.OUTPUT, Instructions.OutputInstruction.class);
        MatcherAssert.assertThat((Object)outputInstruction.port(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.port2)));
    }

    @Test
    public void testOutputInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.output1, this.sameAsOutput1, this.output2);
    }

    @Test
    public void testOutputInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.output1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsOutput1.hashCode())));
        MatcherAssert.assertThat((Object)this.output1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.output2.hashCode()))));
    }

    @Test
    public void testModL0LambdaMethod() {
        L0ModificationInstruction instruction = Instructions.modL0Lambda((Lambda)this.och1);
        L0ModificationInstruction.ModOchSignalInstruction ochInstruction = (L0ModificationInstruction.ModOchSignalInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L0MODIFICATION, L0ModificationInstruction.ModOchSignalInstruction.class);
        MatcherAssert.assertThat((Object)ochInstruction.lambda(), (Matcher)Matchers.is((Object)this.och1));
    }

    @Test
    public void testModOchSignalInstructionEquals() {
        this.checkEqualsAndToString(this.ochInstruction1, this.sameAsOchInstruction1, this.ochInstruction2);
    }

    @Test
    public void testModOchSignalInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.ochInstruction1.hashCode(), (Matcher)Matchers.is((Object)this.sameAsOchInstruction1.hashCode()));
        MatcherAssert.assertThat((Object)this.ochInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)this.ochInstruction2.hashCode())));
    }

    @Test
    public void testModL1OduSignalIdMethod() {
        L1ModificationInstruction instruction = Instructions.modL1OduSignalId((OduSignalId)this.odu1);
        L1ModificationInstruction.ModOduSignalIdInstruction oduInstruction = (L1ModificationInstruction.ModOduSignalIdInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L1MODIFICATION, L1ModificationInstruction.ModOduSignalIdInstruction.class);
        MatcherAssert.assertThat((Object)oduInstruction.oduSignalId(), (Matcher)Matchers.is((Object)this.odu1));
    }

    @Test
    public void testModOduSignalIdInstructionEquals() {
        this.checkEqualsAndToString(this.oduInstruction1, this.sameAsOduInstruction1, this.oduInstruction2);
    }

    @Test
    public void testModOduSignalIdInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.oduInstruction1.hashCode(), (Matcher)Matchers.is((Object)this.sameAsOduInstruction1.hashCode()));
        MatcherAssert.assertThat((Object)this.oduInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Object)this.oduInstruction2.hashCode())));
    }

    @Test
    public void testModL2SrcMethod() {
        L2ModificationInstruction instruction = Instructions.modL2Src((MacAddress)this.mac1);
        L2ModificationInstruction.ModEtherInstruction modEtherInstruction = (L2ModificationInstruction.ModEtherInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModEtherInstruction.class);
        MatcherAssert.assertThat((Object)modEtherInstruction.mac(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.mac1)));
        MatcherAssert.assertThat((Object)modEtherInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L2ModificationInstruction.L2SubType.ETH_SRC)));
    }

    @Test
    public void testModL2DstMethod() {
        L2ModificationInstruction instruction = Instructions.modL2Dst((MacAddress)this.mac1);
        L2ModificationInstruction.ModEtherInstruction modEtherInstruction = (L2ModificationInstruction.ModEtherInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModEtherInstruction.class);
        MatcherAssert.assertThat((Object)modEtherInstruction.mac(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.mac1)));
        MatcherAssert.assertThat((Object)modEtherInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L2ModificationInstruction.L2SubType.ETH_DST)));
    }

    @Test
    public void testModEtherInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modEtherInstruction1, this.sameAsModEtherInstruction1, this.modEtherInstruction2);
    }

    @Test
    public void testModEtherInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.modEtherInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsModEtherInstruction1.hashCode())));
        MatcherAssert.assertThat((Object)this.modEtherInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.modEtherInstruction2.hashCode()))));
    }

    @Test
    public void testModVlanIdMethod() {
        L2ModificationInstruction instruction = Instructions.modVlanId((VlanId)this.vlanId1);
        L2ModificationInstruction.ModVlanIdInstruction modEtherInstruction = (L2ModificationInstruction.ModVlanIdInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModVlanIdInstruction.class);
        MatcherAssert.assertThat((Object)modEtherInstruction.vlanId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.vlanId1)));
        MatcherAssert.assertThat((Object)modEtherInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L2ModificationInstruction.L2SubType.VLAN_ID)));
    }

    @Test
    public void testModVlanIdInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modVlanId1, this.sameAsModVlanId1, this.modVlanId2);
    }

    @Test
    public void testModVlanIdInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.modVlanId1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsModVlanId1.hashCode())));
        MatcherAssert.assertThat((Object)this.modVlanId1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.modVlanId2.hashCode()))));
    }

    @Test
    public void testModVlanPcpMethod() {
        L2ModificationInstruction instruction = Instructions.modVlanPcp((Byte)1);
        L2ModificationInstruction.ModVlanPcpInstruction modEtherInstruction = (L2ModificationInstruction.ModVlanPcpInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModVlanPcpInstruction.class);
        MatcherAssert.assertThat((Object)modEtherInstruction.vlanPcp(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1)));
        MatcherAssert.assertThat((Object)modEtherInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L2ModificationInstruction.L2SubType.VLAN_PCP)));
    }

    @Test
    public void testModVlanPcpInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modVlanPcp1, this.sameAsModVlanPcp1, this.modVlanPcp2);
    }

    @Test
    public void testModVlanPcpInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.modVlanPcp1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsModVlanPcp1.hashCode())));
        MatcherAssert.assertThat((Object)this.modVlanPcp1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.modVlanPcp2.hashCode()))));
    }

    @Test
    public void testModL3SrcMethod() {
        L3ModificationInstruction instruction = Instructions.modL3Src((IpAddress)this.ip41);
        L3ModificationInstruction.ModIPInstruction modIPInstruction = (L3ModificationInstruction.ModIPInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModIPInstruction.class);
        MatcherAssert.assertThat((Object)modIPInstruction.ip(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ip41)));
        MatcherAssert.assertThat((Object)modIPInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L3ModificationInstruction.L3SubType.IPV4_SRC)));
    }

    @Test
    public void testModL3DstMethod() {
        L3ModificationInstruction instruction = Instructions.modL3Dst((IpAddress)this.ip41);
        L3ModificationInstruction.ModIPInstruction modIPInstruction = (L3ModificationInstruction.ModIPInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModIPInstruction.class);
        MatcherAssert.assertThat((Object)modIPInstruction.ip(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ip41)));
        MatcherAssert.assertThat((Object)modIPInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L3ModificationInstruction.L3SubType.IPV4_DST)));
    }

    @Test
    public void testModL3IPv6SrcMethod() {
        L3ModificationInstruction instruction = Instructions.modL3IPv6Src((IpAddress)this.ip61);
        L3ModificationInstruction.ModIPInstruction modIPInstruction = (L3ModificationInstruction.ModIPInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModIPInstruction.class);
        MatcherAssert.assertThat((Object)modIPInstruction.ip(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ip61)));
        MatcherAssert.assertThat((Object)modIPInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L3ModificationInstruction.L3SubType.IPV6_SRC)));
    }

    @Test
    public void testModL3IPv6DstMethod() {
        L3ModificationInstruction instruction = Instructions.modL3IPv6Dst((IpAddress)this.ip61);
        L3ModificationInstruction.ModIPInstruction modIPInstruction = (L3ModificationInstruction.ModIPInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModIPInstruction.class);
        MatcherAssert.assertThat((Object)modIPInstruction.ip(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.ip61)));
        MatcherAssert.assertThat((Object)modIPInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L3ModificationInstruction.L3SubType.IPV6_DST)));
    }

    @Test
    public void testModIPInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modIPInstruction1, this.sameAsModIPInstruction1, this.modIPInstruction2);
    }

    @Test
    public void testModIPInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.modIPInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsModIPInstruction1.hashCode())));
        MatcherAssert.assertThat((Object)this.modIPInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.modIPInstruction2.hashCode()))));
    }

    @Test
    public void testModL3IPv6FlowLabelMethod() {
        L3ModificationInstruction instruction = Instructions.modL3IPv6FlowLabel((int)69905);
        L3ModificationInstruction.ModIPv6FlowLabelInstruction modIPv6FlowLabelInstruction = (L3ModificationInstruction.ModIPv6FlowLabelInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModIPv6FlowLabelInstruction.class);
        MatcherAssert.assertThat((Object)modIPv6FlowLabelInstruction.flowLabel(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)69905)));
        MatcherAssert.assertThat((Object)modIPv6FlowLabelInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L3ModificationInstruction.L3SubType.IPV6_FLABEL)));
    }

    @Test
    public void testModIPv6FlowLabelInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modIPv6FlowLabelInstruction1, this.sameAsModIPv6FlowLabelInstruction1, this.modIPv6FlowLabelInstruction2);
    }

    @Test
    public void testModIPv6FlowLabelInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.modIPv6FlowLabelInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsModIPv6FlowLabelInstruction1.hashCode())));
        MatcherAssert.assertThat((Object)this.modIPv6FlowLabelInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.modIPv6FlowLabelInstruction2.hashCode()))));
    }

    @Test
    public void testModMplsMethod() {
        MplsLabel mplsLabel = MplsLabel.mplsLabel((int)33);
        L2ModificationInstruction instruction = Instructions.modMplsLabel((MplsLabel)mplsLabel);
        L2ModificationInstruction.ModMplsLabelInstruction modMplsLabelInstruction = (L2ModificationInstruction.ModMplsLabelInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModMplsLabelInstruction.class);
        MatcherAssert.assertThat((Object)modMplsLabelInstruction.label(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)mplsLabel)));
        MatcherAssert.assertThat((Object)modMplsLabelInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L2ModificationInstruction.L2SubType.MPLS_LABEL)));
    }

    @Test
    public void testModMplsLabelInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modMplsLabelInstruction1, this.sameAsModMplsLabelInstruction1, this.modMplsLabelInstruction2);
    }

    @Test
    public void testModTunnelIdMethod() {
        L2ModificationInstruction instruction = Instructions.modTunnelId((long)1L);
        L2ModificationInstruction.ModTunnelIdInstruction modTunnelIdInstruction = (L2ModificationInstruction.ModTunnelIdInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModTunnelIdInstruction.class);
        MatcherAssert.assertThat((Object)modTunnelIdInstruction.tunnelId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)1L)));
        MatcherAssert.assertThat((Object)modTunnelIdInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L2ModificationInstruction.L2SubType.TUNNEL_ID)));
    }

    @Test
    public void testModTunnelIdInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modTunnelId1, this.sameAsModTunnelId1, this.modTunnelId2);
    }

    @Test
    public void testModTunnelIdInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.modTunnelId1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsModTunnelId1.hashCode())));
        MatcherAssert.assertThat((Object)this.modTunnelId1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.modTunnelId2.hashCode()))));
    }

    @Test
    public void testModTcpSrcMethod() {
        L4ModificationInstruction instruction = Instructions.modTcpSrc((TpPort)this.tpPort1);
        L4ModificationInstruction.ModTransportPortInstruction modTransportPortInstruction = (L4ModificationInstruction.ModTransportPortInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L4MODIFICATION, L4ModificationInstruction.ModTransportPortInstruction.class);
        MatcherAssert.assertThat((Object)modTransportPortInstruction.port(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tpPort1)));
        MatcherAssert.assertThat((Object)modTransportPortInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L4ModificationInstruction.L4SubType.TCP_SRC)));
    }

    @Test
    public void testModTcpDstMethod() {
        L4ModificationInstruction instruction = Instructions.modTcpDst((TpPort)this.tpPort1);
        L4ModificationInstruction.ModTransportPortInstruction modTransportPortInstruction = (L4ModificationInstruction.ModTransportPortInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L4MODIFICATION, L4ModificationInstruction.ModTransportPortInstruction.class);
        MatcherAssert.assertThat((Object)modTransportPortInstruction.port(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tpPort1)));
        MatcherAssert.assertThat((Object)modTransportPortInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L4ModificationInstruction.L4SubType.TCP_DST)));
    }

    @Test
    public void testModUdpSrcMethod() {
        L4ModificationInstruction instruction = Instructions.modUdpSrc((TpPort)this.tpPort1);
        L4ModificationInstruction.ModTransportPortInstruction modTransportPortInstruction = (L4ModificationInstruction.ModTransportPortInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L4MODIFICATION, L4ModificationInstruction.ModTransportPortInstruction.class);
        MatcherAssert.assertThat((Object)modTransportPortInstruction.port(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tpPort1)));
        MatcherAssert.assertThat((Object)modTransportPortInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L4ModificationInstruction.L4SubType.UDP_SRC)));
    }

    @Test
    public void testModUdpDstMethod() {
        L4ModificationInstruction instruction = Instructions.modUdpDst((TpPort)this.tpPort1);
        L4ModificationInstruction.ModTransportPortInstruction modTransportPortInstruction = (L4ModificationInstruction.ModTransportPortInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L4MODIFICATION, L4ModificationInstruction.ModTransportPortInstruction.class);
        MatcherAssert.assertThat((Object)modTransportPortInstruction.port(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.tpPort1)));
        MatcherAssert.assertThat((Object)modTransportPortInstruction.subtype(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)L4ModificationInstruction.L4SubType.UDP_DST)));
    }

    @Test
    public void testModTransportPortInstructionEquals() throws Exception {
        this.checkEqualsAndToString(this.modTransportPortInstruction1, this.sameAsModTransportPortInstruction1, this.modTransportPortInstruction2);
    }

    @Test
    public void testModTransportPortInstructionHashCode() {
        MatcherAssert.assertThat((Object)this.modTransportPortInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.sameAsModTransportPortInstruction1.hashCode())));
        MatcherAssert.assertThat((Object)this.modTransportPortInstruction1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.modTransportPortInstruction2.hashCode()))));
    }

    @Test
    public void testCreateGroupMethod() {
        Instructions.GroupInstruction instruction = Instructions.createGroup((GroupId)this.groupId1);
        Instructions.GroupInstruction groupInstruction = (Instructions.GroupInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.GROUP, Instructions.GroupInstruction.class);
        MatcherAssert.assertThat((Object)groupInstruction.groupId(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)this.groupId1)));
    }

    @Test
    public void testGroupInstructionEquals() {
        this.checkEqualsAndToString(this.groupInstruction1, this.sameAsGroupInstruction1, this.groupInstruction2);
    }

    @Test
    public void testSetQueueMethod() {
        Instructions.SetQueueInstruction instruction = Instructions.setQueue((long)2L, (PortNumber)this.port2);
        Instructions.SetQueueInstruction setQueueInstruction = (Instructions.SetQueueInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.QUEUE, Instructions.SetQueueInstruction.class);
        MatcherAssert.assertThat((Object)setQueueInstruction.queueId(), (Matcher)Matchers.is((Object)2L));
        MatcherAssert.assertThat((Object)setQueueInstruction.port(), (Matcher)Matchers.is((Object)this.port2));
    }

    @Test
    public void testSetQueueInstructionEquals() {
        this.checkEqualsAndToString(this.setQueueInstruction1, this.sameAsSetQueueInstruction1, this.setQueueInstruction2);
    }

    @Test
    public void testMeterTrafficMethod() {
        Instructions.MeterInstruction instruction = Instructions.meterTraffic((MeterId)this.meterId1);
        Instructions.MeterInstruction meterInstruction = (Instructions.MeterInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.METER, Instructions.MeterInstruction.class);
        MatcherAssert.assertThat((Object)meterInstruction.meterId(), (Matcher)Matchers.is((Object)this.meterId1));
    }

    @Test
    public void testMeterTrafficInstructionEquals() {
        this.checkEqualsAndToString(this.meterInstruction1, this.sameAsMeterInstruction1, this.meterInstruction2);
    }

    @Test
    public void testTransitionMethod() {
        Instruction instruction = Instructions.transition((Integer)1);
        Instructions.TableTypeTransition tableInstruction = (Instructions.TableTypeTransition)this.checkAndConvert(instruction, Instruction.Type.TABLE, Instructions.TableTypeTransition.class);
        MatcherAssert.assertThat((Object)tableInstruction.tableId(), (Matcher)Matchers.is((Object)1));
    }

    @Test
    public void testTableTypeTransitionInstructionEquals() {
        this.checkEqualsAndToString(this.transitionInstruction1, this.sameAsTransitionInstruction1, this.transitionInstruction2);
    }

    @Test
    public void testWriteMetadataMethod() {
        Instruction instruction = Instructions.writeMetadata((long)this.metadata1, (long)this.metadataMask1);
        Instructions.MetadataInstruction metadataInstruction = (Instructions.MetadataInstruction)this.checkAndConvert(instruction, Instruction.Type.METADATA, Instructions.MetadataInstruction.class);
        MatcherAssert.assertThat((Object)metadataInstruction.metadata(), (Matcher)Matchers.is((Object)this.metadata1));
        MatcherAssert.assertThat((Object)metadataInstruction.metadataMask(), (Matcher)Matchers.is((Object)this.metadataMask1));
    }

    @Test
    public void testInstructionEquals() {
        this.checkEqualsAndToString(this.metadataInstruction1, this.sameAsMetadataInstruction1, this.metadataInstruction2);
    }

    @Test
    public void testExtensionMethod() {
        Instructions.ExtensionInstructionWrapper instruction = Instructions.extension((ExtensionTreatment)this.extensionTreatment1, (DeviceId)this.deviceId1);
        Instructions.ExtensionInstructionWrapper extensionInstructionWrapper = (Instructions.ExtensionInstructionWrapper)this.checkAndConvert((Instruction)instruction, Instruction.Type.EXTENSION, Instructions.ExtensionInstructionWrapper.class);
        MatcherAssert.assertThat((Object)extensionInstructionWrapper.deviceId(), (Matcher)Matchers.is((Object)this.deviceId1));
        MatcherAssert.assertThat((Object)extensionInstructionWrapper.extensionInstruction(), (Matcher)Matchers.is((Object)this.extensionTreatment1));
    }

    @Test
    public void testExtensionInstructionWrapperEquals() {
        this.checkEqualsAndToString(this.extensionInstruction1, this.sameAsExtensionInstruction1, this.extensionInstruction2);
    }

    @Test
    public void testPushMplsMethod() {
        Instruction instruction = Instructions.pushMpls();
        L2ModificationInstruction.ModMplsHeaderInstruction pushHeaderInstruction = (L2ModificationInstruction.ModMplsHeaderInstruction)this.checkAndConvert(instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModMplsHeaderInstruction.class);
        MatcherAssert.assertThat((Object)pushHeaderInstruction.ethernetType().toString(), (Matcher)Matchers.is((Object)EthType.EtherType.MPLS_UNICAST.toString()));
        MatcherAssert.assertThat((Object)pushHeaderInstruction.subtype(), (Matcher)Matchers.is((Object)L2ModificationInstruction.L2SubType.MPLS_PUSH));
    }

    @Test
    public void testPopMplsMethod() {
        Instruction instruction = Instructions.popMpls();
        L2ModificationInstruction.ModMplsHeaderInstruction pushHeaderInstruction = (L2ModificationInstruction.ModMplsHeaderInstruction)this.checkAndConvert(instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModMplsHeaderInstruction.class);
        MatcherAssert.assertThat((Object)pushHeaderInstruction.ethernetType().toString(), (Matcher)Matchers.is((Object)EthType.EtherType.MPLS_UNICAST.toString()));
        MatcherAssert.assertThat((Object)pushHeaderInstruction.subtype(), (Matcher)Matchers.is((Object)L2ModificationInstruction.L2SubType.MPLS_POP));
    }

    @Test
    public void testPopMplsEthertypeMethod() {
        Instruction instruction = Instructions.popMpls((EthType)new EthType(1));
        L2ModificationInstruction.ModMplsHeaderInstruction pushHeaderInstruction = (L2ModificationInstruction.ModMplsHeaderInstruction)this.checkAndConvert(instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModMplsHeaderInstruction.class);
        MatcherAssert.assertThat((Object)pushHeaderInstruction.ethernetType().toShort(), (Matcher)Matchers.is((Object)1));
        MatcherAssert.assertThat((Object)pushHeaderInstruction.subtype(), (Matcher)Matchers.is((Object)L2ModificationInstruction.L2SubType.MPLS_POP));
    }

    @Test
    public void testPushVlanMethod() {
        Instruction instruction = Instructions.pushVlan();
        L2ModificationInstruction.ModVlanHeaderInstruction pushHeaderInstruction = (L2ModificationInstruction.ModVlanHeaderInstruction)this.checkAndConvert(instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModVlanHeaderInstruction.class);
        MatcherAssert.assertThat((Object)pushHeaderInstruction.ethernetType().toString(), (Matcher)Matchers.is((Object)EthType.EtherType.VLAN.toString()));
        MatcherAssert.assertThat((Object)pushHeaderInstruction.subtype(), (Matcher)Matchers.is((Object)L2ModificationInstruction.L2SubType.VLAN_PUSH));
    }

    @Test
    public void testModMplsHeaderInstructionsEquals() {
        this.checkEqualsAndToString(this.modMplsHeaderInstruction1, this.sameAsModMplsHeaderInstruction1, this.modMplsHeaderInstruction2);
    }

    @Test
    public void testDecMplsTtlMethod() {
        L2ModificationInstruction instruction = Instructions.decMplsTtl();
        L2ModificationInstruction.ModMplsTtlInstruction modMplsTtlInstruction = (L2ModificationInstruction.ModMplsTtlInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModMplsTtlInstruction.class);
        MatcherAssert.assertThat((Object)modMplsTtlInstruction.subtype(), (Matcher)Matchers.is((Object)L2ModificationInstruction.L2SubType.DEC_MPLS_TTL));
    }

    @Test
    public void testMplsTtlInstructionsEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.modMplsTtlInstruction1, this.sameAsModMplsTtlInstruction1}).testEquals();
    }

    @Test
    public void testModMplsBosMethod() {
        L2ModificationInstruction instruction = Instructions.modMplsBos((boolean)true);
        L2ModificationInstruction.ModMplsBosInstruction modMplsBosInstruction = (L2ModificationInstruction.ModMplsBosInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModMplsBosInstruction.class);
        MatcherAssert.assertThat((Object)modMplsBosInstruction.subtype(), (Matcher)Matchers.is((Object)L2ModificationInstruction.L2SubType.MPLS_BOS));
        MatcherAssert.assertThat((Object)modMplsBosInstruction.mplsBos(), (Matcher)Matchers.is((Object)true));
    }

    @Test
    public void testMplsBosInstructionsEquals() {
        this.checkEqualsAndToString(this.modMplsBosInstruction1, this.sameAsModMplsBosInstruction1, this.modMplsBosInstruction2);
    }

    @Test
    public void testPopVlanMethod() {
        Instruction instruction = Instructions.popVlan();
        L2ModificationInstruction.ModVlanHeaderInstruction popVlanInstruction = (L2ModificationInstruction.ModVlanHeaderInstruction)this.checkAndConvert(instruction, Instruction.Type.L2MODIFICATION, L2ModificationInstruction.ModVlanHeaderInstruction.class);
        MatcherAssert.assertThat((Object)popVlanInstruction.subtype(), (Matcher)Matchers.is((Object)L2ModificationInstruction.L2SubType.VLAN_POP));
    }

    @Test
    public void testModVlanHeaderInstructionsEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.modVlanHeaderInstruction1, this.sameAsModVlanHeaderInstruction1}).testEquals();
    }

    @Test
    public void testModArpSpaMethod() {
        L3ModificationInstruction instruction = Instructions.modArpSpa((IpAddress)this.ip41);
        L3ModificationInstruction.ModArpIPInstruction modArpIPInstruction = (L3ModificationInstruction.ModArpIPInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModArpIPInstruction.class);
        MatcherAssert.assertThat((Object)modArpIPInstruction.subtype(), (Matcher)Matchers.is((Object)L3ModificationInstruction.L3SubType.ARP_SPA));
        MatcherAssert.assertThat((Object)modArpIPInstruction.ip(), (Matcher)Matchers.is((Object)this.ip41));
    }

    @Test
    public void testModArpIPInstructionEquals() {
        this.checkEqualsAndToString(this.modArpIPInstruction1, this.sameAsModArpIPInstruction1, this.modArpIPInstruction2);
    }

    @Test
    public void testModArpShaMethod() {
        L3ModificationInstruction instruction = Instructions.modArpSha((MacAddress)this.mac1);
        L3ModificationInstruction.ModArpEthInstruction modArpEthInstruction = (L3ModificationInstruction.ModArpEthInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModArpEthInstruction.class);
        MatcherAssert.assertThat((Object)modArpEthInstruction.subtype(), (Matcher)Matchers.is((Object)L3ModificationInstruction.L3SubType.ARP_SHA));
        MatcherAssert.assertThat((Object)modArpEthInstruction.mac(), (Matcher)Matchers.is((Object)this.mac1));
    }

    @Test
    public void testModArpEthInstructionEquals() {
        this.checkEqualsAndToString(this.modArpEthInstruction1, this.sameAsModArpEthInstruction1, this.modArpEthInstruction2);
    }

    @Test
    public void testModArpModL3ArpOpMethod() {
        L3ModificationInstruction instruction = Instructions.modL3ArpOp((short)1);
        L3ModificationInstruction.ModArpOpInstruction modArpEthInstruction = (L3ModificationInstruction.ModArpOpInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModArpOpInstruction.class);
        MatcherAssert.assertThat((Object)modArpEthInstruction.subtype(), (Matcher)Matchers.is((Object)L3ModificationInstruction.L3SubType.ARP_OP));
        MatcherAssert.assertThat((Object)modArpEthInstruction.op(), (Matcher)Matchers.is((Object)1L));
    }

    @Test
    public void testModArpOpInstructionEquals() {
        this.checkEqualsAndToString(this.modArpOpInstruction1, this.sameAsModArpOpInstruction1, this.modArpOpInstruction2);
    }

    @Test
    public void testCopyTtlInMethod() {
        L3ModificationInstruction instruction = Instructions.copyTtlIn();
        L3ModificationInstruction.ModTtlInstruction modTtlInstruction = (L3ModificationInstruction.ModTtlInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModTtlInstruction.class);
        MatcherAssert.assertThat((Object)modTtlInstruction.subtype(), (Matcher)Matchers.is((Object)L3ModificationInstruction.L3SubType.TTL_IN));
    }

    @Test
    public void testCopyTtlOutMethod() {
        L3ModificationInstruction instruction = Instructions.copyTtlOut();
        L3ModificationInstruction.ModTtlInstruction modTtlInstruction = (L3ModificationInstruction.ModTtlInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModTtlInstruction.class);
        MatcherAssert.assertThat((Object)modTtlInstruction.subtype(), (Matcher)Matchers.is((Object)L3ModificationInstruction.L3SubType.TTL_OUT));
    }

    @Test
    public void testDecNwTtlOutMethod() {
        L3ModificationInstruction instruction = Instructions.decNwTtl();
        L3ModificationInstruction.ModTtlInstruction modTtlInstruction = (L3ModificationInstruction.ModTtlInstruction)this.checkAndConvert((Instruction)instruction, Instruction.Type.L3MODIFICATION, L3ModificationInstruction.ModTtlInstruction.class);
        MatcherAssert.assertThat((Object)modTtlInstruction.subtype(), (Matcher)Matchers.is((Object)L3ModificationInstruction.L3SubType.DEC_TTL));
    }

    @Test
    public void testModTtlInstructionEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.modArpTtlInstruction1, this.sameAsModArpTtlInstruction1}).addEqualityGroup(new Object[]{this.modArpTtlInstruction2}).addEqualityGroup(new Object[]{this.modArpTtlInstruction3}).testEquals();
    }

    class MockExtensionTreatment
    implements ExtensionTreatment {
        int type;

        MockExtensionTreatment(int type) {
            this.type = type;
        }

        public ExtensionTreatmentType type() {
            return new ExtensionTreatmentType(this.type);
        }

        public <T> void setPropertyValue(String key, T value) throws ExtensionPropertyException {
        }

        public <T> T getPropertyValue(String key) throws ExtensionPropertyException {
            return null;
        }

        public List<String> getProperties() {
            return null;
        }

        public byte[] serialize() {
            return new byte[0];
        }

        public void deserialize(byte[] data) {
        }
    }
}

