/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.topo;

import org.junit.Assert;
import org.junit.Test;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DefaultLink;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.provider.ProviderId;
import org.onosproject.ui.topo.TopoUtils;

public class TopoUtilsTest {
    private static final String AM_WL = "wrong label";
    private static final String AM_WM = "wrong magnitude";
    private static final String AM_CL = "clipped?";
    private static final String AM_NCL = "not clipped?";
    private static final ConnectPoint CP_FU = ConnectPoint.deviceConnectPoint((String)"fu:001/3");
    private static final ConnectPoint CP_BAH = ConnectPoint.deviceConnectPoint((String)"bah:002/5");
    private static final Link LINK_FU_BAH = DefaultLink.builder().src(CP_FU).dst(CP_BAH).type(Link.Type.DIRECT).providerId(ProviderId.NONE).build();
    private static final Link LINK_BAH_FU = DefaultLink.builder().src(CP_BAH).dst(CP_FU).type(Link.Type.DIRECT).providerId(ProviderId.NONE).build();
    private TopoUtils.ValueLabel vl;

    @Test
    public void linkStringFuBah() {
        String compact = TopoUtils.compactLinkString((Link)LINK_FU_BAH);
        Assert.assertEquals((String)"wrong link id", (Object)"fu:001/3-bah:002/5", (Object)compact);
    }

    @Test
    public void linkStringBahFu() {
        String compact = TopoUtils.compactLinkString((Link)LINK_BAH_FU);
        Assert.assertEquals((String)"wrong link id", (Object)"bah:002/5-fu:001/3", (Object)compact);
    }

    @Test
    public void canonLinkKey() {
        LinkKey fb = TopoUtils.canonicalLinkKey((Link)LINK_FU_BAH);
        LinkKey bf = TopoUtils.canonicalLinkKey((Link)LINK_BAH_FU);
        Assert.assertEquals((String)"not canonical", (Object)fb, (Object)bf);
    }

    @Test
    public void formatSmallBytes() {
        this.vl = TopoUtils.formatBytes((long)1000L);
        Assert.assertEquals((String)AM_WM, (Object)TopoUtils.Magnitude.ONE, (Object)this.vl.magnitude());
        Assert.assertEquals((String)AM_WL, (Object)"1,000 B", (Object)this.vl.toString());
    }

    @Test
    public void formatKiloBytes() {
        this.vl = TopoUtils.formatBytes((long)2000L);
        Assert.assertEquals((String)AM_WM, (Object)TopoUtils.Magnitude.KILO, (Object)this.vl.magnitude());
        Assert.assertEquals((String)AM_WL, (Object)"1.95 KB", (Object)this.vl.toString());
    }

    @Test
    public void formatMegaBytes() {
        this.vl = TopoUtils.formatBytes((long)3000000L);
        Assert.assertEquals((String)AM_WM, (Object)TopoUtils.Magnitude.MEGA, (Object)this.vl.magnitude());
        Assert.assertEquals((String)AM_WL, (Object)"2.86 MB", (Object)this.vl.toString());
    }

    @Test
    public void formatGigaBytes() {
        this.vl = TopoUtils.formatBytes((long)4000000000L);
        Assert.assertEquals((String)AM_WM, (Object)TopoUtils.Magnitude.GIGA, (Object)this.vl.magnitude());
        Assert.assertEquals((String)AM_WL, (Object)"3.73 GB", (Object)this.vl.toString());
    }

    @Test
    public void formatTeraBytes() {
        this.vl = TopoUtils.formatBytes((long)5000000000000L);
        Assert.assertEquals((String)AM_WM, (Object)TopoUtils.Magnitude.GIGA, (Object)this.vl.magnitude());
        Assert.assertEquals((String)AM_WL, (Object)"4,656.61 GB", (Object)this.vl.toString());
    }

    @Test
    public void formatPacketRateSmall() {
        this.vl = TopoUtils.formatPacketRate((long)37L);
        Assert.assertEquals((String)AM_WL, (Object)"37 pps", (Object)this.vl.toString());
    }

    @Test
    public void formatPacketRateKilo() {
        this.vl = TopoUtils.formatPacketRate((long)1024L);
        Assert.assertEquals((String)AM_WL, (Object)"1 Kpps", (Object)this.vl.toString());
    }

    @Test
    public void formatPacketRateKilo2() {
        this.vl = TopoUtils.formatPacketRate((long)1034L);
        Assert.assertEquals((String)AM_WL, (Object)"1.01 Kpps", (Object)this.vl.toString());
    }

    @Test
    public void formatPacketRateMega() {
        this.vl = TopoUtils.formatPacketRate((long)9000000L);
        Assert.assertEquals((String)AM_WL, (Object)"8.58 Mpps", (Object)this.vl.toString());
    }

    @Test
    public void formatClippedBitsSmall() {
        this.vl = TopoUtils.formatClippedBitRate((long)8L);
        Assert.assertEquals((String)AM_WL, (Object)"64 bps", (Object)this.vl.toString());
        Assert.assertFalse((String)AM_CL, (boolean)this.vl.clipped());
    }

    @Test
    public void formatClippedBitsKilo() {
        this.vl = TopoUtils.formatClippedBitRate((long)2004L);
        Assert.assertEquals((String)AM_WL, (Object)"15.66 Kbps", (Object)this.vl.toString());
        Assert.assertFalse((String)AM_CL, (boolean)this.vl.clipped());
    }

    @Test
    public void formatClippedBitsMega() {
        this.vl = TopoUtils.formatClippedBitRate((long)3123123L);
        Assert.assertEquals((String)AM_WL, (Object)"23.83 Mbps", (Object)this.vl.toString());
        Assert.assertFalse((String)AM_CL, (boolean)this.vl.clipped());
    }

    @Test
    public void formatClippedBitsGiga() {
        this.vl = TopoUtils.formatClippedBitRate((long)500000000L);
        Assert.assertEquals((String)AM_WL, (Object)"3.73 Gbps", (Object)this.vl.toString());
        Assert.assertFalse((String)AM_CL, (boolean)this.vl.clipped());
    }

    @Test
    public void formatClippedBitsGigaExceedThreshold() {
        this.vl = TopoUtils.formatClippedBitRate((long)5000000000L);
        Assert.assertEquals((String)AM_WL, (Object)"10 Gbps", (Object)this.vl.toString());
        Assert.assertTrue((String)AM_NCL, (boolean)this.vl.clipped());
    }

    @Test
    public void formatNoFlows() {
        String f = TopoUtils.formatFlows((long)0L);
        Assert.assertEquals((String)AM_WL, (Object)"", (Object)f);
    }

    @Test
    public void formatNegativeFlows() {
        String f = TopoUtils.formatFlows((long)-3L);
        Assert.assertEquals((String)AM_WL, (Object)"", (Object)f);
    }

    @Test
    public void formatOneFlow() {
        String f = TopoUtils.formatFlows((long)1L);
        Assert.assertEquals((String)AM_WL, (Object)"1 flow", (Object)f);
    }

    @Test
    public void formatManyFlows() {
        String f = TopoUtils.formatFlows((long)42L);
        Assert.assertEquals((String)AM_WL, (Object)"42 flows", (Object)f);
    }
}

