/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.app;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.net.URI;
import java.util.List;
import java.util.Set;
import org.junit.Assert;
import org.junit.Test;
import org.onosproject.app.DefaultApplicationDescription;
import org.onosproject.core.ApplicationRole;
import org.onosproject.core.Version;
import org.onosproject.security.AppPermission;
import org.onosproject.security.Permission;

public class DefaultApplicationDescriptionTest {
    public static final String APP_NAME = "org.foo.app";
    public static final Version VER = Version.version((int)1, (int)2, (String)"a", null);
    public static final String TITLE = "Awesome App";
    public static final String DESC = "Awesome application from Circus, Inc.";
    public static final String ORIGIN = "Circus";
    public static final String CATEGORY = "other";
    public static final String URL = "http://www.onosproject.org";
    public static final String README = "Awesome application from Circus, Inc.";
    public static final byte[] ICON = new byte[0];
    public static final ApplicationRole ROLE = ApplicationRole.ADMIN;
    public static final Set<Permission> PERMS = ImmutableSet.of((Object)new Permission(AppPermission.class.getName(), "FLOWRULE_WRITE"), (Object)new Permission(AppPermission.class.getName(), "FLOWRULE_READ"));
    public static final URI FURL = URI.create("mvn:org.foo-features/1.2a/xml/features");
    public static final List<String> FEATURES = ImmutableList.of((Object)"foo", (Object)"bar");
    public static final List<String> APPS = ImmutableList.of((Object)"fifi");

    @Test
    public void basics() {
        DefaultApplicationDescription app = new DefaultApplicationDescription(APP_NAME, VER, TITLE, "Awesome application from Circus, Inc.", ORIGIN, CATEGORY, URL, "Awesome application from Circus, Inc.", ICON, ROLE, PERMS, FURL, FEATURES, APPS);
        Assert.assertEquals((String)"incorrect id", (Object)APP_NAME, (Object)app.name());
        Assert.assertEquals((String)"incorrect version", (Object)VER, (Object)app.version());
        Assert.assertEquals((String)"incorrect title", (Object)TITLE, (Object)app.title());
        Assert.assertEquals((String)"incorrect description", (Object)"Awesome application from Circus, Inc.", (Object)app.description());
        Assert.assertEquals((String)"incorrect origin", (Object)ORIGIN, (Object)app.origin());
        Assert.assertEquals((String)"incorrect category", (Object)CATEGORY, (Object)app.category());
        Assert.assertEquals((String)"incorrect URL", (Object)URL, (Object)app.url());
        Assert.assertEquals((String)"incorrect readme", (Object)"Awesome application from Circus, Inc.", (Object)app.readme());
        Assert.assertEquals((String)"incorrect role", (Object)ROLE, (Object)app.role());
        Assert.assertEquals((String)"incorrect permissions", PERMS, (Object)app.permissions());
        Assert.assertEquals((String)"incorrect features repo", (Object)FURL, app.featuresRepo().get());
        Assert.assertEquals((String)"incorrect features", FEATURES, (Object)app.features());
        Assert.assertEquals((String)"incorrect apps", APPS, (Object)app.requiredApps());
        Assert.assertTrue((String)"incorrect toString", (boolean)app.toString().contains(APP_NAME));
    }
}

