/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.driver;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.onosproject.net.DeviceId;
import org.onosproject.net.driver.DefaultDriver;
import org.onosproject.net.driver.DefaultDriverData;
import org.onosproject.net.driver.Driver;
import org.onosproject.net.driver.TestBehaviour;
import org.onosproject.net.driver.TestBehaviourImpl;

public class DefaultDriverDataTest {
    public static final DeviceId DEVICE_ID = DeviceId.deviceId((String)"of:0011223344556677");
    DefaultDriver ddc;
    DefaultDriverData data;

    @Before
    public void setUp() {
        this.ddc = new DefaultDriver("foo.bar", new ArrayList(), "Circus", "lux", "1.2a", (Map)ImmutableMap.of(TestBehaviour.class, TestBehaviourImpl.class), (Map)ImmutableMap.of((Object)"foo", (Object)"bar"));
        this.data = new DefaultDriverData((Driver)this.ddc, DEVICE_ID);
    }

    @Test
    public void basics() {
        Assert.assertSame((String)"incorrect driver", (Object)this.ddc, (Object)this.data.driver());
        Assert.assertEquals((String)"incorrect device id", (Object)DEVICE_ID, (Object)this.data.deviceId());
        Assert.assertTrue((String)"incorrect toString", (boolean)this.data.toString().contains("foo.bar"));
    }

    @Test
    public void behaviour() {
        TestBehaviour behaviour = (TestBehaviour)this.data.behaviour(TestBehaviour.class);
        Assert.assertTrue((String)"incorrect behaviour", (boolean)(behaviour instanceof TestBehaviourImpl));
    }

    @Test
    public void setAndClearAnnotations() {
        this.data.set("croc", "aqua");
        this.data.set("roo", "mars");
        this.data.set("dingo", "bat");
        Assert.assertEquals((String)"incorrect property", (Object)"bat", (Object)this.data.value("dingo"));
        this.data.clear(new String[]{"dingo", "roo"});
        Assert.assertNull((String)"incorrect property", (Object)this.data.value("dingo"));
        Assert.assertNull((String)"incorrect property", (Object)this.data.value("root"));
        Assert.assertEquals((String)"incorrect property", (Object)"aqua", (Object)this.data.value("croc"));
        Assert.assertEquals((String)"incorrect properties", (long)1L, (long)this.data.keys().size());
    }

    @Test
    public void clearAllAnnotations() {
        this.data.set("croc", "aqua");
        this.data.set("roo", "mars");
        this.data.set("dingo", "bat");
        Assert.assertEquals((String)"incorrect property", (Object)"bat", (Object)this.data.value("dingo"));
        this.data.clear(new String[0]);
        Assert.assertEquals((String)"incorrect properties", (long)0L, (long)this.data.keys().size());
    }
}

