/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.time.Duration;
import org.onosproject.net.Link;
import org.onosproject.net.LinkKey;
import org.onosproject.net.config.Config;
import org.onosproject.net.config.basics.AllowedEntityConfig;

public final class BasicLinkConfig
extends AllowedEntityConfig<LinkKey> {
    public static final String CONFIG_KEY = "basic";
    public static final String TYPE = "type";
    public static final String METRIC = "metric";
    public static final String LATENCY = "latency";
    public static final String BANDWIDTH = "bandwidth";
    public static final String IS_DURABLE = "durable";
    public static final String IS_BIDIRECTIONAL = "bidirectional";

    @Override
    public boolean isValid() {
        return this.hasOnlyFields("allowed", TYPE, METRIC, LATENCY, BANDWIDTH, IS_DURABLE, IS_BIDIRECTIONAL) && this.isBoolean("allowed", Config.FieldPresence.OPTIONAL) && this.isNumber(METRIC, Config.FieldPresence.OPTIONAL, new long[0]) && this.isNumber(LATENCY, Config.FieldPresence.OPTIONAL, new long[0]) && this.isNumber(BANDWIDTH, Config.FieldPresence.OPTIONAL, new long[0]) && this.isBoolean(IS_BIDIRECTIONAL, Config.FieldPresence.OPTIONAL);
    }

    public Link.Type type() {
        return this.get(TYPE, Link.Type.DIRECT, Link.Type.class);
    }

    public BasicLinkConfig type(Link.Type type) {
        return (BasicLinkConfig)this.setOrClear(TYPE, type);
    }

    public double metric() {
        return this.get(METRIC, -1);
    }

    public BasicLinkConfig metric(Double metric) {
        return (BasicLinkConfig)this.setOrClear(METRIC, metric);
    }

    public Duration latency() {
        return Duration.ofNanos(this.get(LATENCY, -1));
    }

    public BasicLinkConfig latency(Duration latency) {
        Long nanos = latency == null ? null : Long.valueOf(latency.toNanos());
        return (BasicLinkConfig)this.setOrClear(LATENCY, nanos);
    }

    public long bandwidth() {
        return this.get(BANDWIDTH, -1);
    }

    public BasicLinkConfig bandwidth(Long bandwidth) {
        return (BasicLinkConfig)this.setOrClear(BANDWIDTH, bandwidth);
    }

    public Boolean isDurable() {
        JsonNode res = this.object.path(IS_DURABLE);
        if (res.isMissingNode()) {
            return null;
        }
        return res.asBoolean();
    }

    public BasicLinkConfig isDurable(Boolean isDurable) {
        return (BasicLinkConfig)this.setOrClear(IS_DURABLE, isDurable);
    }

    public Boolean isBidirectional() {
        JsonNode res = this.object.path(IS_BIDIRECTIONAL);
        if (res.isMissingNode()) {
            return true;
        }
        return res.asBoolean();
    }

    public BasicLinkConfig isBidirectional(Boolean isBidirectional) {
        return (BasicLinkConfig)this.setOrClear(IS_BIDIRECTIONAL, isBidirectional);
    }

    public BasicLinkConfig(LinkKey linkKey) {
        ObjectMapper mapper = new ObjectMapper();
        this.init(linkKey, CONFIG_KEY, (JsonNode)mapper.createObjectNode(), mapper, null);
    }

    public BasicLinkConfig() {
    }
}

