/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.config.basics.BasicElementConfig;
import org.onosproject.net.region.Region;
import org.onosproject.net.region.RegionId;
import org.onosproject.ui.topo.LayoutLocation;

public final class BasicRegionConfig
extends BasicElementConfig<RegionId> {
    private static final String TYPE = "type";
    private static final String DEVICES = "devices";
    private static final String LOC_IN_PEERS = "locInPeers";
    private static final String LOC_TYPE = "locType";
    private static final String LAT_OR_Y = "latOrY";
    private static final String LONG_OR_X = "LongOrX";

    @Override
    public boolean isValid() {
        return this.hasOnlyFields("allowed", "name", "latitude", "longitude", "uiType", "rackAddress", "owner", TYPE, DEVICES, LOC_IN_PEERS);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name()).add(TYPE, (Object)this.type()).add("uiType", (Object)this.uiType()).add("latitude", this.latitude()).add("longitude", this.longitude()).add(DEVICES, this.devices()).toString();
    }

    public Region.Type type() {
        String t = this.get(TYPE, null);
        return t == null ? null : this.regionTypeFor(t);
    }

    private Region.Type regionTypeFor(String t) {
        try {
            return Region.Type.valueOf(t.toUpperCase());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public BasicRegionConfig type(Region.Type type) {
        String t = type == null ? null : type.name().toLowerCase();
        return (BasicRegionConfig)this.setOrClear(TYPE, t);
    }

    public List<DeviceId> devices() {
        return this.object.has(DEVICES) ? this.getList(DEVICES, DeviceId::deviceId) : null;
    }

    public BasicRegionConfig devices(Set<DeviceId> devices) {
        return (BasicRegionConfig)this.setOrClear(DEVICES, devices);
    }

    public BasicRegionConfig addPeerLocMapping(String peerId, String locType, Double latOrY, Double longOrX) {
        ObjectNode map = this.getLocMap();
        map.set(peerId, this.makeLocation(locType, latOrY, longOrX));
        return this;
    }

    private JsonNode makeLocation(String locType, Double latOrY, Double longOrX) {
        return this.mapper.createObjectNode().put(LOC_TYPE, locType).put(LAT_OR_Y, latOrY).put(LONG_OR_X, longOrX);
    }

    private ObjectNode getLocMap() {
        ObjectNode locMap = (ObjectNode)this.object.get(LOC_IN_PEERS);
        if (locMap == null) {
            locMap = this.mapper.createObjectNode();
            this.object.set(LOC_IN_PEERS, (JsonNode)locMap);
        }
        return locMap;
    }

    public List<LayoutLocation> getMappings() {
        ArrayList<LayoutLocation> mappings = new ArrayList<LayoutLocation>();
        ObjectNode map = (ObjectNode)this.object.get(LOC_IN_PEERS);
        if (map != null) {
            Iterator it = map.fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                String peerId = (String)entry.getKey();
                ObjectNode data = (ObjectNode)entry.getValue();
                String lt = data.get(LOC_TYPE).asText();
                double latY = data.get(LAT_OR_Y).asDouble();
                double longX = data.get(LONG_OR_X).asDouble();
                mappings.add(LayoutLocation.layoutLocation(peerId, lt, latY, longX));
            }
        }
        return mappings;
    }
}

