/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.mcast;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.mcast.McastRoute;

public final class McastRouteInfo {
    private static final String ROUTE_NOT_NULL = "Route cannot be null";
    private final McastRoute route;
    private final Optional<ConnectPoint> sink;
    private final Optional<ConnectPoint> source;
    private final Set<ConnectPoint> sinks;

    private McastRouteInfo(McastRoute route, ConnectPoint sink, ConnectPoint source, Set<ConnectPoint> sinks) {
        this.route = (McastRoute)Preconditions.checkNotNull((Object)route, (Object)ROUTE_NOT_NULL);
        this.sink = Optional.ofNullable(sink);
        this.source = Optional.ofNullable(source);
        this.sinks = sinks;
    }

    public static McastRouteInfo mcastRouteInfo(McastRoute route) {
        return new McastRouteInfo(route, null, null, Collections.EMPTY_SET);
    }

    public static McastRouteInfo mcastRouteInfo(McastRoute route, ConnectPoint sink, ConnectPoint source) {
        return new McastRouteInfo(route, sink, source, Collections.EMPTY_SET);
    }

    public static McastRouteInfo mcastRouteInfo(McastRoute route, Set<ConnectPoint> sinks, ConnectPoint source) {
        return new McastRouteInfo(route, null, source, (Set<ConnectPoint>)ImmutableSet.copyOf(sinks));
    }

    public boolean isComplete() {
        return (this.sink.isPresent() || !this.sinks.isEmpty()) && this.source.isPresent();
    }

    public McastRoute route() {
        return this.route;
    }

    public Optional<ConnectPoint> source() {
        return this.source;
    }

    public Optional<ConnectPoint> sink() {
        return this.sink;
    }

    public Set<ConnectPoint> sinks() {
        return this.sinks;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("route", (Object)this.route()).add("sink", this.sink()).add("source", this.source()).add("sinks", this.sinks()).toString();
    }
}

