/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.Map;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.config.BaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PortAnnotationConfig
extends BaseConfig<ConnectPoint> {
    public static final String CONFIG_KEY = "annotations";
    private static final String ENTRIES = "entries";
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    @Override
    public boolean isValid() {
        return this.hasField(ENTRIES) && this.object.get(ENTRIES).isObject();
    }

    public Map<String, String> annotations() {
        HashMap<String, String> map = new HashMap<String, String>();
        JsonNode jsonNode = this.object.path(ENTRIES);
        if (!jsonNode.isObject()) {
            return map;
        }
        jsonNode.fields().forEachRemaining(entry -> {
            String key = (String)entry.getKey();
            JsonNode value = (JsonNode)entry.getValue();
            if (value.isTextual()) {
                map.put(key, value.asText());
            } else if (value.isNull()) {
                map.put(key, null);
            } else {
                try {
                    map.put(key, this.mapper().writeValueAsString((Object)value));
                }
                catch (JsonProcessingException e) {
                    this.log.warn("Error processing JSON value for {}.", (Object)key, (Object)e);
                }
            }
        });
        return map;
    }

    public PortAnnotationConfig annotations(Map<String, String> replace) {
        ObjectNode anns = this.object.objectNode();
        if (replace != null) {
            replace.forEach((k, v) -> anns.put(k, v));
        }
        this.object.set(ENTRIES, (JsonNode)anns);
        return this;
    }

    public PortAnnotationConfig annotation(String key, String value) {
        JsonNode ent = this.object.path(ENTRIES);
        ObjectNode obj = ent.isObject() ? (ObjectNode)ent : this.object.objectNode();
        obj.put(key, value);
        this.object.set(ENTRIES, (JsonNode)obj);
        return this;
    }

    public PortAnnotationConfig annotation(String key) {
        JsonNode ent = this.object.path(ENTRIES);
        ObjectNode obj = ent.isObject() ? (ObjectNode)ent : this.object.objectNode();
        obj.remove(key);
        this.object.set(ENTRIES, (JsonNode)obj);
        return this;
    }

    public PortAnnotationConfig() {
    }

    public PortAnnotationConfig(ConnectPoint cp) {
        ObjectMapper mapper = new ObjectMapper();
        this.init(cp, CONFIG_KEY, (JsonNode)mapper.createObjectNode(), mapper, null);
    }
}

