/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.onlab.packet.EthType;
import org.onlab.packet.IpAddress;
import org.onlab.packet.MacAddress;
import org.onlab.packet.MplsLabel;
import org.onlab.packet.TpPort;
import org.onlab.packet.VlanId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.PortNumber;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.flow.instructions.ExtensionTreatment;
import org.onosproject.net.flow.instructions.Instruction;
import org.onosproject.net.flow.instructions.Instructions;
import org.onosproject.net.meter.MeterId;

public final class DefaultTrafficTreatment
implements TrafficTreatment {
    private final List<Instruction> immediate;
    private final List<Instruction> deferred;
    private final List<Instruction> all;
    private final Instructions.TableTypeTransition table;
    private final Instructions.MetadataInstruction meta;
    private final boolean hasClear;
    private static final DefaultTrafficTreatment EMPTY = new DefaultTrafficTreatment((List<Instruction>)ImmutableList.of((Object)Instructions.createNoAction()));
    private final Instructions.MeterInstruction meter;

    private DefaultTrafficTreatment(List<Instruction> immediate) {
        this.immediate = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(immediate)));
        this.deferred = ImmutableList.of();
        this.all = this.immediate;
        this.hasClear = false;
        this.table = null;
        this.meta = null;
        this.meter = null;
    }

    private DefaultTrafficTreatment(List<Instruction> deferred, List<Instruction> immediate, Instructions.TableTypeTransition table, boolean clear, Instructions.MetadataInstruction meta, Instructions.MeterInstruction meter) {
        this.immediate = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(immediate)));
        this.deferred = ImmutableList.copyOf((Collection)((Collection)Preconditions.checkNotNull(deferred)));
        this.all = new ImmutableList.Builder().addAll(immediate).addAll(deferred).build();
        this.table = table;
        this.meta = meta;
        this.hasClear = clear;
        this.meter = meter;
    }

    @Override
    public List<Instruction> deferred() {
        return this.deferred;
    }

    @Override
    public List<Instruction> immediate() {
        return this.immediate;
    }

    @Override
    public List<Instruction> allInstructions() {
        return this.all;
    }

    @Override
    public Instructions.TableTypeTransition tableTransition() {
        return this.table;
    }

    @Override
    public boolean clearedDeferred() {
        return this.hasClear;
    }

    @Override
    public Instructions.MetadataInstruction writeMetadata() {
        return this.meta;
    }

    @Override
    public Instructions.MeterInstruction metered() {
        return this.meter;
    }

    public static TrafficTreatment.Builder builder() {
        return new Builder();
    }

    public static TrafficTreatment emptyTreatment() {
        return EMPTY;
    }

    public static TrafficTreatment.Builder builder(TrafficTreatment treatment) {
        return new Builder(treatment);
    }

    public int hashCode() {
        return Objects.hash(this.immediate, this.deferred, this.table, this.meta);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultTrafficTreatment) {
            DefaultTrafficTreatment that = (DefaultTrafficTreatment)obj;
            return Objects.equals(this.immediate, that.immediate) && Objects.equals(this.deferred, that.deferred) && Objects.equals(this.table, that.table) && Objects.equals(this.meta, that.meta);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("immediate", this.immediate).add("deferred", this.deferred).add("transition", (Object)(this.table == null ? "None" : this.table.toString())).add("meter", (Object)(this.meter == null ? "None" : this.meter.toString())).add("cleared", this.hasClear).add("metadata", (Object)this.meta).toString();
    }

    public static final class Builder
    implements TrafficTreatment.Builder {
        boolean clear = false;
        Instructions.TableTypeTransition table;
        Instructions.MetadataInstruction meta;
        Instructions.MeterInstruction meter;
        List<Instruction> deferred = Lists.newLinkedList();
        List<Instruction> immediate = Lists.newLinkedList();
        List<Instruction> current = this.immediate;

        private Builder() {
        }

        private Builder(TrafficTreatment treatment) {
            this.deferred();
            treatment.deferred().forEach(i -> this.add((Instruction)i));
            this.immediate();
            treatment.immediate().stream().filter(i -> i.type() != Instruction.Type.NOACTION).forEach(i -> this.add((Instruction)i));
            this.clear = treatment.clearedDeferred();
        }

        @Override
        public Builder add(Instruction instruction) {
            switch (instruction.type()) {
                case NOACTION: 
                case OUTPUT: 
                case GROUP: 
                case QUEUE: 
                case L0MODIFICATION: 
                case L1MODIFICATION: 
                case L2MODIFICATION: 
                case L3MODIFICATION: 
                case L4MODIFICATION: 
                case EXTENSION: {
                    this.current.add(instruction);
                    break;
                }
                case TABLE: {
                    this.table = (Instructions.TableTypeTransition)instruction;
                    break;
                }
                case METADATA: {
                    this.meta = (Instructions.MetadataInstruction)instruction;
                    break;
                }
                case METER: {
                    this.meter = (Instructions.MeterInstruction)instruction;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown instruction type: " + (Object)((Object)instruction.type()));
                }
            }
            return this;
        }

        @Override
        public Builder drop() {
            return this.add(Instructions.createNoAction());
        }

        private Builder noAction() {
            return this.add(Instructions.createNoAction());
        }

        @Override
        public Builder punt() {
            return this.add(Instructions.createOutput(PortNumber.CONTROLLER));
        }

        @Override
        public Builder setOutput(PortNumber number) {
            return this.add(Instructions.createOutput(number));
        }

        @Override
        public Builder setEthSrc(MacAddress addr) {
            return this.add(Instructions.modL2Src(addr));
        }

        @Override
        public Builder setEthDst(MacAddress addr) {
            return this.add(Instructions.modL2Dst(addr));
        }

        @Override
        public Builder setVlanId(VlanId id) {
            return this.add(Instructions.modVlanId(id));
        }

        @Override
        public Builder setVlanPcp(Byte pcp) {
            return this.add(Instructions.modVlanPcp(pcp));
        }

        @Override
        public Builder setIpSrc(IpAddress addr) {
            return this.add(Instructions.modL3Src(addr));
        }

        @Override
        public Builder setIpDst(IpAddress addr) {
            return this.add(Instructions.modL3Dst(addr));
        }

        @Override
        public Builder decNwTtl() {
            return this.add(Instructions.decNwTtl());
        }

        @Override
        public Builder copyTtlIn() {
            return this.add(Instructions.copyTtlIn());
        }

        @Override
        public Builder copyTtlOut() {
            return this.add(Instructions.copyTtlOut());
        }

        @Override
        public Builder pushMpls() {
            return this.add(Instructions.pushMpls());
        }

        @Override
        public Builder popMpls() {
            return this.add(Instructions.popMpls());
        }

        @Override
        public Builder popMpls(EthType etherType) {
            return this.add(Instructions.popMpls(etherType));
        }

        @Override
        public Builder setMpls(MplsLabel mplsLabel) {
            return this.add(Instructions.modMplsLabel(mplsLabel));
        }

        @Override
        public Builder setMplsBos(boolean mplsBos) {
            return this.add(Instructions.modMplsBos(mplsBos));
        }

        @Override
        public Builder decMplsTtl() {
            return this.add(Instructions.decMplsTtl());
        }

        @Override
        public Builder group(GroupId groupId) {
            return this.add(Instructions.createGroup(groupId));
        }

        @Override
        public Builder setQueue(long queueId) {
            return this.add(Instructions.setQueue(queueId, null));
        }

        @Override
        public Builder setQueue(long queueId, PortNumber port) {
            return this.add(Instructions.setQueue(queueId, port));
        }

        @Override
        public TrafficTreatment.Builder meter(MeterId meterId) {
            return this.add(Instructions.meterTraffic(meterId));
        }

        @Override
        public Builder popVlan() {
            return this.add(Instructions.popVlan());
        }

        @Override
        public Builder pushVlan() {
            return this.add(Instructions.pushVlan());
        }

        @Override
        public Builder pushVlan(EthType ethType) {
            return this.add(Instructions.pushVlan(ethType));
        }

        @Override
        public Builder transition(Integer tableId) {
            return this.add(Instructions.transition(tableId));
        }

        @Override
        public Builder immediate() {
            this.current = this.immediate;
            return this;
        }

        @Override
        public Builder deferred() {
            this.current = this.deferred;
            return this;
        }

        @Override
        public Builder wipeDeferred() {
            this.clear = true;
            return this;
        }

        @Override
        public Builder writeMetadata(long metadata, long metadataMask) {
            return this.add(Instructions.writeMetadata(metadata, metadataMask));
        }

        @Override
        public Builder setTunnelId(long tunnelId) {
            return this.add(Instructions.modTunnelId(tunnelId));
        }

        @Override
        public TrafficTreatment.Builder setTcpSrc(TpPort port) {
            return this.add(Instructions.modTcpSrc(port));
        }

        @Override
        public TrafficTreatment.Builder setTcpDst(TpPort port) {
            return this.add(Instructions.modTcpDst(port));
        }

        @Override
        public TrafficTreatment.Builder setUdpSrc(TpPort port) {
            return this.add(Instructions.modUdpSrc(port));
        }

        @Override
        public TrafficTreatment.Builder setUdpDst(TpPort port) {
            return this.add(Instructions.modUdpDst(port));
        }

        @Override
        public Builder setArpSpa(IpAddress addr) {
            return this.add(Instructions.modArpSpa(addr));
        }

        @Override
        public Builder setArpSha(MacAddress addr) {
            return this.add(Instructions.modArpSha(addr));
        }

        @Override
        public Builder setArpOp(short op) {
            return this.add(Instructions.modL3ArpOp(op));
        }

        @Override
        public TrafficTreatment.Builder extension(ExtensionTreatment extension, DeviceId deviceId) {
            return this.add(Instructions.extension(extension, deviceId));
        }

        @Override
        public TrafficTreatment.Builder addTreatment(TrafficTreatment treatment) {
            List<Instruction> previous = this.current;
            this.deferred();
            treatment.deferred().forEach(i -> this.add((Instruction)i));
            this.immediate();
            treatment.immediate().stream().filter(i -> i.type() != Instruction.Type.NOACTION).forEach(i -> this.add((Instruction)i));
            this.clear = treatment.clearedDeferred();
            this.current = previous;
            return this;
        }

        @Override
        public TrafficTreatment build() {
            if (this.deferred.isEmpty() && this.immediate.isEmpty() && this.table == null && !this.clear) {
                this.immediate();
                this.noAction();
            }
            return new DefaultTrafficTreatment(this.deferred, this.immediate, this.table, this.clear, this.meta, this.meter);
        }
    }
}

