/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.group;

import com.google.common.collect.ImmutableList;
import com.google.common.testing.EqualsTester;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.Test;
import org.onlab.junit.ImmutableClassChecker;
import org.onosproject.net.NetTestTools;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.group.DefaultGroupBucket;
import org.onosproject.net.group.DefaultGroupDescription;
import org.onosproject.net.group.DefaultGroupKey;
import org.onosproject.net.group.GroupBucket;
import org.onosproject.net.group.GroupBuckets;
import org.onosproject.net.group.GroupDescription;
import org.onosproject.net.group.GroupKey;

public class DefaultGroupDescriptionTest {
    byte[] keyData = "abcdefg".getBytes();
    private final GroupKey key = new DefaultGroupKey(this.keyData);
    private final TrafficTreatment treatment = DefaultTrafficTreatment.emptyTreatment();
    private final GroupBucket bucket = DefaultGroupBucket.createSelectGroupBucket((TrafficTreatment)this.treatment);
    private final GroupBuckets groupBuckets = new GroupBuckets((List)ImmutableList.of((Object)this.bucket));
    private final DefaultGroupDescription d1 = new DefaultGroupDescription(NetTestTools.did("2"), GroupDescription.Type.FAILOVER, this.groupBuckets);
    private final DefaultGroupDescription sameAsD1 = new DefaultGroupDescription((GroupDescription)this.d1);
    private final DefaultGroupDescription d2 = new DefaultGroupDescription(NetTestTools.did("2"), GroupDescription.Type.INDIRECT, this.groupBuckets);
    private final DefaultGroupDescription d3 = new DefaultGroupDescription(NetTestTools.did("3"), GroupDescription.Type.FAILOVER, this.groupBuckets, this.key, Integer.valueOf(711), NetTestTools.APP_ID);

    @Test
    public void testImmutability() {
        ImmutableClassChecker.assertThatClassIsImmutableBaseClass(DefaultGroupDescription.class);
    }

    @Test
    public void checkEquals() {
        new EqualsTester().addEqualityGroup(new Object[]{this.d1, this.sameAsD1}).addEqualityGroup(new Object[]{this.d2}).addEqualityGroup(new Object[]{this.d3}).testEquals();
    }

    @Test
    public void testConstruction() {
        MatcherAssert.assertThat((Object)this.d3.deviceId(), (Matcher)CoreMatchers.is((Object)NetTestTools.did("3")));
        MatcherAssert.assertThat((Object)this.d3.type(), (Matcher)CoreMatchers.is((Object)GroupDescription.Type.FAILOVER));
        MatcherAssert.assertThat((Object)this.d3.buckets(), (Matcher)CoreMatchers.is((Object)this.groupBuckets));
        MatcherAssert.assertThat((Object)this.d3.appId(), (Matcher)CoreMatchers.is((Object)NetTestTools.APP_ID));
        MatcherAssert.assertThat((Object)this.d3.givenGroupId(), (Matcher)CoreMatchers.is((Object)711));
        MatcherAssert.assertThat((Object)this.key.key(), (Matcher)CoreMatchers.is((Object)this.keyData));
        MatcherAssert.assertThat((Object)this.d3.appCookie().key(), (Matcher)CoreMatchers.is((Object)this.keyData));
    }
}

