/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.Charsets;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.hash.Funnel;
import com.google.common.hash.PrimitiveSink;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.Partition;
import org.onosproject.net.Provided;
import org.onosproject.net.provider.ProviderId;

public final class ClusterMetadata
implements Provided {
    private final ProviderId providerId;
    private final String name;
    private final Set<ControllerNode> nodes;
    private final Set<Partition> partitions;
    public static final Funnel<ClusterMetadata> HASH_FUNNEL = new Funnel<ClusterMetadata>(){

        public void funnel(ClusterMetadata cm, PrimitiveSink into) {
            into.putString((CharSequence)cm.name, Charsets.UTF_8);
        }
    };

    private ClusterMetadata() {
        this.providerId = null;
        this.name = null;
        this.nodes = null;
        this.partitions = null;
    }

    public ClusterMetadata(ProviderId providerId, String name, Set<ControllerNode> nodes, Set<Partition> partitions) {
        this.providerId = (ProviderId)Preconditions.checkNotNull((Object)providerId);
        this.name = (String)Preconditions.checkNotNull((Object)name);
        this.nodes = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(nodes)));
        boolean validPartitions = Collections2.transform(nodes, ControllerNode::id).containsAll(partitions.stream().flatMap(r -> r.getMembers().stream()).collect(Collectors.toSet()));
        Verify.verify((boolean)validPartitions, (String)"Partition locations must be valid cluster nodes", (Object[])new Object[0]);
        this.partitions = ImmutableSet.copyOf((Collection)((Collection)Preconditions.checkNotNull(partitions)));
    }

    public ClusterMetadata(String name, Set<ControllerNode> nodes, Set<Partition> partitions) {
        this(new ProviderId("none", "none"), name, nodes, partitions);
    }

    @Override
    public ProviderId providerId() {
        return this.providerId;
    }

    public String getName() {
        return this.name;
    }

    public Collection<ControllerNode> getNodes() {
        return this.nodes;
    }

    public Collection<Partition> getPartitions() {
        return this.partitions;
    }

    public String toString() {
        return MoreObjects.toStringHelper(ClusterMetadata.class).add("providerId", (Object)this.providerId).add("name", (Object)this.name).add("nodes", this.nodes).add("partitions", this.partitions).toString();
    }

    public int hashCode() {
        return Arrays.deepHashCode(new Object[]{this.providerId, this.name, this.nodes, this.partitions});
    }

    public boolean equals(Object object) {
        if (!ClusterMetadata.class.isInstance(object)) {
            return false;
        }
        ClusterMetadata that = (ClusterMetadata)object;
        if (!this.name.equals(that.name) || this.nodes.size() != that.nodes.size() || this.partitions.size() != that.partitions.size()) {
            return false;
        }
        return Sets.symmetricDifference(this.nodes, that.nodes).isEmpty() && Sets.symmetricDifference(this.partitions, that.partitions).isEmpty();
    }
}

