/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.event;

import org.apache.felix.scr.annotations.Component;
import org.apache.felix.scr.annotations.Reference;
import org.apache.felix.scr.annotations.ReferenceCardinality;
import org.onosproject.event.Event;
import org.onosproject.event.EventDeliveryService;
import org.onosproject.event.EventListener;
import org.onosproject.event.ListenerRegistry;
import org.onosproject.event.ListenerService;

@Component(componentAbstract=true)
public abstract class AbstractListenerManager<E extends Event, L extends EventListener<E>>
implements ListenerService<E, L> {
    protected final ListenerRegistry<E, L> listenerRegistry = new ListenerRegistry();
    @Reference(cardinality=ReferenceCardinality.MANDATORY_UNARY)
    protected EventDeliveryService eventDispatcher;

    @Override
    public void addListener(L listener) {
        this.listenerRegistry.addListener(listener);
    }

    @Override
    public void removeListener(L listener) {
        this.listenerRegistry.removeListener(listener);
    }

    protected void post(E event) {
        if (event != null && this.eventDispatcher != null) {
            this.eventDispatcher.post((Event)event);
        }
    }

    protected void bindEventDispatcher(EventDeliveryService eventDeliveryService) {
        this.eventDispatcher = eventDeliveryService;
    }

    protected void unbindEventDispatcher(EventDeliveryService eventDeliveryService) {
        if (this.eventDispatcher == eventDeliveryService) {
            this.eventDispatcher = null;
        }
    }
}

