/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.onosproject.net.DeviceId;
import org.onosproject.net.ElementId;
import org.onosproject.net.HostId;
import org.onosproject.net.IpElementId;
import org.onosproject.net.PortNumber;

public class ConnectPoint {
    private final ElementId elementId;
    private final PortNumber portNumber;

    public ConnectPoint(ElementId elementId, PortNumber portNumber) {
        this.elementId = elementId;
        this.portNumber = portNumber;
    }

    public ElementId elementId() {
        return this.elementId;
    }

    public DeviceId deviceId() {
        if (this.elementId instanceof DeviceId) {
            return (DeviceId)this.elementId;
        }
        throw new IllegalStateException("Connection point not associated with an infrastructure device");
    }

    public HostId hostId() {
        if (this.elementId instanceof HostId) {
            return (HostId)this.elementId;
        }
        throw new IllegalStateException("Connection point not associated with an end-station host");
    }

    public IpElementId ipElementId() {
        if (this.elementId instanceof IpElementId) {
            return (IpElementId)this.elementId;
        }
        throw new IllegalStateException("Connection point not associated with an pcc client");
    }

    public PortNumber port() {
        return this.portNumber;
    }

    public static ConnectPoint deviceConnectPoint(String string) {
        Preconditions.checkNotNull((Object)string);
        String[] splitted = string.split("/");
        Preconditions.checkArgument((splitted.length == 2 ? 1 : 0) != 0, (Object)"Connect point must be in \"deviceUri/portNumber\" format");
        return new ConnectPoint(DeviceId.deviceId(splitted[0]), PortNumber.portNumber(splitted[1]));
    }

    public static ConnectPoint hostConnectPoint(String string) {
        Preconditions.checkNotNull((Object)string);
        String[] splitted = string.split("/");
        Preconditions.checkArgument((splitted.length == 3 ? 1 : 0) != 0, (Object)"Connect point must be in \"hostId/vlanId/portNumber\" format");
        int lastSlash = string.lastIndexOf("/");
        return new ConnectPoint(HostId.hostId(string.substring(0, lastSlash)), PortNumber.portNumber(string.substring(lastSlash + 1, string.length())));
    }

    public int hashCode() {
        return Objects.hash(this.elementId, this.portNumber);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConnectPoint) {
            ConnectPoint other = (ConnectPoint)obj;
            return Objects.equals(this.elementId, other.elementId) && Objects.equals(this.portNumber, other.portNumber);
        }
        return false;
    }

    public String toString() {
        return this.elementId + "/" + this.portNumber;
    }
}

