/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.flow;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.hash.Funnel;
import com.google.common.hash.HashCode;
import com.google.common.hash.HashFunction;
import com.google.common.hash.Hashing;
import java.io.Serializable;
import java.util.Objects;
import org.onosproject.core.ApplicationId;
import org.onosproject.core.GroupId;
import org.onosproject.net.DeviceId;
import org.onosproject.net.flow.DefaultTrafficSelector;
import org.onosproject.net.flow.DefaultTrafficTreatment;
import org.onosproject.net.flow.FlowId;
import org.onosproject.net.flow.FlowRule;
import org.onosproject.net.flow.FlowRuleExtPayLoad;
import org.onosproject.net.flow.TrafficSelector;
import org.onosproject.net.flow.TrafficTreatment;

public class DefaultFlowRule
implements FlowRule {
    private final DeviceId deviceId;
    private final int priority;
    private final TrafficSelector selector;
    private final TrafficTreatment treatment;
    private final long created;
    private final FlowId id;
    private final Short appId;
    private final int timeout;
    private final boolean permanent;
    private final int hardTimeout;
    private final FlowRule.FlowRemoveReason reason;
    private final GroupId groupId;
    private final Integer tableId;
    private final FlowRuleExtPayLoad payLoad;

    public DefaultFlowRule(FlowRule rule) {
        this.deviceId = rule.deviceId();
        this.priority = rule.priority();
        this.selector = rule.selector();
        this.treatment = rule.treatment();
        this.appId = rule.appId();
        this.groupId = rule.groupId();
        this.id = rule.id();
        this.timeout = rule.timeout();
        this.hardTimeout = rule.hardTimeout();
        this.reason = rule.reason();
        this.permanent = rule.isPermanent();
        this.created = System.currentTimeMillis();
        this.tableId = rule.tableId();
        this.payLoad = rule.payLoad();
    }

    private DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, Integer priority, FlowId flowId, Boolean permanent, Integer timeout, Integer hardTimeout, FlowRule.FlowRemoveReason reason, Integer tableId) {
        this.deviceId = deviceId;
        this.selector = selector;
        this.treatment = treatment;
        this.priority = priority;
        this.appId = (short)(flowId.value() >>> 48);
        this.id = flowId;
        this.permanent = permanent;
        this.timeout = timeout;
        this.hardTimeout = hardTimeout;
        this.reason = reason;
        this.tableId = tableId;
        this.created = System.currentTimeMillis();
        this.groupId = new GroupId(0);
        this.payLoad = null;
    }

    @Deprecated
    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, int timeout, boolean permanent, FlowRuleExtPayLoad payLoad) {
        this(deviceId, selector, treatment, priority, appId, timeout, 0, permanent, payLoad);
    }

    @Deprecated
    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, int timeout, int hardTimeout, boolean permanent, FlowRuleExtPayLoad payLoad) {
        Preconditions.checkArgument((priority >= 0 ? 1 : 0) != 0, (Object)"Priority cannot be less than 0");
        Preconditions.checkArgument((priority <= 65535 ? 1 : 0) != 0, (Object)"Priority cannot be greater than 65535");
        this.deviceId = deviceId;
        this.priority = priority;
        this.selector = selector;
        this.treatment = treatment;
        this.appId = appId.id();
        this.groupId = new GroupId(0);
        this.timeout = timeout;
        this.reason = FlowRule.FlowRemoveReason.NO_REASON;
        this.hardTimeout = hardTimeout;
        this.permanent = permanent;
        this.tableId = 0;
        this.created = System.currentTimeMillis();
        this.payLoad = payLoad;
        this.id = FlowId.valueOf((long)this.appId.shortValue() << 48 | (long)((Integer)this.groupId.id()).intValue() << 32 | (long)this.hash() & 0xFFFFFFFFL);
    }

    @Deprecated
    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, GroupId groupId, int timeout, boolean permanent, FlowRuleExtPayLoad payLoad) {
        this(deviceId, selector, treatment, priority, appId, groupId, timeout, 0, permanent, payLoad);
    }

    @Deprecated
    public DefaultFlowRule(DeviceId deviceId, TrafficSelector selector, TrafficTreatment treatment, int priority, ApplicationId appId, GroupId groupId, int timeout, int hardTimeout, boolean permanent, FlowRuleExtPayLoad payLoad) {
        Preconditions.checkArgument((priority >= 0 ? 1 : 0) != 0, (Object)"Priority cannot be less than 0");
        Preconditions.checkArgument((priority <= 65535 ? 1 : 0) != 0, (Object)"Priority cannot be greater than 65535");
        this.deviceId = deviceId;
        this.priority = priority;
        this.selector = selector;
        this.treatment = treatment;
        this.appId = appId.id();
        this.groupId = groupId;
        this.timeout = timeout;
        this.reason = FlowRule.FlowRemoveReason.NO_REASON;
        this.hardTimeout = hardTimeout;
        this.permanent = permanent;
        this.created = System.currentTimeMillis();
        this.tableId = 0;
        this.payLoad = payLoad;
        this.id = FlowId.valueOf((long)this.appId.shortValue() << 48 | (long)((Integer)this.groupId.id()).intValue() << 32 | (long)this.hash() & 0xFFFFFFFFL);
    }

    @Override
    public FlowId id() {
        return this.id;
    }

    @Override
    public short appId() {
        return this.appId;
    }

    @Override
    public GroupId groupId() {
        return this.groupId;
    }

    @Override
    public int priority() {
        return this.priority;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public TrafficSelector selector() {
        return this.selector;
    }

    @Override
    public TrafficTreatment treatment() {
        return this.treatment;
    }

    public int hashCode() {
        return Objects.hash(this.deviceId, this.selector, this.tableId, this.payLoad);
    }

    private int hash() {
        return Objects.hash(this.deviceId, this.selector, this.tableId, this.payLoad);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof DefaultFlowRule) {
            DefaultFlowRule that = (DefaultFlowRule)obj;
            return Objects.equals(this.deviceId, that.deviceId) && Objects.equals(this.priority, that.priority) && Objects.equals(this.selector, that.selector) && Objects.equals(this.tableId, that.tableId) && Objects.equals(this.payLoad, that.payLoad);
        }
        return false;
    }

    @Override
    public boolean exactMatch(FlowRule rule) {
        return this.equals(rule) && Objects.equals((Object)this.id, (Object)rule.id()) && Objects.equals(this.treatment, rule.treatment());
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("id", (Object)Long.toHexString(this.id.value())).add("deviceId", (Object)this.deviceId).add("priority", this.priority).add("selector", this.selector.criteria()).add("treatment", this.treatment == null ? "N/A" : this.treatment).add("tableId", (Object)this.tableId).add("created", this.created).add("payLoad", (Object)this.payLoad).toString();
    }

    @Override
    public int timeout() {
        return this.timeout;
    }

    @Override
    public int hardTimeout() {
        return this.hardTimeout;
    }

    @Override
    public FlowRule.FlowRemoveReason reason() {
        return this.reason;
    }

    @Override
    public boolean isPermanent() {
        return this.permanent;
    }

    @Override
    public int tableId() {
        return this.tableId;
    }

    public long created() {
        return this.created;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public FlowRuleExtPayLoad payLoad() {
        return this.payLoad;
    }

    public static final class Builder
    implements FlowRule.Builder {
        private FlowId flowId;
        private ApplicationId appId;
        private Integer priority;
        private DeviceId deviceId;
        private Integer tableId = 0;
        private TrafficSelector selector = DefaultTrafficSelector.builder().build();
        private TrafficTreatment treatment = DefaultTrafficTreatment.builder().build();
        private Integer timeout;
        private Boolean permanent;
        private Integer hardTimeout = 0;
        private FlowRule.FlowRemoveReason reason = FlowRule.FlowRemoveReason.NO_REASON;

        @Override
        public FlowRule.Builder withCookie(long cookie) {
            this.flowId = FlowId.valueOf(cookie);
            return this;
        }

        @Override
        public FlowRule.Builder fromApp(ApplicationId appId) {
            this.appId = appId;
            return this;
        }

        @Override
        public FlowRule.Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        @Override
        public FlowRule.Builder forDevice(DeviceId deviceId) {
            this.deviceId = deviceId;
            return this;
        }

        @Override
        public FlowRule.Builder forTable(int tableId) {
            this.tableId = tableId;
            return this;
        }

        @Override
        public FlowRule.Builder withSelector(TrafficSelector selector) {
            this.selector = selector;
            return this;
        }

        @Override
        public FlowRule.Builder withTreatment(TrafficTreatment treatment) {
            this.treatment = (TrafficTreatment)Preconditions.checkNotNull((Object)treatment);
            return this;
        }

        @Override
        public FlowRule.Builder makePermanent() {
            this.timeout = 0;
            this.permanent = true;
            return this;
        }

        @Override
        public FlowRule.Builder makeTemporary(int timeout) {
            this.permanent = false;
            this.timeout = timeout;
            return this;
        }

        @Override
        public FlowRule.Builder withHardTimeout(int timeout) {
            this.permanent = false;
            this.hardTimeout = timeout;
            this.timeout = timeout;
            return this;
        }

        @Override
        public FlowRule.Builder withReason(FlowRule.FlowRemoveReason reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public FlowRule build() {
            Preconditions.checkArgument((boolean)(this.flowId != null ^ this.appId != null), (Object)"Either an application id or a cookie must be supplied");
            Preconditions.checkNotNull((Object)this.selector, (Object)"Traffic selector cannot be null");
            Preconditions.checkArgument((this.timeout != null || this.permanent != null ? 1 : 0) != 0, (Object)"Must either have a timeout or be permanent");
            Preconditions.checkNotNull((Object)this.deviceId, (Object)"Must refer to a device");
            Preconditions.checkNotNull((Object)this.priority, (Object)"Priority cannot be null");
            Preconditions.checkArgument((this.priority >= 0 ? 1 : 0) != 0, (Object)"Priority cannot be less than 0");
            Preconditions.checkArgument((this.priority <= 65535 ? 1 : 0) != 0, (Object)"Priority cannot be greater than 65535");
            FlowId localFlowId = this.appId != null ? this.computeFlowId(this.appId) : this.flowId;
            return new DefaultFlowRule(this.deviceId, this.selector, this.treatment, this.priority, localFlowId, this.permanent, this.timeout, this.hardTimeout, this.reason, this.tableId);
        }

        private FlowId computeFlowId(ApplicationId appId) {
            return FlowId.valueOf((long)appId.id() << 48 | (long)this.hash() & 0xFFFFFFFFL);
        }

        private int hash() {
            Funnel & Serializable selectorFunnel = (Funnel & Serializable)(from, into) -> from.criteria().forEach(c -> into.putUnencodedChars((CharSequence)c.toString()));
            HashFunction hashFunction = Hashing.murmur3_32();
            HashCode hashCode = hashFunction.newHasher().putUnencodedChars((CharSequence)this.deviceId.toString()).putObject((Object)this.selector, (Funnel)selectorFunnel).putInt(this.priority.intValue()).putInt(this.tableId.intValue()).hash();
            return hashCode.asInt();
        }
    }
}

