/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.key;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import org.onosproject.net.AbstractAnnotated;
import org.onosproject.net.Annotations;
import org.onosproject.net.DefaultAnnotations;
import org.onosproject.net.key.CommunityName;
import org.onosproject.net.key.DeviceKeyId;
import org.onosproject.net.key.UsernamePassword;

@Beta
public class DeviceKey
extends AbstractAnnotated {
    private final DeviceKeyId deviceKeyId;
    private String label;
    private Type type;

    DeviceKey() {
        this.deviceKeyId = null;
        this.label = null;
        this.type = null;
    }

    private DeviceKey(DeviceKeyId id, String label, Type type, Annotations ... annotations) {
        super(annotations);
        Preconditions.checkNotNull((Object)((Object)id), (Object)"The DeviceKeyId cannot be null.");
        this.deviceKeyId = id;
        this.label = label;
        this.type = type;
    }

    public DeviceKeyId deviceKeyId() {
        return this.deviceKeyId;
    }

    public String label() {
        return this.label;
    }

    public Type type() {
        return this.type;
    }

    public static DeviceKey createDeviceKeyUsingCommunityName(DeviceKeyId id, String label, String name) {
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("name", name).build();
        return new DeviceKey(id, label, Type.COMMUNITY_NAME, annotations);
    }

    public CommunityName asCommunityName() {
        Preconditions.checkState((this.type == Type.COMMUNITY_NAME ? 1 : 0) != 0, (Object)"This device key is not a COMMUNITY_NAME type.");
        String name = this.annotations().value("name");
        return CommunityName.communityName(name);
    }

    public static DeviceKey createDeviceKeyUsingUsernamePassword(DeviceKeyId id, String label, String username, String password) {
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("username", username).set("password", password).build();
        return new DeviceKey(id, label, Type.USERNAME_PASSWORD, annotations);
    }

    public static DeviceKey createDeviceKeyUsingSshKey(DeviceKeyId id, String label, String username, String password, String sshkey) {
        DefaultAnnotations annotations = DefaultAnnotations.builder().set("username", username).set("password", password).set("sshkey", sshkey).build();
        return new DeviceKey(id, label, Type.SSL_KEY, annotations);
    }

    public UsernamePassword asUsernamePassword() {
        Preconditions.checkState((this.type == Type.USERNAME_PASSWORD ? 1 : 0) != 0, (Object)"This device key is not a USERNAME_PASSWORD type.");
        String username = this.annotations().value("username");
        String password = this.annotations().value("password");
        return UsernamePassword.usernamePassword(username, password);
    }

    public static enum Type {
        COMMUNITY_NAME,
        USERNAME_PASSWORD,
        SSL_KEY;

    }
}

