/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.meter;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.onosproject.net.DeviceId;
import org.onosproject.net.meter.Band;
import org.onosproject.net.meter.Meter;
import org.onosproject.net.meter.MeterFeatures;

public final class DefaultMeterFeatures
implements MeterFeatures {
    private DeviceId deviceId;
    private long maxMeter;
    private Set<Band.Type> bandTypes;
    private Set<Meter.Unit> units;
    private boolean burst;
    private boolean stats;
    private short maxBands;
    private short maxColor;

    private DefaultMeterFeatures(DeviceId did, long maxMeter, Set<Band.Type> bandTypes, Set<Meter.Unit> units, boolean burst, boolean stats, short maxBands, short maxColor) {
        this.deviceId = did;
        this.maxMeter = maxMeter;
        this.bandTypes = bandTypes;
        this.burst = burst;
        this.stats = stats;
        this.units = units;
        this.maxBands = maxBands;
        this.maxColor = maxColor;
    }

    @Override
    public DeviceId deviceId() {
        return this.deviceId;
    }

    @Override
    public long maxMeter() {
        return this.maxMeter;
    }

    @Override
    public Set<Band.Type> bandTypes() {
        return this.bandTypes;
    }

    @Override
    public Set<Meter.Unit> unitTypes() {
        return this.units;
    }

    @Override
    public boolean isBurstSupported() {
        return this.burst;
    }

    @Override
    public boolean isStatsSupported() {
        return this.stats;
    }

    @Override
    public short maxBands() {
        return this.maxBands;
    }

    @Override
    public short maxColor() {
        return this.maxColor;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static MeterFeatures noMeterFeatures(DeviceId deviceId) {
        return DefaultMeterFeatures.builder().forDevice(deviceId).build();
    }

    public String toString() {
        return MoreObjects.toStringHelper(this.getClass()).add("deviceId", (Object)this.deviceId()).add("maxMeter", this.maxMeter()).add("maxBands", (int)this.maxBands()).add("maxColor", (int)this.maxColor()).add("bands", this.bandTypes()).add("burst", this.isBurstSupported()).add("stats", this.isStatsSupported()).add("units", this.unitTypes()).toString();
    }

    public static final class Builder
    implements MeterFeatures.Builder {
        private DeviceId did;
        private long mmeter = 0L;
        private short mbands = 0;
        private short mcolors = 0;
        private Set<Band.Type> bandTypes = new HashSet<Band.Type>();
        private Set<Meter.Unit> units1 = new HashSet<Meter.Unit>();
        private boolean burst = false;
        private boolean stats = false;

        @Override
        public MeterFeatures.Builder forDevice(DeviceId deviceId) {
            this.did = deviceId;
            return this;
        }

        @Override
        public MeterFeatures.Builder withMaxMeters(long maxMeter) {
            this.mmeter = maxMeter;
            return this;
        }

        @Override
        public MeterFeatures.Builder withMaxBands(short maxBands) {
            this.mbands = maxBands;
            return this;
        }

        @Override
        public MeterFeatures.Builder withMaxColors(short maxColors) {
            this.mcolors = maxColors;
            return this;
        }

        @Override
        public MeterFeatures.Builder withBandTypes(Set<Band.Type> types) {
            this.bandTypes = types;
            return this;
        }

        @Override
        public MeterFeatures.Builder withUnits(Set<Meter.Unit> units) {
            this.units1 = units;
            return this;
        }

        @Override
        public MeterFeatures.Builder hasBurst(boolean hasBurst) {
            this.burst = hasBurst;
            return this;
        }

        @Override
        public MeterFeatures.Builder hasStats(boolean hasStats) {
            this.stats = hasStats;
            return this;
        }

        @Override
        public MeterFeatures build() {
            Preconditions.checkNotNull((Object)this.did, (Object)"Must specify a device");
            return new DefaultMeterFeatures(this.did, this.mmeter, this.bandTypes, this.units1, this.burst, this.stats, this.mbands, this.mcolors);
        }
    }
}

