/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.store.primitives;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Function;
import org.onlab.util.ByteArraySizeHashPrinter;

public final class MapUpdate<K, V> {
    private Type type;
    private K key;
    private V value;
    private long version = -1L;

    public Type type() {
        return this.type;
    }

    public K key() {
        return this.key;
    }

    public V value() {
        return this.value;
    }

    public long version() {
        return this.version;
    }

    public <S, T> MapUpdate<S, T> map(Function<K, S> keyMapper, Function<V, T> valueMapper) {
        return MapUpdate.newBuilder().withType(this.type).withKey(keyMapper.apply(this.key)).withValue(this.value == null ? null : (Object)valueMapper.apply(this.value)).withVersion(this.version).build();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.key, this.value, this.version});
    }

    public boolean equals(Object object) {
        if (object instanceof MapUpdate) {
            MapUpdate that = (MapUpdate)object;
            return this.type == that.type && Objects.equals(this.key, that.key) && Objects.equals(this.value, that.value) && Objects.equals(this.version, that.version);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("type", (Object)this.type).add("key", this.key).add("value", this.value instanceof byte[] ? new ByteArraySizeHashPrinter((byte[])this.value) : this.value).add("version", this.version).toString();
    }

    public static <K, V> Builder<K, V> newBuilder() {
        return new Builder();
    }

    public static final class Builder<K, V> {
        private MapUpdate<K, V> update = new MapUpdate();

        public MapUpdate<K, V> build() {
            this.validateInputs();
            return this.update;
        }

        public Builder<K, V> withType(Type type) {
            ((MapUpdate)this.update).type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type cannot be null"));
            return this;
        }

        public Builder<K, V> withKey(K key) {
            ((MapUpdate)this.update).key = Preconditions.checkNotNull(key, (Object)"key cannot be null");
            return this;
        }

        public Builder<K, V> withValue(V value) {
            ((MapUpdate)this.update).value = value;
            return this;
        }

        public Builder<K, V> withVersion(long version) {
            ((MapUpdate)this.update).version = version;
            return this;
        }

        private void validateInputs() {
            Preconditions.checkNotNull((Object)((Object)((MapUpdate)this.update).type), (Object)"type must be specified");
            switch (((MapUpdate)this.update).type) {
                case VERSION_MATCH: {
                    break;
                }
                case LOCK: {
                    Preconditions.checkNotNull((Object)((MapUpdate)this.update).key, (Object)"key must be specified");
                    Preconditions.checkState((((MapUpdate)this.update).version >= 0L ? 1 : 0) != 0, (Object)"version must be specified");
                    break;
                }
                case PUT_IF_VERSION_MATCH: {
                    Preconditions.checkNotNull((Object)((MapUpdate)this.update).key, (Object)"key must be specified");
                    Preconditions.checkNotNull((Object)((MapUpdate)this.update).value, (Object)"value must be specified.");
                    Preconditions.checkState((((MapUpdate)this.update).version >= 0L ? 1 : 0) != 0, (Object)"version must be specified");
                    break;
                }
                case REMOVE_IF_VERSION_MATCH: {
                    Preconditions.checkNotNull((Object)((MapUpdate)this.update).key, (Object)"key must be specified");
                    Preconditions.checkState((((MapUpdate)this.update).version >= 0L ? 1 : 0) != 0, (Object)"version must be specified");
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown operation type");
                }
            }
        }
    }

    public static enum Type {
        LOCK,
        VERSION_MATCH,
        PUT_IF_VERSION_MATCH,
        REMOVE_IF_VERSION_MATCH;

    }
}

