/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.cluster;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.onosproject.cluster.ClusterMetadata;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.cluster.Partition;
import org.onosproject.cluster.PartitionDiff;
import org.onosproject.cluster.PartitionId;

public class ClusterMetadataDiff {
    private final ClusterMetadata oldValue;
    private final ClusterMetadata newValue;
    private final Set<ControllerNode> nodesAdded;
    private final Set<NodeId> nodesRemoved;

    public ClusterMetadataDiff(ClusterMetadata oldValue, ClusterMetadata newValue) {
        this.oldValue = oldValue;
        this.newValue = newValue;
        ImmutableSet currentNodeSet = oldValue == null ? ImmutableSet.of() : ImmutableSet.copyOf(oldValue.getNodes());
        ImmutableSet newNodeSet = newValue == null ? ImmutableSet.of() : ImmutableSet.copyOf(newValue.getNodes());
        this.nodesAdded = Sets.difference((Set)newNodeSet, (Set)currentNodeSet);
        this.nodesRemoved = Sets.difference((Set)currentNodeSet, (Set)newNodeSet).stream().map(ControllerNode::id).collect(Collectors.toSet());
    }

    public Set<ControllerNode> nodesAdded() {
        return this.nodesAdded;
    }

    public Set<NodeId> nodesRemoved() {
        return this.nodesRemoved;
    }

    public Map<PartitionId, PartitionDiff> partitionDiffs() {
        HashMap oldPartitions = Maps.newHashMap();
        this.oldValue.getPartitions().forEach(p -> oldPartitions.put(p.getId(), p));
        HashMap newPartitions = Maps.newHashMap();
        this.newValue.getPartitions().forEach(p -> newPartitions.put(p.getId(), p));
        Preconditions.checkState((boolean)Sets.symmetricDifference(oldPartitions.keySet(), newPartitions.keySet()).isEmpty(), (Object)"Number of partitions cannot change");
        HashMap partitionDiffs = Maps.newHashMap();
        oldPartitions.forEach((k, v) -> partitionDiffs.put(k, new PartitionDiff((Partition)v, (Partition)newPartitions.get(k))));
        return partitionDiffs;
    }
}

