/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.config.basics;

import org.onosproject.net.config.basics.AllowedEntityConfig;

public abstract class BasicElementConfig<S>
extends AllowedEntityConfig<S> {
    public static final String NAME = "name";
    public static final String UI_TYPE = "uiType";
    public static final String LOC_TYPE = "locType";
    public static final String LATITUDE = "latitude";
    public static final String LONGITUDE = "longitude";
    public static final String GRID_Y = "gridY";
    public static final String GRID_X = "gridX";
    protected static final String RACK_ADDRESS = "rackAddress";
    protected static final String OWNER = "owner";
    protected static final double ZERO_THRESHOLD = 9.9E-324;
    private static final double DEFAULT_COORD = 0.0;
    private static final String LOC_TYPE_GEO = "geo";
    private static final String LOC_TYPE_GRID = "grid";
    private static final int NAME_MAX_LENGTH = 256;
    private static final int UI_TYPE_MAX_LENGTH = 128;
    private static final int LOC_TYPE_MAX_LENGTH = 32;
    private static final int RACK_ADDRESS_MAX_LENGTH = 256;
    private static final int OWNER_MAX_LENGTH = 128;

    public String name() {
        return this.get(NAME, this.subject.toString());
    }

    public BasicElementConfig name(String name) {
        return (BasicElementConfig)this.setOrClear(NAME, name);
    }

    public String uiType() {
        return this.get(UI_TYPE, null);
    }

    public BasicElementConfig uiType(String uiType) {
        return (BasicElementConfig)this.setOrClear(UI_TYPE, uiType);
    }

    public String locType() {
        return this.get(LOC_TYPE, LOC_TYPE_GEO);
    }

    public BasicElementConfig locType(String locType) {
        String lt = LOC_TYPE_GRID.equals(locType) ? LOC_TYPE_GRID : LOC_TYPE_GEO;
        return (BasicElementConfig)this.setOrClear(LOC_TYPE, lt);
    }

    private boolean doubleIsZero(double value) {
        return value >= -9.9E-324 && value <= 9.9E-324;
    }

    public boolean geoCoordsSet() {
        return !this.doubleIsZero(this.latitude()) || !this.doubleIsZero(this.longitude());
    }

    public double latitude() {
        return this.get(LATITUDE, 0.0);
    }

    public BasicElementConfig latitude(Double latitude) {
        return (BasicElementConfig)this.setOrClear(LATITUDE, latitude);
    }

    public double longitude() {
        return this.get(LONGITUDE, 0.0);
    }

    public BasicElementConfig longitude(Double longitude) {
        return (BasicElementConfig)this.setOrClear(LONGITUDE, longitude);
    }

    public boolean gridCoordsSet() {
        return !this.doubleIsZero(this.gridY()) || !this.doubleIsZero(this.gridX());
    }

    public double gridY() {
        return this.get(GRID_Y, 0.0);
    }

    public BasicElementConfig gridY(Double y) {
        return (BasicElementConfig)this.setOrClear(GRID_Y, y);
    }

    public double gridX() {
        return this.get(GRID_X, 0.0);
    }

    public BasicElementConfig gridX(Double x) {
        return (BasicElementConfig)this.setOrClear(GRID_X, x);
    }

    public String rackAddress() {
        return this.get(RACK_ADDRESS, null);
    }

    public BasicElementConfig rackAddress(String address) {
        return (BasicElementConfig)this.setOrClear(RACK_ADDRESS, address);
    }

    public String owner() {
        return this.get(OWNER, null);
    }

    public BasicElementConfig owner(String owner) {
        return (BasicElementConfig)this.setOrClear(OWNER, owner);
    }

    @Override
    public boolean isValid() {
        return this.isValidLength(NAME, 256) && this.isValidLength(UI_TYPE, 128) && this.isValidLength(RACK_ADDRESS, 256) && this.isValidLength(OWNER, 128);
    }
}

