/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.domain;

import com.google.common.annotations.Beta;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.onosproject.core.ApplicationId;
import org.onosproject.net.FilteredConnectPoint;
import org.onosproject.net.NetworkResource;
import org.onosproject.net.flow.TrafficTreatment;
import org.onosproject.net.intent.Constraint;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.Key;

@Beta
public abstract class DomainIntent
extends Intent {
    private final Set<FilteredConnectPoint> filteredIngressPoints;
    private final Set<FilteredConnectPoint> filteredEgressPoints;
    private final TrafficTreatment treatment;
    private final List<Constraint> constraints;

    public DomainIntent(ApplicationId appId, Key key, Collection<NetworkResource> resources, int priority, Set<FilteredConnectPoint> filteredIngressPoints, Set<FilteredConnectPoint> filteredEgressPoints, TrafficTreatment treatment, List<Constraint> constraints) {
        super(appId, key, resources, priority);
        Preconditions.checkNotNull(filteredIngressPoints, (Object)"Ingress points cannot be null");
        Preconditions.checkArgument((!filteredIngressPoints.isEmpty() ? 1 : 0) != 0, (Object)"Ingress point cannot be empty");
        Preconditions.checkNotNull(filteredEgressPoints, (Object)"Egress points cannot be null");
        Preconditions.checkArgument((!filteredEgressPoints.isEmpty() ? 1 : 0) != 0, (Object)"Egress point cannot be empty");
        this.filteredIngressPoints = filteredIngressPoints;
        this.filteredEgressPoints = filteredEgressPoints;
        this.treatment = treatment;
        this.constraints = (List)Preconditions.checkNotNull(constraints, (Object)"Constraints cannot be null");
    }

    protected DomainIntent() {
        this.filteredIngressPoints = null;
        this.filteredEgressPoints = null;
        this.treatment = null;
        this.constraints = null;
    }

    @Override
    public boolean isInstallable() {
        return true;
    }

    public Set<FilteredConnectPoint> filteredIngressPoints() {
        return this.filteredIngressPoints;
    }

    public Set<FilteredConnectPoint> filteredEgressPoints() {
        return this.filteredEgressPoints;
    }

    public TrafficTreatment treatment() {
        return this.treatment;
    }

    public List<Constraint> constraints() {
        return this.constraints;
    }

    public static abstract class Builder
    extends Intent.Builder {
        protected List<Constraint> constraints = ImmutableList.of();
        protected TrafficTreatment treatment;

        protected Builder() {
        }

        @Override
        public Builder appId(ApplicationId appId) {
            return (Builder)super.appId(appId);
        }

        @Override
        public Builder key(Key key) {
            return (Builder)super.key(key);
        }

        @Override
        public Builder priority(int priority) {
            return (Builder)super.priority(priority);
        }

        public Builder treatment(TrafficTreatment treatment) {
            this.treatment = treatment;
            return this;
        }

        public Builder constraints(List<Constraint> constraints) {
            this.constraints = ImmutableList.copyOf(constraints);
            return this;
        }
    }
}

