/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.intent;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.onosproject.net.intent.Intent;
import org.onosproject.net.intent.IntentData;
import org.onosproject.net.intent.IntentInstallationContext;

public class IntentOperationContext<T extends Intent> {
    private IntentInstallationContext intentInstallationContext;
    private List<T> intentsToUninstall;
    private List<T> intentsToInstall;

    public IntentOperationContext(List<T> intentsToUninstall, List<T> intentsToInstall, IntentInstallationContext intentInstallationContext) {
        this.intentsToUninstall = Lists.newArrayList(intentsToUninstall);
        this.intentsToInstall = Lists.newArrayList(intentsToInstall);
        this.intentInstallationContext = intentInstallationContext;
    }

    public List<T> intentsToUninstall() {
        return this.intentsToUninstall;
    }

    public List<T> intentsToInstall() {
        return this.intentsToInstall;
    }

    public IntentInstallationContext intentInstallationContext() {
        return this.intentInstallationContext;
    }

    public Optional<IntentData> toUninstall() {
        return this.intentInstallationContext.toUninstall();
    }

    public Optional<IntentData> toInstall() {
        return this.intentInstallationContext.toInstall();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IntentOperationContext)) {
            return false;
        }
        IntentOperationContext that = (IntentOperationContext)obj;
        return Objects.equals(this.intentsToInstall, that.intentsToInstall) && Objects.equals(this.intentsToUninstall, that.intentsToUninstall) && Objects.equals(this.intentInstallationContext, this.intentInstallationContext);
    }

    public int hashCode() {
        return Objects.hash(this.intentsToInstall, this.intentsToUninstall, this.intentInstallationContext);
    }
}

