/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.net.topology;

import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.onlab.util.GuavaCollectors;
import org.onosproject.event.ListenerService;
import org.onosproject.net.ConnectPoint;
import org.onosproject.net.DeviceId;
import org.onosproject.net.DisjointPath;
import org.onosproject.net.Link;
import org.onosproject.net.Path;
import org.onosproject.net.topology.ClusterId;
import org.onosproject.net.topology.HopCountLinkWeigher;
import org.onosproject.net.topology.LinkWeigher;
import org.onosproject.net.topology.LinkWeight;
import org.onosproject.net.topology.Topology;
import org.onosproject.net.topology.TopologyCluster;
import org.onosproject.net.topology.TopologyEvent;
import org.onosproject.net.topology.TopologyGraph;
import org.onosproject.net.topology.TopologyListener;

public interface TopologyService
extends ListenerService<TopologyEvent, TopologyListener> {
    public Topology currentTopology();

    public boolean isLatest(Topology var1);

    public TopologyGraph getGraph(Topology var1);

    public Set<TopologyCluster> getClusters(Topology var1);

    public TopologyCluster getCluster(Topology var1, ClusterId var2);

    public Set<DeviceId> getClusterDevices(Topology var1, TopologyCluster var2);

    public Set<Link> getClusterLinks(Topology var1, TopologyCluster var2);

    public Set<Path> getPaths(Topology var1, DeviceId var2, DeviceId var3);

    @Deprecated
    public Set<Path> getPaths(Topology var1, DeviceId var2, DeviceId var3, LinkWeight var4);

    public Set<Path> getPaths(Topology var1, DeviceId var2, DeviceId var3, LinkWeigher var4);

    default public Set<Path> getKShortestPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher, int maxPaths) {
        return (Set)this.getKShortestPaths(topology, src, dst, weigher).limit(maxPaths).collect(GuavaCollectors.toImmutableSet());
    }

    default public Stream<Path> getKShortestPaths(Topology topology, DeviceId src, DeviceId dst) {
        return this.getKShortestPaths(topology, src, dst, HopCountLinkWeigher.DEFAULT_HOP_COUNT_WEIGHER);
    }

    default public Stream<Path> getKShortestPaths(Topology topology, DeviceId src, DeviceId dst, LinkWeigher weigher) {
        return this.getPaths(topology, src, dst, weigher).stream();
    }

    public Set<DisjointPath> getDisjointPaths(Topology var1, DeviceId var2, DeviceId var3);

    @Deprecated
    public Set<DisjointPath> getDisjointPaths(Topology var1, DeviceId var2, DeviceId var3, LinkWeight var4);

    public Set<DisjointPath> getDisjointPaths(Topology var1, DeviceId var2, DeviceId var3, LinkWeigher var4);

    public Set<DisjointPath> getDisjointPaths(Topology var1, DeviceId var2, DeviceId var3, Map<Link, Object> var4);

    @Deprecated
    public Set<DisjointPath> getDisjointPaths(Topology var1, DeviceId var2, DeviceId var3, LinkWeight var4, Map<Link, Object> var5);

    public Set<DisjointPath> getDisjointPaths(Topology var1, DeviceId var2, DeviceId var3, LinkWeigher var4, Map<Link, Object> var5);

    public boolean isInfrastructure(Topology var1, ConnectPoint var2);

    public boolean isBroadcastPoint(Topology var1, ConnectPoint var2);
}

