/*
 * Decompiled with CFR 0.152.
 */
package org.onosproject.ui.model.topo;

import com.google.common.base.Preconditions;
import org.onlab.packet.IpAddress;
import org.onosproject.cluster.ControllerNode;
import org.onosproject.cluster.NodeId;
import org.onosproject.ui.model.topo.UiElement;
import org.onosproject.ui.model.topo.UiTopology;

public class UiClusterMember
extends UiElement {
    private static final String NODE_CANNOT_BE_NULL = "Node cannot be null";
    private final UiTopology topology;
    private final NodeId nodeId;
    private ControllerNode.State state = ControllerNode.State.INACTIVE;

    public UiClusterMember(UiTopology topology, ControllerNode cnode) {
        Preconditions.checkNotNull((Object)cnode, (Object)NODE_CANNOT_BE_NULL);
        this.topology = topology;
        this.nodeId = cnode.id();
    }

    public String toString() {
        return "UiClusterMember{" + this.nodeId + ", online=" + this.isOnline() + ", ready=" + this.isReady() + "}";
    }

    @Override
    public String idAsString() {
        return this.id().toString();
    }

    public ControllerNode backingNode() {
        return this.topology.services.cluster().getNode(this.nodeId);
    }

    public void setState(ControllerNode.State state) {
        this.state = state;
    }

    public NodeId id() {
        return this.nodeId;
    }

    public IpAddress ip() {
        return this.backingNode().ip();
    }

    public boolean isOnline() {
        return this.state.isActive();
    }

    public boolean isReady() {
        return this.state.isReady();
    }
}

